/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TestUtil {
    public static void assertContainsIgnoreCase(String source, String ... contains) {
        String lowerSource = source.toLowerCase();
        int offset = 0;
        for (String contain : contains) {
            String lowerContain = contain.toLowerCase();
            int idx = lowerSource.indexOf(lowerContain, offset);
            String msg = "'" + contain + "' not found in '" + source + "' (searching from position " + offset + ")";
            assert (idx >= 0) : msg;
            offset = idx + lowerContain.length();
        }
    }

    public static boolean checkContainsIgnoreCase(String source, String ... contains) {
        String lowerSource = source.toLowerCase();
        int offset = 0;
        for (String contain : contains) {
            String lowerContain = contain.toLowerCase();
            int idx = lowerSource.indexOf(lowerContain, offset);
            if (idx == -1) {
                return false;
            }
            offset = idx + lowerContain.length();
        }
        return true;
    }

    public static String fetchResource(String name) {
        try {
            URL url = TestUtil.class.getResource("/" + name);
            if (url == null) {
                throw new IllegalArgumentException("Resource not found: " + name);
            }
            Path resPath = Paths.get(url.toURI());
            return new String(Files.readAllBytes(resPath), StandardCharsets.UTF_8);
        }
        catch (IOException | URISyntaxException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static boolean isReleaseMode() {
        return Boolean.parseBoolean(System.getProperty("performRelease", "false"));
    }
}

