/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.SystemUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

public final class UniqueIdGenerator {
    public static final String JAVA_UTIL_CLUSTERID = "JAVA_UTIL_CLUSTERID";
    public static final String KUBERNETES_POD_NAME = "HOSTNAME";
    public static final String TANZU_INSTANCE_ID = "VMWARE_TANZU_INSTANCE_ID";
    public static final String CF_INSTANCE_INDEX = "CF_INSTANCE_INDEX";
    private static final Logger LOG = Logger.getLogger(UniqueIdGenerator.class.getName());
    private static final long SEQUENCE_STEP = 100L;
    private static final long FACTOR_16 = 100000L;
    private static final int SEQ_LIMIT_16 = 1000;
    private static final long FACTOR_19 = 1000000L;
    private static final int SEQ_LIMIT_19 = 10000;
    private static final AtomicLong LAST_ID_16;
    private static final AtomicLong LAST_ID_19;
    private static final int serverId;
    private static final MethodHandle ON_SPIN_WAIT_HANDLE;

    private UniqueIdGenerator() {
    }

    public static long getUniqueId() {
        return UniqueIdGenerator.nextId(LAST_ID_16, 100000L, 1000);
    }

    public static long getUniqueId19() {
        return UniqueIdGenerator.nextId(LAST_ID_19, 1000000L, 10000);
    }

    public static Date getDate(long uniqueId) {
        if (uniqueId < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId: must be non-negative");
        }
        return new Date(uniqueId / 100000L);
    }

    public static Date getDate19(long uniqueId19) {
        if (uniqueId19 < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId19: must be non-negative");
        }
        return new Date(uniqueId19 / 1000000L);
    }

    public static Instant getInstant(long uniqueId) {
        if (uniqueId < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId: must be non-negative");
        }
        return Instant.ofEpochMilli(uniqueId / 100000L);
    }

    public static Instant getInstant19(long uniqueId19) {
        if (uniqueId19 < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId19: must be non-negative");
        }
        return Instant.ofEpochMilli(uniqueId19 / 1000000L);
    }

    public static int getServerIdConfigured() {
        return serverId;
    }

    private static long nextId(AtomicLong lastId, long factor, int perMsLimit) {
        long now = System.currentTimeMillis();
        while (true) {
            long base;
            long prev = lastId.get();
            long prevMs = prev / factor;
            long baseMs = Math.max(now, prevMs);
            long cand = base = baseMs * factor + (long)serverId;
            if (prev >= base) {
                long seqIndex = (prev - base) / 100L + 1L;
                cand = base + seqIndex * 100L;
                if (seqIndex >= (long)perMsLimit) {
                    long nextMs;
                    now = nextMs = UniqueIdGenerator.waitForNextMillis(baseMs);
                    continue;
                }
            }
            if (lastId.compareAndSet(prev, cand)) {
                return cand;
            }
            UniqueIdGenerator.onSpinWait();
        }
    }

    private static long waitForNextMillis(long lastMs) {
        long ts = System.currentTimeMillis();
        int parkCount = 0;
        while (ts <= lastMs) {
            for (int i = 0; i < 64; ++i) {
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                UniqueIdGenerator.onSpinWait();
                ts = System.currentTimeMillis();
                if (ts <= lastMs) continue;
                return ts;
            }
            LockSupport.parkNanos(100000L);
            ts = System.currentTimeMillis();
            if (++parkCount <= 64) continue;
            LockSupport.parkNanos(1000000L);
        }
        return ts;
    }

    private static void onSpinWait() {
        if (ON_SPIN_WAIT_HANDLE != null) {
            try {
                ON_SPIN_WAIT_HANDLE.invokeExact();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int getServerIdFromVarName(String externalVarName) {
        try {
            String id = SystemUtilities.getExternalVariable(externalVarName);
            if (StringUtilities.isEmpty(id)) {
                return -1;
            }
            int parsedId = Integer.parseInt(id.trim());
            int normalized = (int)Math.abs((long)parsedId);
            return Math.floorMod(normalized, 100);
        }
        catch (NumberFormatException | SecurityException e) {
            LOG.fine("Unable to retrieve server id from " + externalVarName + ": " + e.getMessage());
            return -1;
        }
    }

    static {
        LoggingConfig.init();
        LAST_ID_16 = new AtomicLong(0L);
        LAST_ID_19 = new AtomicLong(0L);
        int id = -1;
        String setVia = null;
        String indirection = null;
        id = UniqueIdGenerator.getServerIdFromVarName(JAVA_UTIL_CLUSTERID);
        if (id != -1) {
            setVia = "environment variable: JAVA_UTIL_CLUSTERID";
        }
        if (id == -1 && StringUtilities.hasContent(indirection = SystemUtilities.getExternalVariable(JAVA_UTIL_CLUSTERID)) && (id = UniqueIdGenerator.getServerIdFromVarName(indirection)) != -1) {
            setVia = "indirect environment variable: " + indirection;
        }
        String hostName = null;
        if (id == -1 && StringUtilities.hasContent(hostName = SystemUtilities.getExternalVariable(KUBERNETES_POD_NAME))) {
            try {
                int dash = hostName.lastIndexOf(45);
                if (dash >= 0 && dash + 1 < hostName.length()) {
                    String ordinal = hostName.substring(dash + 1);
                    id = Math.floorMod(Integer.parseInt(ordinal), 100);
                    setVia = "Kubernetes pod ordinal from HOSTNAME: " + hostName;
                }
            }
            catch (Exception dash) {
                // empty catch block
            }
        }
        if (id == -1 && (id = UniqueIdGenerator.getServerIdFromVarName(TANZU_INSTANCE_ID)) != -1) {
            setVia = "VMware Tanzu instance ID";
        }
        if (id == -1 && (id = UniqueIdGenerator.getServerIdFromVarName(CF_INSTANCE_INDEX)) != -1) {
            setVia = "Cloud Foundry instance index";
        }
        if (id == -1) {
            if (hostName == null) {
                hostName = SystemUtilities.getExternalVariable(KUBERNETES_POD_NAME);
            }
            if (StringUtilities.hasContent(hostName)) {
                id = Math.floorMod(hostName.hashCode(), 100);
                setVia = "hostname hash: " + hostName;
            }
        }
        if (id == -1) {
            SecureRandom random = new SecureRandom();
            id = Math.floorMod(random.nextInt(), 100);
            setVia = "SecureRandom";
        }
        serverId = id;
        LOG.info("java-util using node id=" + id + " (last two digits of UniqueId). Set via " + setVia);
        MethodHandle handle = null;
        try {
            handle = MethodHandles.lookup().findStatic(Thread.class, "onSpinWait", MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        ON_SPIN_WAIT_HANDLE = handle;
    }
}

