/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.MultiKeyMap;
import com.cedarsoftware.util.convert.ArrayConversions;
import com.cedarsoftware.util.convert.AtomicBooleanConversions;
import com.cedarsoftware.util.convert.AtomicIntegerConversions;
import com.cedarsoftware.util.convert.AtomicLongConversions;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.BooleanConversions;
import com.cedarsoftware.util.convert.ByteArrayConversions;
import com.cedarsoftware.util.convert.ByteBufferConversions;
import com.cedarsoftware.util.convert.ByteConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.CharArrayConversions;
import com.cedarsoftware.util.convert.CharBufferConversions;
import com.cedarsoftware.util.convert.CharacterArrayConversions;
import com.cedarsoftware.util.convert.CharacterConversions;
import com.cedarsoftware.util.convert.ClassConversions;
import com.cedarsoftware.util.convert.CollectionConversions;
import com.cedarsoftware.util.convert.CollectionHandling;
import com.cedarsoftware.util.convert.ColorConversions;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.ConverterOptions;
import com.cedarsoftware.util.convert.CurrencyConversions;
import com.cedarsoftware.util.convert.DateConversions;
import com.cedarsoftware.util.convert.DimensionConversions;
import com.cedarsoftware.util.convert.DoubleConversions;
import com.cedarsoftware.util.convert.DurationConversions;
import com.cedarsoftware.util.convert.EnumConversions;
import com.cedarsoftware.util.convert.FileConversions;
import com.cedarsoftware.util.convert.InsetsConversions;
import com.cedarsoftware.util.convert.InstantConversions;
import com.cedarsoftware.util.convert.LocalDateConversions;
import com.cedarsoftware.util.convert.LocalDateTimeConversions;
import com.cedarsoftware.util.convert.LocalTimeConversions;
import com.cedarsoftware.util.convert.LocaleConversions;
import com.cedarsoftware.util.convert.MapConversions;
import com.cedarsoftware.util.convert.MonthDayConversions;
import com.cedarsoftware.util.convert.NumberConversions;
import com.cedarsoftware.util.convert.ObjectConversions;
import com.cedarsoftware.util.convert.OffsetDateTimeConversions;
import com.cedarsoftware.util.convert.OffsetTimeConversions;
import com.cedarsoftware.util.convert.PathConversions;
import com.cedarsoftware.util.convert.PatternConversions;
import com.cedarsoftware.util.convert.PeriodConversions;
import com.cedarsoftware.util.convert.PointConversions;
import com.cedarsoftware.util.convert.RectangleConversions;
import com.cedarsoftware.util.convert.SqlDateConversions;
import com.cedarsoftware.util.convert.StringConversions;
import com.cedarsoftware.util.convert.ThrowableConversions;
import com.cedarsoftware.util.convert.TimeZoneConversions;
import com.cedarsoftware.util.convert.TimestampConversions;
import com.cedarsoftware.util.convert.UUIDConversions;
import com.cedarsoftware.util.convert.UniversalConversions;
import com.cedarsoftware.util.convert.UriConversions;
import com.cedarsoftware.util.convert.UrlConversions;
import com.cedarsoftware.util.convert.VoidConversions;
import com.cedarsoftware.util.convert.YearConversions;
import com.cedarsoftware.util.convert.YearMonthConversions;
import com.cedarsoftware.util.convert.ZoneIdConversions;
import com.cedarsoftware.util.convert.ZoneOffsetConversions;
import com.cedarsoftware.util.convert.ZonedDateTimeConversions;
import com.cedarsoftware.util.geom.Color;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Pattern;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public final class Converter {
    private static final Convert<?> UNSUPPORTED = Converter::unsupported;
    static final String VALUE = "_v";
    public static final String PRECISION_MILLIS = "millis";
    public static final String PRECISION_NANOS = "nanos";
    private static final Map<Class<?>, SortedSet<ClassLevel>> cacheParentTypes = new ClassValueMap<SortedSet<ClassLevel>>();
    private static final Map<Class<?>, SortedSet<ClassLevel>> cacheCompleteHierarchy = new ClassValueMap<SortedSet<ClassLevel>>();
    private static final MultiKeyMap<InheritancePair[]> cacheInheritancePairs = MultiKeyMap.builder().flattenDimensions(true).collectionKeyMode(MultiKeyMap.CollectionKeyMode.COLLECTIONS_NOT_EXPANDED).build();
    private static final Map<ConversionPair, Convert<?>> CONVERSION_DB = new ConcurrentHashMap(4096, 0.8f);
    private final Map<ConversionPair, Convert<?>> USER_DB = new ConcurrentHashMap(16, 0.8f);
    private static final Map<ConversionPair, Convert<?>> FULL_CONVERSION_CACHE = new ConcurrentHashMap(1024, 0.75f);
    private static final Map<Class<?>, String> CUSTOM_ARRAY_NAMES = new ClassValueMap<String>();
    private static final ClassValueMap<Boolean> SIMPLE_TYPE_CACHE = new ClassValueMap();
    private static final ClassValueMap<Boolean> SELF_CONVERSION_CACHE = new ClassValueMap();
    private static final AtomicLong INSTANCE_ID_GENERATOR = new AtomicLong(1L);
    private static final Convert<?> IDENTITY_CONVERTER = (source, converter) -> source;
    private final ConverterOptions options;
    private final long instanceId;
    private volatile boolean hasUserConversions;
    private static List<SurrogatePrimaryPair> SURROGATE_TO_PRIMARY_PAIRS;
    private static List<SurrogatePrimaryPair> PRIMARY_TO_SURROGATE_PAIRS;

    public static ConversionPair pair(Class<?> source, Class<?> target, long instanceId) {
        return new ConversionPair(source, target, instanceId);
    }

    public static ConversionPair pair(Class<?> source, Class<?> target) {
        return new ConversionPair(source, target, 0L);
    }

    public ConverterOptions getOptions() {
        return this.options;
    }

    private static void buildFactoryConversions() {
        CONVERSION_DB.put(Converter.pair(Byte.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Integer.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Float.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Double.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Number.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Duration.class, Number.class), DurationConversions::toNumber);
        CONVERSION_DB.put(Converter.pair(Void.class, Byte.TYPE), NumberConversions::toByteZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Byte.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Byte.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Integer.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Long.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Float.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Double.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Byte.class), BooleanConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Character.class, Byte.class), CharacterConversions::toByte);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Byte.class), NumberConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Map.class, Byte.class), MapConversions::toByte);
        CONVERSION_DB.put(Converter.pair(String.class, Byte.class), StringConversions::toByte);
        CONVERSION_DB.put(Converter.pair(Void.class, Short.TYPE), NumberConversions::toShortZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Short.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Short.class, Short.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Integer.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Long.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Float.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Double.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Short.class), BooleanConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Character.class, Short.class), CharacterConversions::toShort);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Short.class), NumberConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Map.class, Short.class), MapConversions::toShort);
        CONVERSION_DB.put(Converter.pair(String.class, Short.class), StringConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Year.class, Short.class), YearConversions::toShort);
        CONVERSION_DB.put(Converter.pair(Void.class, Integer.TYPE), NumberConversions::toIntZero);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Integer.TYPE), UniversalConversions::atomicIntegerToInt);
        CONVERSION_DB.put(Converter.pair(Void.class, Integer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Short.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Integer.class, Integer.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Float.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Double.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Integer.class), BooleanConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Character.class, Integer.class), CharacterConversions::toInt);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Integer.class), NumberConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Map.class, Integer.class), MapConversions::toInt);
        CONVERSION_DB.put(Converter.pair(String.class, Integer.class), StringConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Color.class, Integer.class), ColorConversions::toInteger);
        CONVERSION_DB.put(Converter.pair(Year.class, Integer.class), YearConversions::toInt);
        CONVERSION_DB.put(Converter.pair(Void.class, Long.TYPE), NumberConversions::toLongZero);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Long.TYPE), UniversalConversions::atomicLongToLong);
        CONVERSION_DB.put(Converter.pair(Void.class, Long.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Short.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Integer.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Long.class, Long.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Float.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Double.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Long.class), BooleanConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Character.class, Long.class), CharacterConversions::toLong);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, Long.class), NumberConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Date.class, Long.class), DateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Long.class), SqlDateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Long.class), TimestampConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Instant.class, Long.class), InstantConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Duration.class, Long.class), DurationConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Long.class), LocalDateConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Long.class), LocalTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Long.class), LocalDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Long.class), OffsetTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Long.class), OffsetDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Long.class), ZonedDateTimeConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Map.class, Long.class), MapConversions::toLong);
        CONVERSION_DB.put(Converter.pair(String.class, Long.class), StringConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Color.class, Long.class), ColorConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Year.class, Long.class), YearConversions::toLong);
        CONVERSION_DB.put(Converter.pair(Void.class, Float.TYPE), NumberConversions::toFloatZero);
        CONVERSION_DB.put(Converter.pair(Void.class, Float.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Short.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Integer.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Long.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Float.class, Float.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Double.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Float.class), BooleanConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Character.class, Float.class), CharacterConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Float.class), NumberConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Map.class, Float.class), MapConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(String.class, Float.class), StringConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Year.class, Float.class), YearConversions::toFloat);
        CONVERSION_DB.put(Converter.pair(Void.class, Double.TYPE), NumberConversions::toDoubleZero);
        CONVERSION_DB.put(Converter.pair(Year.class, Double.TYPE), YearConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Void.class, Double.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Short.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Integer.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Long.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Float.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Double.class, Double.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Double.class), BooleanConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Character.class, Double.class), CharacterConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Duration.class, Double.class), DurationConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Instant.class, Double.class), InstantConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Double.class), LocalTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Double.class), LocalDateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Double.class), LocalDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Double.class), ZonedDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Double.class), OffsetTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Double.class), OffsetDateTimeConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Date.class, Double.class), DateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Double.class), SqlDateConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Double.class), TimestampConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Double.class), NumberConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Map.class, Double.class), MapConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(String.class, Double.class), StringConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Year.class, Double.class), YearConversions::toDouble);
        CONVERSION_DB.put(Converter.pair(Void.class, Boolean.TYPE), VoidConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Boolean.TYPE), UniversalConversions::atomicBooleanToBoolean);
        CONVERSION_DB.put(Converter.pair(Duration.class, Boolean.TYPE), DurationConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, Boolean.class), AtomicBooleanConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Duration.class, Boolean.class), DurationConversions::toBooleanWrapper);
        CONVERSION_DB.put(Converter.pair(Void.class, Boolean.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Short.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Integer.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Long.class, Boolean.class), NumberConversions::isIntTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Float.class, Boolean.class), NumberConversions::isFloatTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Double.class, Boolean.class), NumberConversions::isFloatTypeNotZero);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Boolean.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Character.class, Boolean.class), CharacterConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Boolean.class), NumberConversions::isBigIntegerNotZero);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Boolean.class), NumberConversions::isBigDecimalNotZero);
        CONVERSION_DB.put(Converter.pair(Map.class, Boolean.class), MapConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(String.class, Boolean.class), StringConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Boolean.class), DimensionConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Point.class, Boolean.class), PointConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Rectangle.class, Boolean.class), RectangleConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Insets.class, Boolean.class), InsetsConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(UUID.class, Boolean.class), UUIDConversions::toBoolean);
        CONVERSION_DB.put(Converter.pair(Void.class, Character.TYPE), VoidConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Void.class, Character.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Character.class), ByteConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Short.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Integer.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Long.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Float.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Double.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Character.class), BooleanConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Character.class, Character.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Character.class), NumberConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Map.class, Character.class), MapConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(String.class, Character.class), StringConversions::toCharacter);
        CONVERSION_DB.put(Converter.pair(Void.class, BigInteger.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Short.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Integer.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Long.class, BigInteger.class), NumberConversions::integerTypeToBigInteger);
        CONVERSION_DB.put(Converter.pair(Float.class, BigInteger.class), NumberConversions::floatingPointToBigInteger);
        CONVERSION_DB.put(Converter.pair(Double.class, BigInteger.class), NumberConversions::floatingPointToBigInteger);
        CONVERSION_DB.put(Converter.pair(Boolean.class, BigInteger.class), BooleanConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Character.class, BigInteger.class), CharacterConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, BigInteger.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, BigInteger.class), BigDecimalConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Date.class, BigInteger.class), DateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, BigInteger.class), SqlDateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, BigInteger.class), TimestampConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Duration.class, BigInteger.class), DurationConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Instant.class, BigInteger.class), InstantConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, BigInteger.class), LocalTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, BigInteger.class), LocalDateConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, BigInteger.class), LocalDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, BigInteger.class), ZonedDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, BigInteger.class), OffsetTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, BigInteger.class), OffsetDateTimeConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(UUID.class, BigInteger.class), UUIDConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Calendar.class, BigInteger.class), CalendarConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Map.class, BigInteger.class), MapConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(String.class, BigInteger.class), StringConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Year.class, BigInteger.class), YearConversions::toBigInteger);
        CONVERSION_DB.put(Converter.pair(Void.class, BigDecimal.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Short.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Integer.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Long.class, BigDecimal.class), NumberConversions::integerTypeToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Float.class, BigDecimal.class), NumberConversions::floatingPointToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Double.class, BigDecimal.class), NumberConversions::floatingPointToBigDecimal);
        CONVERSION_DB.put(Converter.pair(Boolean.class, BigDecimal.class), BooleanConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Character.class, BigDecimal.class), CharacterConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, BigDecimal.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, BigDecimal.class), BigIntegerConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Date.class, BigDecimal.class), DateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, BigDecimal.class), SqlDateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, BigDecimal.class), TimestampConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Instant.class, BigDecimal.class), InstantConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Duration.class, BigDecimal.class), DurationConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, BigDecimal.class), LocalTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, BigDecimal.class), LocalDateConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, BigDecimal.class), LocalDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, BigDecimal.class), ZonedDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, BigDecimal.class), OffsetTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, BigDecimal.class), OffsetDateTimeConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(UUID.class, BigDecimal.class), UUIDConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Color.class, BigDecimal.class), ColorConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Calendar.class, BigDecimal.class), CalendarConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Map.class, BigDecimal.class), MapConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(String.class, BigDecimal.class), StringConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Year.class, BigDecimal.class), YearConversions::toBigDecimal);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicBoolean.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Boolean.class, AtomicBoolean.class), BooleanConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(AtomicBoolean.class, AtomicBoolean.class), AtomicBooleanConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Year.class, AtomicBoolean.class), YearConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicBoolean.class), MapConversions::toAtomicBoolean);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicInteger.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Integer.class, AtomicInteger.class), NumberConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(AtomicInteger.class, AtomicInteger.class), AtomicIntegerConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicInteger.class), MapConversions::toAtomicInteger);
        CONVERSION_DB.put(Converter.pair(Void.class, AtomicLong.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, AtomicLong.class), NumberConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(AtomicLong.class, AtomicLong.class), AtomicLongConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Map.class, AtomicLong.class), MapConversions::toAtomicLong);
        CONVERSION_DB.put(Converter.pair(Void.class, Date.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Date.class), NumberConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Double.class, Date.class), DoubleConversions::toDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Date.class), BigIntegerConversions::toDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Date.class), BigDecimalConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Date.class, Date.class), DateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Date.class), SqlDateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Date.class), TimestampConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, Date.class), InstantConversions::toDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Date.class), LocalDateConversions::toDate);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Date.class), LocalDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Date.class), ZonedDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Date.class), OffsetDateTimeConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Duration.class, Date.class), DurationConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Map.class, Date.class), MapConversions::toDate);
        CONVERSION_DB.put(Converter.pair(String.class, Date.class), StringConversions::toDate);
        CONVERSION_DB.put(Converter.pair(Void.class, java.sql.Date.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, java.sql.Date.class), NumberConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Double.class, java.sql.Date.class), DoubleConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, java.sql.Date.class), BigIntegerConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, java.sql.Date.class), BigDecimalConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, java.sql.Date.class), SqlDateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Date.class, java.sql.Date.class), DateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, java.sql.Date.class), TimestampConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Duration.class, java.sql.Date.class), DurationConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, java.sql.Date.class), InstantConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, java.sql.Date.class), LocalDateConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, java.sql.Date.class), LocalDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, java.sql.Date.class), ZonedDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, java.sql.Date.class), OffsetDateTimeConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Map.class, java.sql.Date.class), MapConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(String.class, java.sql.Date.class), StringConversions::toSqlDate);
        CONVERSION_DB.put(Converter.pair(Void.class, Timestamp.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Timestamp.class), NumberConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Double.class, Timestamp.class), DoubleConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Timestamp.class), BigIntegerConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Timestamp.class), BigDecimalConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Timestamp.class), DateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Timestamp.class), SqlDateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Date.class, Timestamp.class), DateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Duration.class, Timestamp.class), DurationConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Instant.class, Timestamp.class), InstantConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Timestamp.class), LocalDateConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Timestamp.class), LocalDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Timestamp.class), ZonedDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Timestamp.class), OffsetDateTimeConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Map.class, Timestamp.class), MapConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(String.class, Timestamp.class), StringConversions::toTimestamp);
        CONVERSION_DB.put(Converter.pair(Void.class, Calendar.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, Calendar.class), NumberConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Double.class, Calendar.class), DoubleConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Calendar.class), BigIntegerConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Calendar.class), BigDecimalConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Date.class, Calendar.class), DateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Calendar.class), SqlDateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Calendar.class), TimestampConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Instant.class, Calendar.class), InstantConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Calendar.class), LocalTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Calendar.class), LocalDateConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Calendar.class), LocalDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Calendar.class), ZonedDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Calendar.class), OffsetDateTimeConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Duration.class, Calendar.class), DurationConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Calendar.class), CalendarConversions::clone);
        CONVERSION_DB.put(Converter.pair(Map.class, Calendar.class), MapConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(String.class, Calendar.class), StringConversions::toCalendar);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalDate.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalDate.class), NumberConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalDate.class), DoubleConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalDate.class), BigIntegerConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalDate.class), BigDecimalConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, LocalDate.class), SqlDateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalDate.class), DateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalDate.class), DateConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalDate.class), InstantConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Calendar.class, LocalDate.class), CalendarConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, LocalDate.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalDate.class), LocalDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalDate.class), ZonedDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalDate.class), OffsetDateTimeConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Duration.class, LocalDate.class), DurationConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalDate.class), MapConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(String.class, LocalDate.class), StringConversions::toLocalDate);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalDateTime.class), NumberConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalDateTime.class), DoubleConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalDateTime.class), BigIntegerConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalDateTime.class), BigDecimalConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, LocalDateTime.class), SqlDateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalDateTime.class), TimestampConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalDateTime.class), DateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalDateTime.class), InstantConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalDateTime.class), LocalDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, LocalDateTime.class), LocalDateConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, LocalDateTime.class), CalendarConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalDateTime.class), ZonedDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalDateTime.class), OffsetDateTimeConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Duration.class, LocalDateTime.class), DurationConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalDateTime.class), MapConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, LocalDateTime.class), StringConversions::toLocalDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, LocalTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, LocalTime.class), NumberConversions::longNanosToLocalTime);
        CONVERSION_DB.put(Converter.pair(Double.class, LocalTime.class), DoubleConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, LocalTime.class), BigIntegerConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, LocalTime.class), BigDecimalConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, LocalTime.class), DateConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Date.class, LocalTime.class), DateConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, LocalTime.class), InstantConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, LocalTime.class), LocalDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, LocalTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, LocalTime.class), ZonedDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, LocalTime.class), OffsetDateTimeConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Duration.class, LocalTime.class), DurationConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Map.class, LocalTime.class), MapConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(String.class, LocalTime.class), StringConversions::toLocalTime);
        CONVERSION_DB.put(Converter.pair(Void.class, ZonedDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, ZonedDateTime.class), NumberConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, ZonedDateTime.class), DoubleConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, ZonedDateTime.class), BigIntegerConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, ZonedDateTime.class), BigDecimalConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, ZonedDateTime.class), SqlDateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, ZonedDateTime.class), DateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, ZonedDateTime.class), DateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, ZonedDateTime.class), InstantConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, ZonedDateTime.class), LocalDateConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, ZonedDateTime.class), LocalDateTimeConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, ZonedDateTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, ZonedDateTime.class), OffsetDateTimeConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Calendar.class, ZonedDateTime.class), CalendarConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Duration.class, ZonedDateTime.class), DurationConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Map.class, ZonedDateTime.class), MapConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, ZonedDateTime.class), StringConversions::toZonedDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, OffsetDateTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, OffsetDateTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Map.class, OffsetDateTime.class), MapConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(String.class, OffsetDateTime.class), StringConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Long.class, OffsetDateTime.class), NumberConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Double.class, OffsetDateTime.class), DoubleConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, OffsetDateTime.class), BigIntegerConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, OffsetDateTime.class), BigDecimalConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, OffsetDateTime.class), SqlDateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Date.class, OffsetDateTime.class), DateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, OffsetDateTime.class), TimestampConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, OffsetDateTime.class), LocalDateConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Instant.class, OffsetDateTime.class), InstantConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, OffsetDateTime.class), ZonedDateTimeConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, OffsetDateTime.class), LocalDateTimeConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Duration.class, OffsetDateTime.class), DurationConversions::toOffsetDateTime);
        CONVERSION_DB.put(Converter.pair(Void.class, OffsetTime.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Long.class, OffsetTime.class), NumberConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Double.class, OffsetTime.class), DoubleConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, OffsetTime.class), BigIntegerConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, OffsetTime.class), BigDecimalConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, OffsetTime.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, OffsetTime.class), OffsetDateTimeConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Map.class, OffsetTime.class), MapConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(String.class, OffsetTime.class), StringConversions::toOffsetTime);
        CONVERSION_DB.put(Converter.pair(Void.class, UUID.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(UUID.class, UUID.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, UUID.class), StringConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(Boolean.class, UUID.class), BooleanConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, UUID.class), BigIntegerConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, UUID.class), BigDecimalConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(Map.class, UUID.class), MapConversions::toUUID);
        CONVERSION_DB.put(Converter.pair(Void.class, Class.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Class.class, Class.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Map.class, Class.class), MapConversions::toClass);
        CONVERSION_DB.put(Converter.pair(String.class, Class.class), StringConversions::toClass);
        CONVERSION_DB.put(Converter.pair(Void.class, Color.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Color.class, Color.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Color.class), StringConversions::toColor);
        CONVERSION_DB.put(Converter.pair(Map.class, Color.class), MapConversions::toColor);
        CONVERSION_DB.put(Converter.pair(int[].class, Color.class), ArrayConversions::toColor);
        CONVERSION_DB.put(Converter.pair(Void.class, Dimension.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Dimension.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Dimension.class), StringConversions::toDimension);
        CONVERSION_DB.put(Converter.pair(Map.class, Dimension.class), MapConversions::toDimension);
        CONVERSION_DB.put(Converter.pair(int[].class, Dimension.class), ArrayConversions::toDimension);
        CONVERSION_DB.put(Converter.pair(Void.class, Point.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Point.class, Point.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Point.class), StringConversions::toPoint);
        CONVERSION_DB.put(Converter.pair(Map.class, Point.class), MapConversions::toPoint);
        CONVERSION_DB.put(Converter.pair(int[].class, Point.class), ArrayConversions::toPoint);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Point.class), DimensionConversions::toPoint);
        CONVERSION_DB.put(Converter.pair(Void.class, Rectangle.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Rectangle.class, Rectangle.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Rectangle.class), StringConversions::toRectangle);
        CONVERSION_DB.put(Converter.pair(Map.class, Rectangle.class), MapConversions::toRectangle);
        CONVERSION_DB.put(Converter.pair(int[].class, Rectangle.class), ArrayConversions::toRectangle);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Rectangle.class), DimensionConversions::toRectangle);
        CONVERSION_DB.put(Converter.pair(Void.class, Insets.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Insets.class, Insets.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Insets.class), StringConversions::toInsets);
        CONVERSION_DB.put(Converter.pair(Map.class, Insets.class), MapConversions::toInsets);
        CONVERSION_DB.put(Converter.pair(int[].class, Insets.class), ArrayConversions::toInsets);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Insets.class), DimensionConversions::toInsets);
        CONVERSION_DB.put(Converter.pair(Void.class, File.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(File.class, File.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, File.class), StringConversions::toFile);
        CONVERSION_DB.put(Converter.pair(Map.class, File.class), MapConversions::toFile);
        CONVERSION_DB.put(Converter.pair(URI.class, File.class), UriConversions::toFile);
        CONVERSION_DB.put(Converter.pair(Path.class, File.class), PathConversions::toFile);
        CONVERSION_DB.put(Converter.pair(char[].class, File.class), ArrayConversions::charArrayToFile);
        CONVERSION_DB.put(Converter.pair(byte[].class, File.class), ArrayConversions::byteArrayToFile);
        CONVERSION_DB.put(Converter.pair(Void.class, Path.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Path.class, Path.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Path.class), StringConversions::toPath);
        CONVERSION_DB.put(Converter.pair(Map.class, Path.class), MapConversions::toPath);
        CONVERSION_DB.put(Converter.pair(URI.class, Path.class), UriConversions::toPath);
        CONVERSION_DB.put(Converter.pair(File.class, Path.class), FileConversions::toPath);
        CONVERSION_DB.put(Converter.pair(char[].class, Path.class), ArrayConversions::charArrayToPath);
        CONVERSION_DB.put(Converter.pair(byte[].class, Path.class), ArrayConversions::byteArrayToPath);
        CONVERSION_DB.put(Converter.pair(Void.class, Locale.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Locale.class, Locale.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Locale.class), StringConversions::toLocale);
        CONVERSION_DB.put(Converter.pair(Map.class, Locale.class), MapConversions::toLocale);
        CONVERSION_DB.put(Converter.pair(Void.class, String.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Short.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Integer.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Long.class, String.class), StringConversions::toString);
        CONVERSION_DB.put(Converter.pair(Float.class, String.class), NumberConversions::floatToString);
        CONVERSION_DB.put(Converter.pair(Double.class, String.class), NumberConversions::doubleToString);
        CONVERSION_DB.put(Converter.pair(Boolean.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(Character.class, String.class), CharacterConversions::toString);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, String.class), BigDecimalConversions::toString);
        CONVERSION_DB.put(Converter.pair(byte[].class, String.class), ByteArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(char[].class, String.class), CharArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(Character[].class, String.class), CharacterArrayConversions::toString);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, String.class), ByteBufferConversions::toString);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, String.class), CharBufferConversions::toString);
        CONVERSION_DB.put(Converter.pair(Class.class, String.class), ClassConversions::toString);
        CONVERSION_DB.put(Converter.pair(Date.class, String.class), DateConversions::toString);
        CONVERSION_DB.put(Converter.pair(Calendar.class, String.class), CalendarConversions::toString);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, String.class), SqlDateConversions::toString);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, String.class), TimestampConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, String.class), LocalDateConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, String.class), LocalTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, String.class), LocalDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, String.class), ZonedDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(UUID.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(Color.class, String.class), ColorConversions::toString);
        CONVERSION_DB.put(Converter.pair(Dimension.class, String.class), DimensionConversions::toString);
        CONVERSION_DB.put(Converter.pair(Point.class, String.class), PointConversions::toString);
        CONVERSION_DB.put(Converter.pair(Rectangle.class, String.class), RectangleConversions::toString);
        CONVERSION_DB.put(Converter.pair(Insets.class, String.class), InsetsConversions::toString);
        CONVERSION_DB.put(Converter.pair(Map.class, String.class), MapConversions::toString);
        CONVERSION_DB.put(Converter.pair(Enum.class, String.class), StringConversions::enumToString);
        CONVERSION_DB.put(Converter.pair(Enum.class, Integer.class), EnumConversions::enumToOrdinal);
        CONVERSION_DB.put(Converter.pair(String.class, Enum.class), EnumConversions::stringToEnum);
        CONVERSION_DB.put(Converter.pair(Integer.TYPE, Enum.class), EnumConversions::intToEnum);
        CONVERSION_DB.put(Converter.pair(Integer.class, Enum.class), EnumConversions::intToEnum);
        CONVERSION_DB.put(Converter.pair(Number.class, Enum.class), EnumConversions::numberToEnum);
        CONVERSION_DB.put(Converter.pair(String.class, String.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Duration.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(Instant.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(Period.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, String.class), OffsetTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, String.class), OffsetDateTimeConversions::toString);
        CONVERSION_DB.put(Converter.pair(Year.class, String.class), YearConversions::toString);
        CONVERSION_DB.put(Converter.pair(Locale.class, String.class), LocaleConversions::toString);
        CONVERSION_DB.put(Converter.pair(URI.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(URL.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(File.class, String.class), FileConversions::toString);
        CONVERSION_DB.put(Converter.pair(Path.class, String.class), PathConversions::toString);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, String.class), TimeZoneConversions::toString);
        CONVERSION_DB.put(Converter.pair(Pattern.class, String.class), PatternConversions::toString);
        CONVERSION_DB.put(Converter.pair(Currency.class, String.class), CurrencyConversions::toString);
        CONVERSION_DB.put(Converter.pair(StringBuilder.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(StringBuffer.class, String.class), UniversalConversions::toString);
        CONVERSION_DB.put(Converter.pair(Void.class, Currency.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Currency.class, Currency.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Currency.class), StringConversions::toCurrency);
        CONVERSION_DB.put(Converter.pair(Map.class, Currency.class), MapConversions::toCurrency);
        CONVERSION_DB.put(Converter.pair(Void.class, Pattern.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Pattern.class, Pattern.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Pattern.class), StringConversions::toPattern);
        CONVERSION_DB.put(Converter.pair(Map.class, Pattern.class), MapConversions::toPattern);
        CONVERSION_DB.put(Converter.pair(Void.class, URL.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(URL.class, URL.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(URI.class, URL.class), UriConversions::toURL);
        CONVERSION_DB.put(Converter.pair(String.class, URL.class), StringConversions::toURL);
        CONVERSION_DB.put(Converter.pair(Map.class, URL.class), MapConversions::toURL);
        CONVERSION_DB.put(Converter.pair(File.class, URL.class), FileConversions::toURL);
        CONVERSION_DB.put(Converter.pair(Path.class, URL.class), PathConversions::toURL);
        CONVERSION_DB.put(Converter.pair(Void.class, URI.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(URI.class, URI.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(URL.class, URI.class), UrlConversions::toURI);
        CONVERSION_DB.put(Converter.pair(String.class, URI.class), StringConversions::toURI);
        CONVERSION_DB.put(Converter.pair(Map.class, URI.class), MapConversions::toURI);
        CONVERSION_DB.put(Converter.pair(File.class, URI.class), FileConversions::toURI);
        CONVERSION_DB.put(Converter.pair(Path.class, URI.class), PathConversions::toURI);
        CONVERSION_DB.put(Converter.pair(Void.class, TimeZone.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, TimeZone.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, TimeZone.class), StringConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(Map.class, TimeZone.class), MapConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, TimeZone.class), ZoneIdConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, TimeZone.class), ZoneOffsetConversions::toTimeZone);
        CONVERSION_DB.put(Converter.pair(Void.class, Duration.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Duration.class, Duration.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Duration.class), NumberConversions::longNanosToDuration);
        CONVERSION_DB.put(Converter.pair(Double.class, Duration.class), DoubleConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Duration.class), BigIntegerConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Duration.class), BigDecimalConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Duration.class), TimestampConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(String.class, Duration.class), StringConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Map.class, Duration.class), MapConversions::toDuration);
        CONVERSION_DB.put(Converter.pair(Void.class, Instant.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Instant.class, Instant.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Long.class, Instant.class), NumberConversions::longNanosToInstant);
        CONVERSION_DB.put(Converter.pair(Double.class, Instant.class), DoubleConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Instant.class), BigIntegerConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Instant.class), BigDecimalConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Instant.class), SqlDateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Instant.class), DateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Date.class, Instant.class), DateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Instant.class), LocalDateConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Instant.class), LocalDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Instant.class), ZonedDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Instant.class), OffsetDateTimeConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Duration.class, Instant.class), DurationConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(String.class, Instant.class), StringConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Map.class, Instant.class), MapConversions::toInstant);
        CONVERSION_DB.put(Converter.pair(Void.class, ZoneId.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, ZoneId.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, ZoneId.class), StringConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(Map.class, ZoneId.class), MapConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, ZoneId.class), TimeZoneConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, ZoneId.class), ZoneOffsetConversions::toZoneId);
        CONVERSION_DB.put(Converter.pair(Void.class, ZoneOffset.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, ZoneOffset.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, ZoneOffset.class), StringConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(Map.class, ZoneOffset.class), MapConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, ZoneOffset.class), ZoneIdConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, ZoneOffset.class), TimeZoneConversions::toZoneOffset);
        CONVERSION_DB.put(Converter.pair(Void.class, MonthDay.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, MonthDay.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, MonthDay.class), SqlDateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Date.class, MonthDay.class), DateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, MonthDay.class), TimestampConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, MonthDay.class), LocalDateConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, MonthDay.class), LocalDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, MonthDay.class), ZonedDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, MonthDay.class), OffsetDateTimeConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(String.class, MonthDay.class), StringConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Map.class, MonthDay.class), MapConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Short.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Integer.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Long.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Float.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Double.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, MonthDay.class), NumberConversions::toMonthDay);
        CONVERSION_DB.put(Converter.pair(Void.class, YearMonth.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, YearMonth.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, YearMonth.class), SqlDateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Date.class, YearMonth.class), DateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, YearMonth.class), TimestampConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, YearMonth.class), LocalDateConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, YearMonth.class), LocalDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, YearMonth.class), ZonedDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, YearMonth.class), OffsetDateTimeConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(String.class, YearMonth.class), StringConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Map.class, YearMonth.class), MapConversions::toYearMonth);
        CONVERSION_DB.put(Converter.pair(Void.class, Period.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Period.class, Period.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(String.class, Period.class), StringConversions::toPeriod);
        CONVERSION_DB.put(Converter.pair(Map.class, Period.class), MapConversions::toPeriod);
        CONVERSION_DB.put(Converter.pair(Void.class, StringBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, StringBuffer.class), StringConversions::toStringBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, StringBuilder.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, StringBuilder.class), StringConversions::toStringBuilder);
        CONVERSION_DB.put(Converter.pair(Void.class, byte[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, byte[].class), StringConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, byte[].class), ByteBufferConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, byte[].class), CharBufferConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(char[].class, byte[].class), (from, converter) -> ArrayConversions.arrayToArray(from, byte[].class, converter));
        CONVERSION_DB.put(Converter.pair(byte[].class, byte[].class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(File.class, byte[].class), FileConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(Path.class, byte[].class), PathConversions::toByteArray);
        CONVERSION_DB.put(Converter.pair(Void.class, char[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, char[].class), StringConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, char[].class), ByteBufferConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, char[].class), CharBufferConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(char[].class, char[].class), CharArrayConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(byte[].class, char[].class), (from, converter) -> ArrayConversions.arrayToArray(from, char[].class, converter));
        CONVERSION_DB.put(Converter.pair(File.class, char[].class), FileConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(Path.class, char[].class), PathConversions::toCharArray);
        CONVERSION_DB.put(Converter.pair(Void.class, Character[].class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, Character[].class), StringConversions::toCharacterArray);
        CONVERSION_DB.put(Converter.pair(Void.class, CharBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, CharBuffer.class), StringConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, CharBuffer.class), ByteBufferConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, CharBuffer.class), CharBufferConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(char[].class, CharBuffer.class), CharArrayConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(byte[].class, CharBuffer.class), ByteArrayConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(Map.class, CharBuffer.class), MapConversions::toCharBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, ByteBuffer.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(String.class, ByteBuffer.class), StringConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, ByteBuffer.class), ByteBufferConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, ByteBuffer.class), CharBufferConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(char[].class, ByteBuffer.class), CharArrayConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(byte[].class, ByteBuffer.class), ByteArrayConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(Map.class, ByteBuffer.class), MapConversions::toByteBuffer);
        CONVERSION_DB.put(Converter.pair(Void.class, Year.class), NumberConversions::nullToYear);
        CONVERSION_DB.put(Converter.pair(Year.class, Year.class), Converter::identity);
        CONVERSION_DB.put(Converter.pair(Short.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Integer.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Long.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Float.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Double.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Year.class), NumberConversions::toYear);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Year.class), SqlDateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Date.class, Year.class), DateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Year.class), TimestampConversions::toYear);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Year.class), LocalDateConversions::toYear);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Year.class), LocalDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Year.class), ZonedDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Year.class), OffsetDateTimeConversions::toYear);
        CONVERSION_DB.put(Converter.pair(String.class, Year.class), StringConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Map.class, Year.class), MapConversions::toYear);
        CONVERSION_DB.put(Converter.pair(Void.class, Throwable.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Map.class, Throwable.class), MapConversions::toThrowable);
        CONVERSION_DB.put(Converter.pair(Void.class, Map.class), VoidConversions::toNull);
        CONVERSION_DB.put(Converter.pair(Byte.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Short.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Integer.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Long.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Float.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Double.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Boolean.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Character.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, Map.class), UniversalConversions::bigIntegerToMap);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, Map.class), UniversalConversions::bigDecimalToMap);
        CONVERSION_DB.put(Converter.pair(Date.class, Map.class), DateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(java.sql.Date.class, Map.class), SqlDateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Timestamp.class, Map.class), TimestampConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Calendar.class, Map.class), CalendarConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalDate.class, Map.class), LocalDateConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalDateTime.class, Map.class), LocalDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZonedDateTime.class, Map.class), ZonedDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Duration.class, Map.class), DurationConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Instant.class, Map.class), InstantConversions::toMap);
        CONVERSION_DB.put(Converter.pair(LocalTime.class, Map.class), LocalTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(MonthDay.class, Map.class), MonthDayConversions::toMap);
        CONVERSION_DB.put(Converter.pair(YearMonth.class, Map.class), YearMonthConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Period.class, Map.class), PeriodConversions::toMap);
        CONVERSION_DB.put(Converter.pair(TimeZone.class, Map.class), TimeZoneConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZoneId.class, Map.class), ZoneIdConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ZoneOffset.class, Map.class), ZoneOffsetConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Class.class, Map.class), UniversalConversions::toMap);
        CONVERSION_DB.put(Converter.pair(UUID.class, Map.class), UUIDConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Color.class, Map.class), ColorConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Dimension.class, Map.class), DimensionConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Point.class, Map.class), PointConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Rectangle.class, Map.class), RectangleConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Insets.class, Map.class), InsetsConversions::toMap);
        CONVERSION_DB.put(Converter.pair(String.class, Map.class), StringConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Enum.class, Map.class), EnumConversions::toMap);
        CONVERSION_DB.put(Converter.pair(OffsetDateTime.class, Map.class), OffsetDateTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(OffsetTime.class, Map.class), OffsetTimeConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Year.class, Map.class), YearConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Locale.class, Map.class), LocaleConversions::toMap);
        CONVERSION_DB.put(Converter.pair(URI.class, Map.class), UriConversions::toMap);
        CONVERSION_DB.put(Converter.pair(URL.class, Map.class), UrlConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Throwable.class, Map.class), ThrowableConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Pattern.class, Map.class), PatternConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Currency.class, Map.class), CurrencyConversions::toMap);
        CONVERSION_DB.put(Converter.pair(ByteBuffer.class, Map.class), ByteBufferConversions::toMap);
        CONVERSION_DB.put(Converter.pair(CharBuffer.class, Map.class), CharBufferConversions::toMap);
        CONVERSION_DB.put(Converter.pair(File.class, Map.class), FileConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Path.class, Map.class), PathConversions::toMap);
        CONVERSION_DB.put(Converter.pair(Color.class, int[].class), ColorConversions::toIntArray);
        CONVERSION_DB.put(Converter.pair(Dimension.class, int[].class), DimensionConversions::toIntArray);
        CONVERSION_DB.put(Converter.pair(Point.class, int[].class), PointConversions::toIntArray);
        CONVERSION_DB.put(Converter.pair(Rectangle.class, int[].class), RectangleConversions::toIntArray);
        CONVERSION_DB.put(Converter.pair(Insets.class, int[].class), InsetsConversions::toIntArray);
        CONVERSION_DB.put(Converter.pair(AtomicIntegerArray.class, int[].class), UniversalConversions::atomicIntegerArrayToIntArray);
        CONVERSION_DB.put(Converter.pair(int[].class, AtomicIntegerArray.class), UniversalConversions::intArrayToAtomicIntegerArray);
        CONVERSION_DB.put(Converter.pair(AtomicLongArray.class, long[].class), UniversalConversions::atomicLongArrayToLongArray);
        CONVERSION_DB.put(Converter.pair(long[].class, AtomicLongArray.class), UniversalConversions::longArrayToAtomicLongArray);
        CONVERSION_DB.put(Converter.pair(AtomicReferenceArray.class, Object[].class), UniversalConversions::atomicReferenceArrayToObjectArray);
        CONVERSION_DB.put(Converter.pair(Object[].class, AtomicReferenceArray.class), UniversalConversions::objectArrayToAtomicReferenceArray);
        CONVERSION_DB.put(Converter.pair(AtomicReferenceArray.class, String[].class), UniversalConversions::atomicReferenceArrayToStringArray);
        CONVERSION_DB.put(Converter.pair(String[].class, AtomicReferenceArray.class), UniversalConversions::stringArrayToAtomicReferenceArray);
        CONVERSION_DB.put(Converter.pair(IntBuffer.class, int[].class), UniversalConversions::intBufferToIntArray);
        CONVERSION_DB.put(Converter.pair(int[].class, IntBuffer.class), UniversalConversions::intArrayToIntBuffer);
        CONVERSION_DB.put(Converter.pair(LongBuffer.class, long[].class), UniversalConversions::longBufferToLongArray);
        CONVERSION_DB.put(Converter.pair(long[].class, LongBuffer.class), UniversalConversions::longArrayToLongBuffer);
        CONVERSION_DB.put(Converter.pair(FloatBuffer.class, float[].class), UniversalConversions::floatBufferToFloatArray);
        CONVERSION_DB.put(Converter.pair(float[].class, FloatBuffer.class), UniversalConversions::floatArrayToFloatBuffer);
        CONVERSION_DB.put(Converter.pair(DoubleBuffer.class, double[].class), UniversalConversions::doubleBufferToDoubleArray);
        CONVERSION_DB.put(Converter.pair(double[].class, DoubleBuffer.class), UniversalConversions::doubleArrayToDoubleBuffer);
        CONVERSION_DB.put(Converter.pair(ShortBuffer.class, short[].class), UniversalConversions::shortBufferToShortArray);
        CONVERSION_DB.put(Converter.pair(short[].class, ShortBuffer.class), UniversalConversions::shortArrayToShortBuffer);
        CONVERSION_DB.put(Converter.pair(BitSet.class, boolean[].class), UniversalConversions::bitSetToBooleanArray);
        CONVERSION_DB.put(Converter.pair(boolean[].class, BitSet.class), UniversalConversions::booleanArrayToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, int[].class), UniversalConversions::bitSetToIntArray);
        CONVERSION_DB.put(Converter.pair(int[].class, BitSet.class), UniversalConversions::intArrayToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, byte[].class), UniversalConversions::bitSetToByteArray);
        CONVERSION_DB.put(Converter.pair(byte[].class, BitSet.class), UniversalConversions::byteArrayToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Long.class), UniversalConversions::bitSetToLong);
        CONVERSION_DB.put(Converter.pair(Long.class, BitSet.class), UniversalConversions::longToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Long.TYPE), UniversalConversions::bitSetToLong);
        CONVERSION_DB.put(Converter.pair(Long.TYPE, BitSet.class), UniversalConversions::longToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, BigInteger.class), UniversalConversions::bitSetToBigInteger);
        CONVERSION_DB.put(Converter.pair(BigInteger.class, BitSet.class), UniversalConversions::bigIntegerToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Integer.class), UniversalConversions::bitSetToInt);
        CONVERSION_DB.put(Converter.pair(Integer.class, BitSet.class), UniversalConversions::intToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Integer.TYPE), UniversalConversions::bitSetToInt);
        CONVERSION_DB.put(Converter.pair(Integer.TYPE, BitSet.class), UniversalConversions::intToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Short.class), UniversalConversions::bitSetToShort);
        CONVERSION_DB.put(Converter.pair(Short.class, BitSet.class), UniversalConversions::shortToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Short.TYPE), UniversalConversions::bitSetToShort);
        CONVERSION_DB.put(Converter.pair(Short.TYPE, BitSet.class), UniversalConversions::shortToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Byte.class), UniversalConversions::bitSetToByte);
        CONVERSION_DB.put(Converter.pair(Byte.class, BitSet.class), UniversalConversions::byteToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Byte.TYPE), UniversalConversions::bitSetToByte);
        CONVERSION_DB.put(Converter.pair(Byte.TYPE, BitSet.class), UniversalConversions::byteToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, BigDecimal.class), UniversalConversions::bitSetToBigDecimal);
        CONVERSION_DB.put(Converter.pair(BigDecimal.class, BitSet.class), UniversalConversions::bigDecimalToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, Boolean.class), UniversalConversions::bitSetToBoolean);
        CONVERSION_DB.put(Converter.pair(Boolean.class, BitSet.class), UniversalConversions::booleanToBitSet);
        CONVERSION_DB.put(Converter.pair(BitSet.class, String.class), UniversalConversions::bitSetToString);
        CONVERSION_DB.put(Converter.pair(String.class, BitSet.class), UniversalConversions::stringToBitSet);
        CONVERSION_DB.put(Converter.pair(int[].class, IntStream.class), UniversalConversions::intArrayToIntStream);
        CONVERSION_DB.put(Converter.pair(long[].class, LongStream.class), UniversalConversions::longArrayToLongStream);
        CONVERSION_DB.put(Converter.pair(double[].class, DoubleStream.class), UniversalConversions::doubleArrayToDoubleStream);
        try {
            Class<?> recordClass = Class.forName("java.lang.Record");
            CONVERSION_DB.put(Converter.pair(recordClass, Map.class, 0L), MapConversions::recordToMap);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Converter.expandBridgeConversions();
    }

    private static List<SurrogatePrimaryPair> getSurrogateToPrimaryPairs() {
        if (SURROGATE_TO_PRIMARY_PAIRS == null) {
            SURROGATE_TO_PRIMARY_PAIRS = Arrays.asList(new SurrogatePrimaryPair(Byte.TYPE, Byte.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Short.TYPE, Short.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Integer.TYPE, Integer.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Long.TYPE, Long.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Float.TYPE, Float.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Double.TYPE, Double.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Character.TYPE, Character.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(Boolean.TYPE, Boolean.class, UniversalConversions::primitiveToWrapper, null), new SurrogatePrimaryPair(AtomicBoolean.class, Boolean.class, UniversalConversions::atomicBooleanToBoolean, null), new SurrogatePrimaryPair(AtomicInteger.class, Integer.class, UniversalConversions::atomicIntegerToInt, null), new SurrogatePrimaryPair(AtomicLong.class, Long.class, UniversalConversions::atomicLongToLong, null), new SurrogatePrimaryPair(CharSequence.class, String.class, UniversalConversions::charSequenceToString, null), new SurrogatePrimaryPair(URL.class, URI.class, UrlConversions::toURI, null), new SurrogatePrimaryPair(Calendar.class, ZonedDateTime.class, CalendarConversions::toZonedDateTime, null));
        }
        return SURROGATE_TO_PRIMARY_PAIRS;
    }

    private static List<SurrogatePrimaryPair> getPrimaryToSurrogatePairs() {
        if (PRIMARY_TO_SURROGATE_PAIRS == null) {
            PRIMARY_TO_SURROGATE_PAIRS = Arrays.asList(new SurrogatePrimaryPair(Byte.class, Byte.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Short.class, Short.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Integer.class, Integer.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Long.class, Long.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Float.class, Float.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Double.class, Double.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Character.class, Character.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Boolean.class, Boolean.TYPE, null, UniversalConversions::wrapperToPrimitive), new SurrogatePrimaryPair(Boolean.class, AtomicBoolean.class, null, UniversalConversions::booleanToAtomicBoolean), new SurrogatePrimaryPair(Integer.class, AtomicInteger.class, null, UniversalConversions::integerToAtomicInteger), new SurrogatePrimaryPair(Long.class, AtomicLong.class, null, UniversalConversions::longToAtomicLong), new SurrogatePrimaryPair(String.class, StringBuffer.class, null, UniversalConversions::stringToStringBuffer), new SurrogatePrimaryPair(String.class, StringBuilder.class, null, UniversalConversions::stringToStringBuilder), new SurrogatePrimaryPair(String.class, CharSequence.class, null, UniversalConversions::stringToCharSequence), new SurrogatePrimaryPair(URI.class, URL.class, null, UriConversions::toURL));
        }
        return PRIMARY_TO_SURROGATE_PAIRS;
    }

    private static void expandBridgeConversions() {
        Converter.expandSurrogateBridges(BridgeDirection.SURROGATE_TO_PRIMARY);
        Converter.expandSurrogateBridges(BridgeDirection.PRIMARY_TO_SURROGATE);
    }

    private static void expandSurrogateBridges(BridgeDirection direction) {
        ArrayList existingEntries = new ArrayList(CONVERSION_DB.size());
        for (Map.Entry<ConversionPair, Convert<?>> entry : CONVERSION_DB.entrySet()) {
            existingEntries.add(entry);
        }
        List<SurrogatePrimaryPair> configs = direction == BridgeDirection.SURROGATE_TO_PRIMARY ? Converter.getSurrogateToPrimaryPairs() : Converter.getPrimaryToSurrogatePairs();
        for (SurrogatePrimaryPair config : configs) {
            Convert<?> bridgeConversion;
            Convert<?> originalConversion;
            long instanceId;
            Class<?> targetClass;
            Class<?> sourceClass;
            ConversionPair key;
            if (direction == BridgeDirection.SURROGATE_TO_PRIMARY) {
                Class<?> surrogateClass = config.surrogateClass;
                Class<?> primaryClass = config.primaryClass;
                for (Map.Entry entry : existingEntries) {
                    key = (ConversionPair)entry.getKey();
                    sourceClass = key.getSource();
                    targetClass = key.getTarget();
                    instanceId = key.getInstanceId();
                    if (!sourceClass.equals(primaryClass) || CONVERSION_DB.get(Converter.pair(surrogateClass, targetClass, 0L)) != null || targetClass.equals(surrogateClass)) continue;
                    originalConversion = CONVERSION_DB.get(Converter.pair(sourceClass, targetClass, instanceId));
                    bridgeConversion = Converter.createSurrogateToPrimaryBridgeConversion(config, originalConversion);
                    CONVERSION_DB.put(Converter.pair(surrogateClass, targetClass, 0L), bridgeConversion);
                }
                continue;
            }
            Class<?> primaryClass = config.surrogateClass;
            Class<?> surrogateClass = config.primaryClass;
            for (Map.Entry entry : existingEntries) {
                key = (ConversionPair)entry.getKey();
                sourceClass = key.getSource();
                targetClass = key.getTarget();
                instanceId = key.getInstanceId();
                if (!targetClass.equals(primaryClass) || CONVERSION_DB.get(Converter.pair(sourceClass, surrogateClass, 0L)) != null || sourceClass.equals(surrogateClass)) continue;
                originalConversion = CONVERSION_DB.get(Converter.pair(sourceClass, targetClass, instanceId));
                bridgeConversion = Converter.createPrimaryToSurrogateBridgeConversion(config, originalConversion);
                CONVERSION_DB.put(Converter.pair(sourceClass, surrogateClass, 0L), bridgeConversion);
            }
        }
    }

    private static Convert<?> createSurrogateToPrimaryBridgeConversion(SurrogatePrimaryPair config, Convert<?> primaryToTargetConversion) {
        Convert<?> surrogateToPrimaryConversion = config.surrogateToPrimaryConversion;
        if (surrogateToPrimaryConversion == null) {
            throw new IllegalArgumentException("No surrogate\u2192primary conversion found for: " + config.surrogateClass);
        }
        return (from, converter, target) -> {
            Object primaryValue = surrogateToPrimaryConversion.convert(from, converter);
            return primaryToTargetConversion.convert(primaryValue, converter, target);
        };
    }

    private static Convert<?> createPrimaryToSurrogateBridgeConversion(SurrogatePrimaryPair config, Convert<?> sourceToPrimaryConversion) {
        Convert<?> primaryToSurrogateConversion = config.primaryToSurrogateConversion;
        if (primaryToSurrogateConversion == null) {
            throw new IllegalArgumentException("No primary\u2192surrogate conversion found for: " + config.primaryClass);
        }
        return (from, converter, target) -> {
            Object primaryValue = sourceToPrimaryConversion.convert(from, converter, target);
            return primaryToSurrogateConversion.convert(primaryValue, converter, target);
        };
    }

    public Converter(ConverterOptions options) {
        this.options = options;
        this.instanceId = INSTANCE_ID_GENERATOR.getAndIncrement();
        Map<ConversionPair, Convert<?>> overrides = this.options.getConverterOverrides();
        this.hasUserConversions = !overrides.isEmpty();
        for (Map.Entry<ConversionPair, Convert<?>> entry : overrides.entrySet()) {
            ConversionPair pair = entry.getKey();
            this.USER_DB.put(Converter.pair(pair.getSource(), pair.getTarget(), this.instanceId), entry.getValue());
            this.addIdentityConversionIfNeeded(pair.getSource(), this.instanceId);
            this.addIdentityConversionIfNeeded(pair.getTarget(), this.instanceId);
        }
    }

    public <T> T convert(Object from, Class<T> toType) {
        Convert<Object> conversionMethod;
        Convert<Object> cached;
        Class sourceType;
        if (toType == null) {
            throw new IllegalArgumentException("toType cannot be null");
        }
        if (from == null) {
            sourceType = Void.class;
            cached = this.getCachedConverter(sourceType, toType);
            if (cached != null) {
                return (T)cached.convert(null, this, toType);
            }
        } else {
            sourceType = from.getClass();
            cached = this.getCachedConverter(sourceType, toType);
            if (cached != null) {
                return (T)cached.convert(from, this, toType);
            }
            T result = this.attemptContainerConversion(from, sourceType, toType);
            if (result != null) {
                return result;
            }
        }
        if (this.hasUserConversions && Converter.isValidConversion(conversionMethod = this.USER_DB.get(Converter.pair(sourceType, toType, this.instanceId)))) {
            this.cacheConverter(sourceType, toType, conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        conversionMethod = CONVERSION_DB.get(Converter.pair(sourceType, toType, 0L));
        if (Converter.isValidConversion(conversionMethod)) {
            FULL_CONVERSION_CACHE.put(Converter.pair(sourceType, toType, 0L), conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        conversionMethod = this.getInheritedConverter(sourceType, toType, this.instanceId);
        if (Converter.isValidConversion(conversionMethod)) {
            this.cacheConverter(sourceType, toType, conversionMethod);
            return (T)conversionMethod.convert(from, this, toType);
        }
        if (from != null && toType.isAssignableFrom(from.getClass())) {
            return (T)from;
        }
        if (!(from instanceof Map || !Map.class.isAssignableFrom(toType) || from != null && from.getClass().isArray() || from instanceof Collection)) {
            Class finalToType = toType;
            Convert<Object> objectConverter = (fromObj, converter) -> ObjectConversions.objectToMapWithTarget(fromObj, converter, finalToType);
            Object result = objectConverter.convert(from, this);
            if (result != null) {
                this.cacheConverter(sourceType, toType, objectConverter);
            }
            return (T)result;
        }
        throw new IllegalArgumentException("Unsupported conversion, source type [" + Converter.name(from) + "] target type '" + Converter.getShortName(toType) + "'");
    }

    private Convert<?> getCachedConverter(Class<?> source, Class<?> target) {
        Convert<?> converter = FULL_CONVERSION_CACHE.get(Converter.pair(source, target, this.instanceId));
        if (converter != null) {
            return converter;
        }
        return FULL_CONVERSION_CACHE.get(Converter.pair(source, target, 0L));
    }

    private void cacheConverter(Class<?> source, Class<?> target, Convert<?> converter) {
        FULL_CONVERSION_CACHE.put(Converter.pair(source, target, this.instanceId), converter);
    }

    private <T> T attemptContainerConversion(Object from, Class<?> sourceType, Class<T> toType) {
        if (!(from.getClass().isArray() || from instanceof Collection || from instanceof Map)) {
            return null;
        }
        if (from instanceof EnumSet && toType.isAssignableFrom(sourceType)) {
            return (T)from;
        }
        if (EnumSet.class.isAssignableFrom(toType)) {
            throw new IllegalArgumentException("To convert to EnumSet, specify the Enum class to convert to as the 'toType.' Example: EnumSet<Day> daySet = (EnumSet<Day>)(Object)converter.convert(array, Day.class);");
        }
        if (toType.isEnum()) {
            if (sourceType.isArray() || Collection.class.isAssignableFrom(sourceType)) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> EnumConversions.toEnumSet(fromObj, toType));
            }
            if (Map.class.isAssignableFrom(sourceType)) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> EnumConversions.toEnumSet(((Map)fromObj).keySet(), toType));
            }
        } else if (EnumSet.class.isAssignableFrom(sourceType)) {
            if (Collection.class.isAssignableFrom(toType)) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> {
                    Collection<?> target = CollectionHandling.createCollection(fromObj, toType);
                    target.addAll((Collection)fromObj);
                    return target;
                });
            }
            if (toType.isArray()) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> ArrayConversions.enumSetToArray((EnumSet)fromObj, toType));
            }
        } else if (Collection.class.isAssignableFrom(sourceType)) {
            if (toType.isArray()) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> ArrayConversions.collectionToArray((Collection)fromObj, toType, converter));
            }
            if (Collection.class.isAssignableFrom(toType)) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> CollectionConversions.collectionToCollection((Collection)fromObj, toType));
            }
        } else if (sourceType.isArray()) {
            if (Collection.class.isAssignableFrom(toType)) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> CollectionConversions.arrayToCollection(fromObj, toType));
            }
            if (toType.isArray() && !sourceType.getComponentType().equals(toType.getComponentType())) {
                return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> ArrayConversions.arrayToArray(fromObj, toType, converter));
            }
        } else if (Map.class.isAssignableFrom(sourceType) && Map.class.isAssignableFrom(toType)) {
            return this.executeAndCache(sourceType, toType, from, (fromObj, converter) -> MapConversions.mapToMapWithTarget(fromObj, converter, toType));
        }
        return null;
    }

    private <T> T executeAndCache(Class<?> sourceType, Class<?> toType, Object from, Convert<?> converter) {
        Object result = converter.convert(from, this);
        if (result != null) {
            this.cacheConverter(sourceType, toType, converter);
        }
        return (T)result;
    }

    private Convert<?> getInheritedConverter(Class<?> sourceType, Class<?> toType, long instanceId) {
        InheritancePair[] pairs;
        for (InheritancePair inheritancePair : pairs = Converter.getSortedInheritancePairs(sourceType, toType)) {
            Class<?> source = inheritancePair.source;
            Class<?> target = inheritancePair.target;
            Convert<?> tempConverter = this.USER_DB.get(Converter.pair(source, target, instanceId));
            if (tempConverter != null) {
                return tempConverter;
            }
            tempConverter = CONVERSION_DB.get(Converter.pair(source, target, 0L));
            if (tempConverter == null) continue;
            return tempConverter;
        }
        return null;
    }

    private static SortedSet<ClassLevel> getSuperClassesAndInterfaces(Class<?> clazz) {
        return cacheParentTypes.computeIfAbsent(clazz, key -> {
            TreeSet<ClassLevel> parentTypes = new TreeSet<ClassLevel>();
            ClassUtilities.ClassHierarchyInfo info = ClassUtilities.getClassHierarchyInfo(key);
            for (Map.Entry<Class<?>, Integer> entry : info.getDistanceMap().entrySet()) {
                Class<?> type = entry.getKey();
                int distance = entry.getValue();
                if (distance <= 0 || type == Serializable.class || type == Cloneable.class || type == Comparable.class || type == Externalizable.class) continue;
                parentTypes.add(new ClassLevel(type, distance));
            }
            return parentTypes;
        });
    }

    private static SortedSet<ClassLevel> getCompleteTypeHierarchy(Class<?> clazz) {
        return cacheCompleteHierarchy.computeIfAbsent(clazz, key -> {
            TreeSet<ClassLevel> hierarchy = new TreeSet<ClassLevel>(Converter.getSuperClassesAndInterfaces(key));
            hierarchy.add(new ClassLevel((Class<?>)key, 0));
            return hierarchy;
        });
    }

    private static InheritancePair[] getSortedInheritancePairs(Class<?> sourceType, Class<?> toType) {
        Object[] key = new Object[]{sourceType, toType};
        InheritancePair[] cached = cacheInheritancePairs.get(key);
        if (cached != null) {
            return cached;
        }
        SortedSet<ClassLevel> sourceTypes = Converter.getCompleteTypeHierarchy(sourceType);
        SortedSet<ClassLevel> targetTypes = Converter.getCompleteTypeHierarchy(toType);
        ArrayList<InheritancePair> pairs = new ArrayList<InheritancePair>(sourceTypes.size() * targetTypes.size());
        for (ClassLevel source : sourceTypes) {
            for (ClassLevel target : targetTypes) {
                pairs.add(new InheritancePair(source.clazz, target.clazz, source.level, target.level));
            }
        }
        Class<?> finalToType = toType;
        pairs.sort((p1, p2) -> {
            boolean p2ToInterface;
            boolean p2FromInterface;
            boolean p2AssignableToP1;
            boolean p1AssignableToP2;
            boolean p2ExactTarget;
            boolean p1ExactTarget = p1.target == finalToType;
            boolean bl = p2ExactTarget = p2.target == finalToType;
            if (p1ExactTarget != p2ExactTarget) {
                return p1ExactTarget ? -1 : 1;
            }
            if (p1.target != p2.target && (p1AssignableToP2 = p2.target.isAssignableFrom(p1.target)) != (p2AssignableToP1 = p1.target.isAssignableFrom(p2.target))) {
                return p1AssignableToP2 ? -1 : 1;
            }
            int dist1 = p1.sourceLevel + p1.targetLevel;
            int dist2 = p2.sourceLevel + p2.targetLevel;
            if (dist1 != dist2) {
                return dist1 - dist2;
            }
            boolean p1FromInterface = p1.source.isInterface();
            if (p1FromInterface != (p2FromInterface = p2.source.isInterface())) {
                return p1FromInterface ? 1 : -1;
            }
            boolean p1ToInterface = p1.target.isInterface();
            if (p1ToInterface != (p2ToInterface = p2.target.isInterface())) {
                return p1ToInterface ? 1 : -1;
            }
            return 0;
        });
        InheritancePair[] pairsArray = pairs.toArray(new InheritancePair[0]);
        cacheInheritancePairs.putMultiKey(pairsArray, sourceType, toType);
        return pairsArray;
    }

    static String getShortName(Class<?> type) {
        if (type.isArray()) {
            String customName = CUSTOM_ARRAY_NAMES.get(type);
            if (customName != null) {
                return customName;
            }
            Class<?> componentType = type.getComponentType();
            return componentType.getSimpleName() + "[]";
        }
        if (java.sql.Date.class.equals(type)) {
            return type.getName();
        }
        return type.getSimpleName();
    }

    private static String name(Object from) {
        if (from == null) {
            return "null";
        }
        return Converter.getShortName(from.getClass()) + " (" + from + ")";
    }

    public static boolean isContainerConversionSupported(Class<?> sourceType, Class<?> target) {
        if (!(sourceType.isArray() || Collection.class.isAssignableFrom(sourceType) || Map.class.isAssignableFrom(sourceType) || EnumSet.class.isAssignableFrom(sourceType))) {
            return false;
        }
        if (EnumSet.class.isAssignableFrom(target)) {
            throw new IllegalArgumentException("To convert to EnumSet, specify the Enum class to convert to as the 'toType.' Example: EnumSet<Day> daySet = (EnumSet<Day>)(Object)converter.convert(array, Day.class);");
        }
        if (target.isEnum()) {
            return sourceType.isArray() || Collection.class.isAssignableFrom(sourceType) || Map.class.isAssignableFrom(sourceType);
        }
        if (EnumSet.class.isAssignableFrom(sourceType)) {
            return target.isArray() || Collection.class.isAssignableFrom(target);
        }
        if (Collection.class.isAssignableFrom(sourceType)) {
            return target.isArray() || Collection.class.isAssignableFrom(target);
        }
        if (sourceType.isArray()) {
            if (Collection.class.isAssignableFrom(target)) {
                return true;
            }
            return target.isArray() && !sourceType.getComponentType().equals(target.getComponentType());
        }
        return false;
    }

    @Deprecated
    public static boolean isCollectionConversionSupported(Class<?> sourceType, Class<?> target) {
        return Converter.isContainerConversionSupported(sourceType, target);
    }

    public boolean isSimpleTypeConversionSupported(Class<?> source, Class<?> target) {
        if (this.hasConverterOverrideFor(source, target)) {
            return false;
        }
        Convert<?> cached = this.getCachedConverter(source, target);
        if (cached != null) {
            return cached != UNSUPPORTED;
        }
        if (source.isArray() || target.isArray() || Collection.class.isAssignableFrom(source) || Collection.class.isAssignableFrom(target) || Map.class.isAssignableFrom(source) || Map.class.isAssignableFrom(target)) {
            return false;
        }
        if (source.equals(Number.class)) {
            Convert<?> method = this.getConversionFromDBs(Long.class, target);
            this.cacheConverter(source, target, method);
            return Converter.isValidConversion(method);
        }
        Convert<?> method = this.getConversionFromDBs(source, target);
        if (Converter.isValidConversion(method)) {
            this.cacheConverter(source, target, method);
            return true;
        }
        method = this.getInheritedConverter(source, target, this.instanceId);
        if (Converter.isValidConversion(method)) {
            this.cacheConverter(source, target, method);
            return true;
        }
        this.cacheConverter(source, target, UNSUPPORTED);
        return false;
    }

    public boolean isSimpleTypeConversionSupported(Class<?> type) {
        if (this.hasConverterOverrideFor(type)) {
            return false;
        }
        return SIMPLE_TYPE_CACHE.computeIfAbsent(type, t -> this.isSimpleTypeConversionSupported((Class<?>)t, (Class<?>)t));
    }

    private boolean hasConverterOverrideFor(Class<?> sourceType, Class<?> targetType) {
        Convert<?> converter = this.USER_DB.get(Converter.pair(sourceType, targetType, this.instanceId));
        return converter != null && converter != UNSUPPORTED;
    }

    private boolean hasConverterOverrideFor(Class<?> targetType) {
        return this.hasConverterOverrideFor(targetType, targetType);
    }

    public boolean isConversionSupportedFor(Class<?> source, Class<?> target) {
        Convert<?> cached = this.getCachedConverter(source, target);
        if (cached != null) {
            return cached != UNSUPPORTED;
        }
        Convert<?> method = this.getConversionFromDBs(source, target);
        if (Converter.isValidConversion(method)) {
            this.cacheConverter(source, target, method);
            return true;
        }
        if (Converter.isContainerConversionSupported(source, target)) {
            if (source.isArray() && target.isArray()) {
                Class<?> srcComp = source.getComponentType();
                Class<?> tgtComp = target.getComponentType();
                return srcComp == Object.class || tgtComp == Object.class || this.isConversionSupportedFor(srcComp, tgtComp);
            }
            return true;
        }
        method = this.getInheritedConverter(source, target, this.instanceId);
        if (Converter.isValidConversion(method)) {
            this.cacheConverter(source, target, method);
            return true;
        }
        this.cacheConverter(source, target, UNSUPPORTED);
        return false;
    }

    public boolean isConversionSupportedFor(Class<?> type) {
        if (this.hasConverterOverrideFor(type)) {
            return true;
        }
        return SELF_CONVERSION_CACHE.computeIfAbsent(type, t -> this.isConversionSupportedFor((Class<?>)t, (Class<?>)t));
    }

    private static boolean isValidConversion(Convert<?> method) {
        return method != null && method != UNSUPPORTED;
    }

    private Convert<?> getConversionFromDBs(Class<?> source, Class<?> target) {
        Convert<?> method = this.USER_DB.get(Converter.pair(source = ClassUtilities.toPrimitiveWrapperClass(source), target = ClassUtilities.toPrimitiveWrapperClass(target), this.instanceId));
        if (Converter.isValidConversion(method)) {
            return method;
        }
        method = CONVERSION_DB.get(Converter.pair(source, target, 0L));
        if (Converter.isValidConversion(method)) {
            return method;
        }
        return UNSUPPORTED;
    }

    public static Map<Class<?>, Set<Class<?>>> allSupportedConversions() {
        TreeMap toFrom = new TreeMap(Comparator.comparing(Class::getName));
        Converter.addSupportedConversion(CONVERSION_DB, toFrom);
        Converter.addArrayCollectionConversions(toFrom);
        return toFrom;
    }

    public static Map<String, Set<String>> getSupportedConversions() {
        TreeMap<String, Set<String>> toFrom = new TreeMap<String, Set<String>>(String::compareTo);
        Converter.addSupportedConversionName(CONVERSION_DB, toFrom);
        Converter.addArrayCollectionConversionNames(toFrom);
        return toFrom;
    }

    private static void addArrayCollectionConversions(Map<Class<?>, Set<Class<?>>> toFrom) {
        Comparator<Class> classComparator = Comparator.comparing(Class::getName);
        toFrom.computeIfAbsent(Object[].class, k -> new TreeSet(classComparator)).add(Object[].class);
        toFrom.computeIfAbsent(Object[].class, k -> new TreeSet(classComparator)).add(Collection.class);
        toFrom.computeIfAbsent(Object[].class, k -> new TreeSet(classComparator)).add(Enum.class);
        toFrom.computeIfAbsent(Collection.class, k -> new TreeSet(classComparator)).add(Object[].class);
        toFrom.computeIfAbsent(Collection.class, k -> new TreeSet(classComparator)).add(Collection.class);
        toFrom.computeIfAbsent(Collection.class, k -> new TreeSet(classComparator)).add(Enum.class);
        toFrom.computeIfAbsent(Map.class, k -> new TreeSet(classComparator)).add(Enum.class);
        toFrom.computeIfAbsent(EnumSet.class, k -> new TreeSet(classComparator)).add(Object[].class);
        toFrom.computeIfAbsent(EnumSet.class, k -> new TreeSet(classComparator)).add(Collection.class);
    }

    private static void addArrayCollectionConversionNames(Map<String, Set<String>> toFrom) {
        toFrom.computeIfAbsent("Object[]", k -> new TreeSet()).add("Object[]");
        toFrom.computeIfAbsent("Object[]", k -> new TreeSet()).add("Collection");
        toFrom.computeIfAbsent("Object[]", k -> new TreeSet()).add("Enum");
        toFrom.computeIfAbsent("Collection", k -> new TreeSet()).add("Object[]");
        toFrom.computeIfAbsent("Collection", k -> new TreeSet()).add("Collection");
        toFrom.computeIfAbsent("Collection", k -> new TreeSet()).add("Enum");
        toFrom.computeIfAbsent("Map", k -> new TreeSet()).add("Enum");
        toFrom.computeIfAbsent("EnumSet", k -> new TreeSet()).add("Object[]");
        toFrom.computeIfAbsent("EnumSet", k -> new TreeSet()).add("Collection");
    }

    private static void addSupportedConversion(Map<ConversionPair, Convert<?>> db, Map<Class<?>, Set<Class<?>>> toFrom) {
        for (Map.Entry<ConversionPair, Convert<?>> entry : db.entrySet()) {
            if (entry.getValue() == UNSUPPORTED) continue;
            ConversionPair key = entry.getKey();
            Class<?> source = key.getSource();
            Class<?> target = key.getTarget();
            toFrom.computeIfAbsent(source, k -> new TreeSet<Class>(Comparator.comparing(c -> c.getName()))).add(target);
        }
    }

    private static void addSupportedConversionName(Map<ConversionPair, Convert<?>> db, Map<String, Set<String>> toFrom) {
        for (Map.Entry<ConversionPair, Convert<?>> entry : db.entrySet()) {
            if (entry.getValue() == UNSUPPORTED) continue;
            ConversionPair key = entry.getKey();
            Class<?> source = key.getSource();
            Class<?> target = key.getTarget();
            toFrom.computeIfAbsent(Converter.getShortName(source), k -> new TreeSet(String::compareTo)).add(Converter.getShortName(target));
        }
    }

    @Deprecated
    public Convert<?> addConversion(Class<?> source, Class<?> target, Convert<?> conversionMethod) {
        return this.addConversion(conversionMethod, source, target);
    }

    public Convert<?> addConversion(Convert<?> conversionMethod, Class<?> source, Class<?> target) {
        Set<Class<?>> sourceTypes = Converter.getTypeVariations(source);
        Set<Class<?>> targetTypes = Converter.getTypeVariations(target);
        for (Class<?> srcType : sourceTypes) {
            for (Class<?> tgtType : targetTypes) {
                Converter.clearCachesForType(srcType, tgtType);
            }
        }
        Class<?> wrapperSource = ClassUtilities.toPrimitiveWrapperClass(source);
        Class<?> wrapperTarget = ClassUtilities.toPrimitiveWrapperClass(target);
        Convert<?> previous = this.USER_DB.get(Converter.pair(wrapperSource, wrapperTarget, this.instanceId));
        this.USER_DB.put(Converter.pair(wrapperSource, wrapperTarget, this.instanceId), conversionMethod);
        for (Class<?> srcType : sourceTypes) {
            for (Class<?> tgtType : targetTypes) {
                this.USER_DB.put(Converter.pair(srcType, tgtType, this.instanceId), conversionMethod);
            }
        }
        this.addIdentityConversionIfNeeded(source, this.instanceId);
        this.addIdentityConversionIfNeeded(target, this.instanceId);
        this.hasUserConversions = true;
        return previous;
    }

    private static Set<Class<?>> getTypeVariations(Class<?> clazz) {
        IdentitySet types = new IdentitySet();
        types.add(clazz);
        if (clazz.isPrimitive()) {
            types.add(ClassUtilities.toPrimitiveWrapperClass(clazz));
        } else {
            Class<?> primitive = ClassUtilities.toPrimitiveClass(clazz);
            if (primitive != clazz) {
                types.add(primitive);
            }
        }
        return types;
    }

    private void addIdentityConversionIfNeeded(Class<?> type, long instanceId) {
        if (type != null && this.USER_DB.get(Converter.pair(type, type, instanceId)) == null) {
            this.USER_DB.put(Converter.pair(type, type, instanceId), IDENTITY_CONVERTER);
        }
    }

    public static <T> T identity(T from, Converter converter) {
        return from;
    }

    private static <T> T unsupported(T from, Converter converter) {
        return null;
    }

    private static void clearCachesForType(Class<?> source, Class<?> target) {
        ArrayList<ConversionPair> keysToRemove = new ArrayList<ConversionPair>(16);
        for (Map.Entry<ConversionPair, Convert<?>> entry : FULL_CONVERSION_CACHE.entrySet()) {
            ConversionPair key = entry.getKey();
            Class<?> sourceClass = key.getSource();
            Class<?> targetClass = key.getTarget();
            if ((sourceClass != source || targetClass != target) && !Converter.isInheritanceRelated(sourceClass, targetClass, source, target)) continue;
            keysToRemove.add(key);
        }
        for (ConversionPair key : keysToRemove) {
            FULL_CONVERSION_CACHE.remove(key);
        }
        SIMPLE_TYPE_CACHE.remove(source);
        SIMPLE_TYPE_CACHE.remove(target);
        SELF_CONVERSION_CACHE.remove(source);
        SELF_CONVERSION_CACHE.remove(target);
    }

    private static boolean isInheritanceRelated(Class<?> keySource, Class<?> keyTarget, Class<?> source, Class<?> target) {
        return keySource != source && (source.isAssignableFrom(keySource) || keySource.isAssignableFrom(source)) || keyTarget != target && (target.isAssignableFrom(keyTarget) || keyTarget.isAssignableFrom(target));
    }

    static {
        CUSTOM_ARRAY_NAMES.put(java.sql.Date[].class, "java.sql.Date[]");
        Converter.buildFactoryConversions();
        SURROGATE_TO_PRIMARY_PAIRS = null;
        PRIMARY_TO_SURROGATE_PAIRS = null;
    }

    public static final class ConversionPair {
        private final Class<?> source;
        private final Class<?> target;
        private final long instanceId;
        private final int hash;

        private ConversionPair(Class<?> source, Class<?> target, long instanceId) {
            this.source = source;
            this.target = target;
            this.instanceId = instanceId;
            this.hash = 31 * (31 * source.hashCode() + target.hashCode()) + Long.hashCode(instanceId);
        }

        public Class<?> getSource() {
            return this.source;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public long getInstanceId() {
            return this.instanceId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConversionPair)) {
                return false;
            }
            ConversionPair other = (ConversionPair)obj;
            return this.source == other.source && this.target == other.target && this.instanceId == other.instanceId;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class SurrogatePrimaryPair {
        final Class<?> surrogateClass;
        final Class<?> primaryClass;
        final Convert<?> surrogateToPrimaryConversion;
        final Convert<?> primaryToSurrogateConversion;

        SurrogatePrimaryPair(Class<?> surrogateClass, Class<?> primaryClass, Convert<?> surrogateToPrimaryConversion, Convert<?> primaryToSurrogateConversion) {
            this.surrogateClass = surrogateClass;
            this.primaryClass = primaryClass;
            this.surrogateToPrimaryConversion = surrogateToPrimaryConversion;
            this.primaryToSurrogateConversion = primaryToSurrogateConversion;
        }
    }

    private static enum BridgeDirection {
        SURROGATE_TO_PRIMARY,
        PRIMARY_TO_SURROGATE;

    }

    static final class InheritancePair {
        final Class<?> source;
        final Class<?> target;
        final int sourceLevel;
        final int targetLevel;

        InheritancePair(Class<?> source, Class<?> target, int sourceLevel, int targetLevel) {
            this.source = source;
            this.target = target;
            this.sourceLevel = sourceLevel;
            this.targetLevel = targetLevel;
        }
    }

    static class ClassLevel
    implements Comparable<ClassLevel> {
        private final Class<?> clazz;
        private final int level;
        private final boolean isInterface;

        ClassLevel(Class<?> c, int level) {
            this.clazz = c;
            this.level = level;
            this.isInterface = c.isInterface();
        }

        @Override
        public int compareTo(ClassLevel other) {
            int levelComparison = Integer.compare(this.level, other.level);
            if (levelComparison != 0) {
                return levelComparison;
            }
            if (this.isInterface && !other.isInterface) {
                return 1;
            }
            if (!this.isInterface && other.isInterface) {
                return -1;
            }
            return this.clazz.getName().compareTo(other.clazz.getName());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassLevel)) {
                return false;
            }
            ClassLevel other = (ClassLevel)obj;
            return this.clazz.equals(other.clazz) && this.level == other.level;
        }

        public int hashCode() {
            return this.clazz.hashCode() * 31 + this.level;
        }
    }
}

