/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public final class ConcurrentList<E>
implements List<E>,
Deque<E>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BUCKET_SIZE = 1024;
    private final ConcurrentMap<Integer, AtomicReferenceArray<Object>> buckets = new ConcurrentHashMap<Integer, AtomicReferenceArray<Object>>();
    private final AtomicLong head = new AtomicLong(0L);
    private final AtomicLong tail = new AtomicLong(0L);
    private final AtomicLong sizeCounter = new AtomicLong(0L);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentList() {
    }

    public ConcurrentList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity cannot be negative: " + initialCapacity);
        }
    }

    public ConcurrentList(Collection<? extends E> collection) {
        Objects.requireNonNull(collection, "collection cannot be null");
        this.addAll(collection);
    }

    private static int bucketIndex(long pos) {
        long div = pos / 1024L;
        if ((pos ^ 0x400L) < 0L && pos % 1024L != 0L) {
            --div;
        }
        return (int)div;
    }

    private static int bucketOffset(long pos) {
        int rem = (int)(pos % 1024L);
        return rem < 0 ? rem + 1024 : rem;
    }

    private AtomicReferenceArray<Object> ensureBucket(int index) {
        AtomicReferenceArray bucket = (AtomicReferenceArray)this.buckets.get(index);
        if (bucket == null) {
            bucket = new AtomicReferenceArray(1024);
            AtomicReferenceArray existing = this.buckets.putIfAbsent(index, bucket);
            if (existing != null) {
                bucket = existing;
            }
        }
        return bucket;
    }

    private AtomicReferenceArray<Object> getBucket(int index) {
        return (AtomicReferenceArray)this.buckets.get(index);
    }

    @Override
    public int size() {
        long size = this.sizeCounter.get();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeCounter.get() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
                Object element = bucket.get(ConcurrentList.bucketOffset(pos));
                if (!Objects.equals(o, element)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        final Object[] snapshot = this.toArray();
        return new Iterator<E>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < snapshot.length;
            }

            @Override
            public E next() {
                if (this.index >= snapshot.length) {
                    throw new NoSuchElementException();
                }
                return snapshot[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            if (sz == 0) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            Object[] result = new Object[sz];
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
                result[i] = bucket.get(ConcurrentList.bucketOffset(pos));
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            if (sz == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                T[] TArray = a;
                return TArray;
            }
            T[] result = a.length >= sz ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), sz);
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
                result[i] = bucket.get(ConcurrentList.bucketOffset(pos));
            }
            if (result.length > sz) {
                result[sz] = null;
            }
            T[] TArray = result;
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                E element = this.get(i);
                if (!Objects.equals(o, element)) continue;
                this.remove(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            for (E e : c) {
                this.addLast(e);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            int i = index;
            for (E e : c) {
                this.add(i++, e);
            }
            boolean bl = !c.isEmpty();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            for (Object o : c) {
                while (this.remove(o)) {
                    modified = true;
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            int sz = this.size();
            for (int i = sz - 1; i >= 0; --i) {
                E element = this.get(i);
                if (c.contains(element)) continue;
                this.remove(i);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.buckets.clear();
            this.head.set(0L);
            this.tail.set(0L);
            this.sizeCounter.set(0L);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        this.lock.readLock().lock();
        try {
            Object e;
            long h = this.head.get();
            long t = this.tail.get();
            long pos = h + (long)index;
            if (index < 0 || pos >= t) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
            Object object = e = bucket.get(ConcurrentList.bucketOffset(pos));
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.readLock().lock();
        try {
            Object old;
            long h = this.head.get();
            long t = this.tail.get();
            long pos = h + (long)index;
            if (index < 0 || pos >= t) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
            Object object = old = bucket.getAndSet(ConcurrentList.bucketOffset(pos), element);
            return (E)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        this.lock.writeLock().lock();
        try {
            if (index == 0) {
                this.addFirst(element);
                return;
            }
            if (index == this.size()) {
                this.addLast(element);
                return;
            }
            ArrayList<E> list = new ArrayList<E>(this);
            list.add(index, element);
            this.rebuild(list);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this.lock.writeLock().lock();
        try {
            if (index == 0) {
                E e = this.removeFirst();
                return e;
            }
            if (index == this.size() - 1) {
                E e = this.removeLast();
                return e;
            }
            ArrayList list = new ArrayList(this);
            Object removed = list.remove(index);
            this.rebuild(list);
            Object e = removed;
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
                Object element = bucket.get(ConcurrentList.bucketOffset(pos));
                if (!Objects.equals(o, element)) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            long h = this.head.get();
            for (int i = sz - 1; i >= 0; --i) {
                long pos = h + (long)i;
                AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
                Object element = bucket.get(ConcurrentList.bucketOffset(pos));
                if (!Objects.equals(o, element)) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        final Object[] snapshot = this.toArray();
        if (index < 0 || index > snapshot.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + snapshot.length);
        }
        return new ListIterator<E>(){
            private int cursor;
            {
                this.cursor = index;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < snapshot.length;
            }

            @Override
            public E next() {
                if (this.cursor >= snapshot.length) {
                    throw new NoSuchElementException();
                }
                return snapshot[this.cursor++];
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (this.cursor <= 0) {
                    throw new NoSuchElementException();
                }
                return snapshot[--this.cursor];
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("set not supported");
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("add not supported");
            }
        };
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not implemented for ConcurrentList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(E e) {
        this.lock.writeLock().lock();
        try {
            long pos = this.head.decrementAndGet();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.set(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(E e) {
        this.lock.writeLock().lock();
        try {
            long pos = this.tail.getAndIncrement();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.set(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        this.lock.writeLock().lock();
        try {
            if (this.isEmpty()) {
                throw new NoSuchElementException("List is empty");
            }
            E e = this.pollFirstInternal();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E removeLast() {
        this.lock.writeLock().lock();
        try {
            if (this.isEmpty()) {
                throw new NoSuchElementException("List is empty");
            }
            E e = this.pollLastInternal();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E pollFirst() {
        this.lock.writeLock().lock();
        try {
            if (this.isEmpty()) {
                E e = null;
                return e;
            }
            E e = this.pollFirstInternal();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private E pollFirstInternal() {
        long h = this.head.getAndIncrement();
        int oldBucketIdx = ConcurrentList.bucketIndex(h);
        AtomicReferenceArray<Object> bucket = this.getBucket(oldBucketIdx);
        E val = bucket.getAndSet(ConcurrentList.bucketOffset(h), null);
        this.sizeCounter.decrementAndGet();
        long t = this.tail.get();
        if (h + 1L >= t) {
            this.buckets.clear();
        } else {
            int newBucketIdx = ConcurrentList.bucketIndex(h + 1L);
            if (oldBucketIdx != newBucketIdx) {
                this.buckets.remove(oldBucketIdx);
            }
        }
        return val;
    }

    @Override
    public E pollLast() {
        this.lock.writeLock().lock();
        try {
            if (this.isEmpty()) {
                E e = null;
                return e;
            }
            E e = this.pollLastInternal();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private E pollLastInternal() {
        long newTail = this.tail.decrementAndGet();
        int removedBucketIdx = ConcurrentList.bucketIndex(newTail);
        AtomicReferenceArray<Object> bucket = this.getBucket(removedBucketIdx);
        E val = bucket.getAndSet(ConcurrentList.bucketOffset(newTail), null);
        this.sizeCounter.decrementAndGet();
        long h = this.head.get();
        if (newTail <= h) {
            this.buckets.clear();
        } else {
            int prevValidBucketIdx = ConcurrentList.bucketIndex(newTail - 1L);
            if (removedBucketIdx != prevValidBucketIdx) {
                this.buckets.remove(removedBucketIdx);
            }
        }
        return val;
    }

    @Override
    public E getFirst() {
        this.lock.readLock().lock();
        try {
            if (this.isEmpty()) {
                throw new NoSuchElementException("List is empty");
            }
            E e = this.peekFirstInternal();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E getLast() {
        this.lock.readLock().lock();
        try {
            if (this.isEmpty()) {
                throw new NoSuchElementException("List is empty");
            }
            E e = this.peekLastInternal();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E peekFirst() {
        this.lock.readLock().lock();
        try {
            if (this.isEmpty()) {
                E e = null;
                return e;
            }
            E e = this.peekFirstInternal();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private E peekFirstInternal() {
        long h = this.head.get();
        AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(h));
        Object val = bucket.get(ConcurrentList.bucketOffset(h));
        return (E)val;
    }

    @Override
    public E peekLast() {
        this.lock.readLock().lock();
        try {
            if (this.isEmpty()) {
                E e = null;
                return e;
            }
            E e = this.peekLastInternal();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private E peekLastInternal() {
        long pos = this.tail.get() - 1L;
        AtomicReferenceArray<Object> bucket = this.getBucket(ConcurrentList.bucketIndex(pos));
        Object val = bucket.get(ConcurrentList.bucketOffset(pos));
        return (E)val;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        this.lock.writeLock().lock();
        try {
            for (int i = this.size() - 1; i >= 0; --i) {
                E element = this.get(i);
                if (!Objects.equals(o, element)) continue;
                this.remove(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Object[] snapshot = this.toArray();
        return new Iterator<E>(){
            private int index;
            {
                this.index = snapshot.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public E next() {
                if (this.index < 0) {
                    throw new NoSuchElementException();
                }
                return snapshot[this.index--];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                Object e = this.getBucket(ConcurrentList.bucketIndex(pos)).get(ConcurrentList.bucketOffset(pos));
                action.accept(e);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            if (sz != other.size()) {
                boolean bl = false;
                return bl;
            }
            long h = this.head.get();
            Iterator it2 = other.iterator();
            for (int i = 0; i < sz; ++i) {
                Object e2;
                if (!it2.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                long pos = h + (long)i;
                Object e1 = this.getBucket(ConcurrentList.bucketIndex(pos)).get(ConcurrentList.bucketOffset(pos));
                if (Objects.equals(e1, e2 = it2.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !it2.hasNext();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.readLock().lock();
        try {
            int hash = 1;
            int sz = this.size();
            long h = this.head.get();
            for (int i = 0; i < sz; ++i) {
                long pos = h + (long)i;
                Object e = this.getBucket(ConcurrentList.bucketIndex(pos)).get(ConcurrentList.bucketOffset(pos));
                hash = 31 * hash + (e == null ? 0 : e.hashCode());
            }
            int n = hash;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.readLock().lock();
        try {
            int sz = this.size();
            long h = this.head.get();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < sz; ++i) {
                long pos;
                Object e;
                if (i > 0) {
                    sb.append(',').append(' ');
                }
                sb.append((e = this.getBucket(ConcurrentList.bucketIndex(pos = h + (long)i)).get(ConcurrentList.bucketOffset(pos))) == this ? "(this Collection)" : e);
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rebuild(List<E> elements) {
        this.buckets.clear();
        this.head.set(0L);
        this.tail.set(0L);
        this.sizeCounter.set(0L);
        for (E e : elements) {
            long pos = this.tail.getAndIncrement();
            AtomicReferenceArray<Object> bucket = this.ensureBucket(ConcurrentList.bucketIndex(pos));
            bucket.set(ConcurrentList.bucketOffset(pos), e);
            this.sizeCounter.incrementAndGet();
        }
    }
}

