/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class DeepEquals {
    public static final String IGNORE_CUSTOM_EQUALS = "ignoreCustomEquals";
    public static final String ALLOW_STRINGS_TO_MATCH_NUMBERS = "stringsCanMatchNumbers";
    public static final String DIFF = "diff";
    public static final String DIFF_ITEM = "diff_item";
    public static final String INCLUDE_DIFF_ITEM = "deepequals.include.diff_item";
    private static final String DEPTH_BUDGET = "__depthBudget";
    private static final String EMPTY = "\u2205";
    private static final String TRIANGLE_ARROW = "\u25b6";
    private static final String ARROW = "\u21e8";
    private static final String ANGLE_LEFT = "\u300a";
    private static final String ANGLE_RIGHT = "\u300b";
    private static final SafeSimpleDateFormat TS_FMT = new SafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Pattern BASE64_PATTERN;
    private static final Pattern HEX_32_PLUS;
    private static final Pattern SENSITIVE_WORDS;
    private static final Pattern UUID_PATTERN;
    private static final ThreadLocal<Deque<Set<Object>>> formattingStack;
    private static final ThreadLocal<Deque<Integer>> maxDepthBudgetStack;
    private static final double DOUBLE_EPSILON = 1.0E-12;
    private static final float FLOAT_EPSILON = 1.0E-6f;
    private static final Set<String> SENSITIVE_FIELD_NAMES;
    private static final int DEFAULT_MAX_COLLECTION_SIZE = 100000;
    private static final int DEFAULT_MAX_ARRAY_SIZE = 100000;
    private static final int DEFAULT_MAX_MAP_SIZE = 100000;
    private static final int DEFAULT_MAX_OBJECT_FIELDS = 1000;
    private static final int DEFAULT_MAX_RECURSION_DEPTH = 1000000;
    private static boolean secureErrorsEnabled;
    private static int maxCollectionSize;
    private static int maxArraySize;
    private static int maxMapSize;
    private static int maxObjectFields;
    private static int maxRecursionDepth;

    static void reloadSecurityProperties() {
        secureErrorsEnabled = Boolean.parseBoolean(System.getProperty("deepequals.secure.errors", "false"));
        maxCollectionSize = DeepEquals.parseIntProperty("deepequals.max.collection.size", 100000);
        maxArraySize = DeepEquals.parseIntProperty("deepequals.max.array.size", 100000);
        maxMapSize = DeepEquals.parseIntProperty("deepequals.max.map.size", 100000);
        maxObjectFields = DeepEquals.parseIntProperty("deepequals.max.object.fields", 1000);
        maxRecursionDepth = DeepEquals.parseIntProperty("deepequals.max.recursion.depth", 1000000);
    }

    private static int parseIntProperty(String propertyName, int defaultValue) {
        String prop = System.getProperty(propertyName);
        if (prop != null) {
            try {
                int value = Integer.parseInt(prop);
                return Math.max(0, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static boolean isSecureErrorsEnabled() {
        return secureErrorsEnabled;
    }

    private static int getMaxCollectionSize() {
        return maxCollectionSize;
    }

    private static int getMaxArraySize() {
        return maxArraySize;
    }

    private static int getMaxMapSize() {
        return maxMapSize;
    }

    private static int getMaxObjectFields() {
        return maxObjectFields;
    }

    private static int getMaxRecursionDepth() {
        return maxRecursionDepth;
    }

    public static boolean deepEquals(Object a, Object b) {
        return DeepEquals.deepEquals(a, b, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deepEquals(Object a, Object b, Map<String, ?> options) {
        Deque<Integer> depthStack = maxDepthBudgetStack.get();
        Integer userBudget = options != null && options.get(DEPTH_BUDGET) instanceof Integer ? (Integer)options.get(DEPTH_BUDGET) : null;
        int configured = DeepEquals.getMaxRecursionDepth();
        int maxDepth = Integer.MAX_VALUE;
        if (userBudget != null && userBudget > 0) {
            maxDepth = userBudget;
        }
        if (configured > 0) {
            maxDepth = Math.min(maxDepth, configured);
        }
        depthStack.push(maxDepth);
        try {
            HashSet<ItemsToCompare> visited = new HashSet<ItemsToCompare>();
            boolean bl = DeepEquals.deepEquals(a, b, options, visited);
            return bl;
        }
        finally {
            Deque<Set<Object>> fmtStack;
            depthStack.pop();
            if (depthStack.isEmpty()) {
                maxDepthBudgetStack.remove();
            }
            if ((fmtStack = formattingStack.get()) != null && fmtStack.isEmpty()) {
                formattingStack.remove();
            }
        }
    }

    private static boolean deepEquals(Object a, Object b, Map<String, ?> options, Set<ItemsToCompare> visited) {
        ArrayDeque<ItemsToCompare> stack = new ArrayDeque<ItemsToCompare>();
        boolean result = DeepEquals.deepEquals(a, b, stack, options, visited);
        if (!result && !stack.isEmpty()) {
            ItemsToCompare top = (ItemsToCompare)stack.peek();
            String breadcrumb = DeepEquals.generateBreadcrumb(stack);
            options.put(DIFF, breadcrumb);
            Boolean includeDiffItem = (Boolean)options.get(INCLUDE_DIFF_ITEM);
            if (includeDiffItem != null && includeDiffItem.booleanValue()) {
                options.put(DIFF_ITEM, top);
            }
        }
        return result;
    }

    private static boolean deepEquals(Object a, Object b, Deque<ItemsToCompare> stack, Map<String, ?> options, Set<ItemsToCompare> visited) {
        Collection ignoreCustomEquals = options != null ? (Collection)options.get(IGNORE_CUSTOM_EQUALS) : null;
        boolean allowAllCustomEquals = ignoreCustomEquals == null;
        boolean hasNonEmptyIgnoreSet = ignoreCustomEquals != null && !ignoreCustomEquals.isEmpty();
        boolean allowStringsToMatchNumbers = options != null && Converter.convert2boolean(options.get(ALLOW_STRINGS_TO_MATCH_NUMBERS));
        stack.addFirst(new ItemsToCompare(a, b));
        Deque<Integer> depthStack = maxDepthBudgetStack.get();
        Integer maxRecursionDepth = depthStack != null && !depthStack.isEmpty() ? depthStack.peek() : Integer.MAX_VALUE;
        int maxCollectionSize = DeepEquals.getMaxCollectionSize();
        int maxArraySize = DeepEquals.getMaxArraySize();
        int maxMapSize = DeepEquals.getMaxMapSize();
        int maxObjectFields = DeepEquals.getMaxObjectFields();
        while (!stack.isEmpty()) {
            boolean key2Ordered;
            Object key2;
            ItemsToCompare itemsToCompare = stack.removeFirst();
            if (!visited.add(itemsToCompare)) continue;
            if (maxRecursionDepth != Integer.MAX_VALUE && itemsToCompare.depth > maxRecursionDepth) {
                throw new SecurityException("Maximum recursion depth exceeded: " + itemsToCompare.depth + " > " + maxRecursionDepth);
            }
            Object key1 = itemsToCompare._key1;
            if (key1 == (key2 = itemsToCompare._key2)) continue;
            if (key1 == null || key2 == null) {
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof Number && key2 instanceof Number) {
                if (DeepEquals.compareNumbers((Number)key1, (Number)key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            if (allowStringsToMatchNumbers && (key1 instanceof String && key2 instanceof Number || key1 instanceof Number && key2 instanceof String)) {
                try {
                    if (key1 instanceof String ? DeepEquals.compareNumbers(Converter.convert2BigDecimal(key1), (Number)key2) : DeepEquals.compareNumbers((Number)key1, Converter.convert2BigDecimal(key2))) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof AtomicBoolean && key2 instanceof AtomicBoolean) {
                if (DeepEquals.compareAtomicBoolean((AtomicBoolean)key1, (AtomicBoolean)key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            Class<?> key1Class = key1.getClass();
            Class<?> key2Class = key2.getClass();
            if (key1 instanceof Enum && key2 instanceof Enum) {
                if (key1 == key2) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            if (Converter.isSimpleTypeConversionSupported(key1Class) && Converter.isSimpleTypeConversionSupported(key2Class)) {
                if (key1 instanceof URL && key2 instanceof URL) {
                    if (((URL)key1).toExternalForm().equals(((URL)key2).toExternalForm())) continue;
                    stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                    return false;
                }
                if (key1 instanceof Comparable && key2 instanceof Comparable) {
                    try {
                        if (((Comparable)key1).compareTo(key2) == 0) continue;
                        stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                        return false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key1.equals(key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.VALUE_MISMATCH));
                return false;
            }
            boolean key1Ordered = key1 instanceof List || key1 instanceof Deque;
            boolean bl = key2Ordered = key2 instanceof List || key2 instanceof Deque;
            if (key1Ordered && key2Ordered) {
                if (DeepEquals.decomposeOrderedCollection((Collection)key1, (Collection)key2, stack, itemsToCompare, maxCollectionSize)) continue;
                ItemsToCompare prior = stack.peek();
                if (prior != null) {
                    stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                }
                return false;
            }
            if (key1Ordered || key2Ordered) {
                if (key1 instanceof Collection && key2 instanceof Collection) {
                    boolean key1IsSet = key1 instanceof Set;
                    boolean key2IsSet = key2 instanceof Set;
                    if (key1IsSet || key2IsSet) {
                        stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                        return false;
                    }
                } else {
                    stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                    return false;
                }
            }
            if (key1 instanceof Collection) {
                if (!(key2 instanceof Collection)) {
                    stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.COLLECTION_TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeUnorderedCollection((Collection)key1, (Collection)key2, stack, options, visited, itemsToCompare, maxCollectionSize)) continue;
                ItemsToCompare prior = stack.peek();
                if (prior != null) {
                    stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                }
                return false;
            }
            if (key2 instanceof Collection) {
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.COLLECTION_TYPE_MISMATCH));
                return false;
            }
            if (key1 instanceof Map) {
                if (!(key2 instanceof Map)) {
                    stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeMap((Map)key1, (Map)key2, stack, options, visited, itemsToCompare, maxMapSize)) continue;
                ItemsToCompare prior = stack.peek();
                if (prior != null) {
                    stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                }
                return false;
            }
            if (key2 instanceof Map) {
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                return false;
            }
            if (key1Class.isArray()) {
                if (!key2Class.isArray()) {
                    stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeArray(key1, key2, stack, itemsToCompare, maxArraySize)) continue;
                ItemsToCompare prior = stack.peek();
                if (prior != null) {
                    stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                }
                return false;
            }
            if (key2Class.isArray()) {
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                return false;
            }
            if (!key1Class.equals(key2Class)) {
                stack.addFirst(new ItemsToCompare(key1, key2, itemsToCompare, Difference.TYPE_MISMATCH));
                return false;
            }
            if (ReflectionUtils.isRecord(key1Class)) {
                if (DeepEquals.decomposeRecord(key1, key2, stack, itemsToCompare)) continue;
                return false;
            }
            if (DeepEquals.hasCustomEquals(key1Class)) {
                boolean useCustomEqualsForThisClass;
                boolean bl2 = useCustomEqualsForThisClass = hasNonEmptyIgnoreSet && !ignoreCustomEquals.contains(key1Class);
                if (allowAllCustomEquals || useCustomEqualsForThisClass) {
                    if (key1.equals(key2)) continue;
                    HashMap newOptions = new HashMap(options);
                    newOptions.put("recursive_call", true);
                    IdentitySet ignoreSet = new IdentitySet();
                    if (ignoreCustomEquals != null) {
                        ignoreSet.addAll(ignoreCustomEquals);
                    }
                    ignoreSet.add(key1Class);
                    newOptions.put(IGNORE_CUSTOM_EQUALS, ignoreSet);
                    if (maxRecursionDepth != Integer.MAX_VALUE) {
                        int remainingBudget = maxRecursionDepth - itemsToCompare.depth;
                        if (remainingBudget > 0) {
                            newOptions.put(DEPTH_BUDGET, remainingBudget);
                        } else {
                            return false;
                        }
                    }
                    newOptions.put(INCLUDE_DIFF_ITEM, true);
                    DeepEquals.deepEquals(key1, key2, newOptions);
                    ItemsToCompare diff = (ItemsToCompare)newOptions.get(DIFF_ITEM);
                    if (diff != null) {
                        stack.addFirst(diff);
                    }
                    return false;
                }
            }
            DeepEquals.decomposeObject(key1, key2, stack, itemsToCompare, maxObjectFields);
        }
        return true;
    }

    private static int safeHashMapCapacity(int size) {
        if (size < 0) {
            return 16;
        }
        if (size > 0x5FFFFFFF) {
            return Integer.MAX_VALUE;
        }
        long capacity = (long)size * 4L / 3L;
        return Math.max(16, (int)capacity);
    }

    private static boolean decomposeRecord(Object rec1, Object rec2, Deque<ItemsToCompare> stack, ItemsToCompare currentItem) {
        Object[] components = ReflectionUtils.getRecordComponents(rec1.getClass());
        if (components == null) {
            return DeepEquals.decomposeObject(rec1, rec2, stack, currentItem, Integer.MAX_VALUE);
        }
        for (Object component : components) {
            String componentName = ReflectionUtils.getRecordComponentName(component);
            if (componentName == null) continue;
            Object value1 = ReflectionUtils.getRecordComponentValue(component, rec1);
            Object value2 = ReflectionUtils.getRecordComponentValue(component, rec2);
            stack.addFirst(new ItemsToCompare(value1, value2, componentName, currentItem, Difference.FIELD_VALUE_MISMATCH));
        }
        return true;
    }

    private static Map<String, Object> sanitizedChildOptions(Map<String, ?> options, ItemsToCompare currentItem) {
        Object ignore;
        if (options == null) {
            return Collections.emptyMap();
        }
        boolean hasOnlyInputKeys = true;
        for (String key : options.keySet()) {
            if (ALLOW_STRINGS_TO_MATCH_NUMBERS.equals(key) || IGNORE_CUSTOM_EQUALS.equals(key) || DEPTH_BUDGET.equals(key)) continue;
            hasOnlyInputKeys = false;
            break;
        }
        if (hasOnlyInputKeys) {
            return options;
        }
        HashMap<String, Object> child = new HashMap<String, Object>(3);
        Object allow = options.get(ALLOW_STRINGS_TO_MATCH_NUMBERS);
        if (allow != null) {
            child.put(ALLOW_STRINGS_TO_MATCH_NUMBERS, allow);
        }
        if ((ignore = options.get(IGNORE_CUSTOM_EQUALS)) != null) {
            child.put(IGNORE_CUSTOM_EQUALS, ignore);
        }
        return child;
    }

    private static boolean decomposeUnorderedCollection(Collection<?> col1, Collection<?> col2, Deque<ItemsToCompare> stack, Map<String, ?> options, Set<ItemsToCompare> visited, ItemsToCompare currentItem, int maxCollectionSize) {
        if (maxCollectionSize > 0 && (col1.size() > maxCollectionSize || col2.size() > maxCollectionSize)) {
            throw new SecurityException("Collection size exceeds maximum allowed: " + maxCollectionSize);
        }
        if (col1.size() != col2.size()) {
            stack.addFirst(new ItemsToCompare(col1, col2, currentItem, Difference.COLLECTION_SIZE_MISMATCH));
            return false;
        }
        HashMap<Integer, List<Object>> hashGroups = new HashMap<Integer, List<Object>>(DeepEquals.safeHashMapCapacity(col2.size()));
        for (Object o : col2) {
            int hash = DeepEquals.deepHashCode(o);
            hashGroups.computeIfAbsent(hash, k -> new ArrayList()).add(o);
        }
        Map<String, Object> childOptions = DeepEquals.sanitizedChildOptions(options, currentItem);
        for (Object item1 : col1) {
            boolean foundInOtherBucket;
            int hash1 = DeepEquals.deepHashCode(item1);
            List candidates = (List)hashGroups.get(hash1);
            if (candidates == null || candidates.isEmpty()) {
                if (DeepEquals.tryMatchAcrossBuckets(item1, hashGroups, childOptions, visited)) continue;
                stack.addFirst(new ItemsToCompare(item1, null, currentItem, Difference.COLLECTION_MISSING_ELEMENT));
                return false;
            }
            boolean foundMatch = false;
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                ScopedSet visitedCopy;
                ArrayDeque<ItemsToCompare> probeStack;
                Object item2 = it.next();
                if (!DeepEquals.deepEquals(item1, item2, probeStack = new ArrayDeque<ItemsToCompare>(), childOptions, visitedCopy = new ScopedSet(visited))) continue;
                foundMatch = true;
                it.remove();
                if (!candidates.isEmpty()) break;
                hashGroups.remove(hash1);
                break;
            }
            if (foundMatch || (foundInOtherBucket = DeepEquals.tryMatchAcrossBucketsExcluding(item1, hashGroups, hash1, childOptions, visited))) continue;
            stack.addFirst(new ItemsToCompare(item1, null, currentItem, Difference.COLLECTION_MISSING_ELEMENT));
            return false;
        }
        for (List remainingItems : hashGroups.values()) {
            if (remainingItems.isEmpty()) continue;
            stack.addFirst(new ItemsToCompare(null, remainingItems.get(0), currentItem, Difference.COLLECTION_MISSING_ELEMENT));
            return false;
        }
        return true;
    }

    private static boolean tryMatchAcrossBuckets(Object probe, Map<Integer, List<Object>> buckets, Map<String, ?> options, Set<ItemsToCompare> visited) {
        Iterator<Map.Entry<Integer, List<Object>>> it = buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, List<Object>> bucket = it.next();
            List<Object> list = bucket.getValue();
            Iterator<Object> li = list.iterator();
            while (li.hasNext()) {
                ScopedSet visitedCopy;
                ArrayDeque<ItemsToCompare> probeStack;
                Object cand = li.next();
                if (!DeepEquals.deepEquals(probe, cand, probeStack = new ArrayDeque<ItemsToCompare>(), options, visitedCopy = new ScopedSet(visited))) continue;
                li.remove();
                if (list.isEmpty()) {
                    it.remove();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean tryMatchAcrossBucketsExcluding(Object probe, Map<Integer, List<Object>> buckets, int excludeHash, Map<String, ?> options, Set<ItemsToCompare> visited) {
        Iterator<Map.Entry<Integer, List<Object>>> it = buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, List<Object>> bucket = it.next();
            if (bucket.getKey() == excludeHash) continue;
            List<Object> list = bucket.getValue();
            Iterator<Object> li = list.iterator();
            while (li.hasNext()) {
                ScopedSet visitedCopy;
                ArrayDeque<ItemsToCompare> probeStack;
                Object cand = li.next();
                if (!DeepEquals.deepEquals(probe, cand, probeStack = new ArrayDeque<ItemsToCompare>(), options, visitedCopy = new ScopedSet(visited))) continue;
                li.remove();
                if (list.isEmpty()) {
                    it.remove();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean decomposeOrderedCollection(Collection<?> col1, Collection<?> col2, Deque<ItemsToCompare> stack, ItemsToCompare currentItem, int maxCollectionSize) {
        if (maxCollectionSize > 0 && (col1.size() > maxCollectionSize || col2.size() > maxCollectionSize)) {
            throw new SecurityException("Collection size exceeds maximum allowed: " + maxCollectionSize);
        }
        if (col1.size() != col2.size()) {
            stack.addFirst(new ItemsToCompare(col1, col2, currentItem, Difference.COLLECTION_SIZE_MISMATCH));
            return false;
        }
        if (col1 instanceof List && col2 instanceof List) {
            List list1 = (List)col1;
            List list2 = (List)col2;
            for (int i = list1.size() - 1; i >= 0; --i) {
                stack.addFirst(new ItemsToCompare(list1.get(i), list2.get(i), new int[]{i}, currentItem, Difference.COLLECTION_ELEMENT_MISMATCH));
            }
        } else {
            int i;
            int size = col1.size();
            ItemsToCompare[] items = new ItemsToCompare[size];
            Iterator<?> it1 = col1.iterator();
            Iterator<?> it2 = col2.iterator();
            for (i = 0; i < size; ++i) {
                items[i] = new ItemsToCompare(it1.next(), it2.next(), new int[]{i}, currentItem, Difference.COLLECTION_ELEMENT_MISMATCH);
            }
            for (i = size - 1; i >= 0; --i) {
                stack.addFirst(items[i]);
            }
        }
        return true;
    }

    private static boolean decomposeMap(Map<?, ?> map1, Map<?, ?> map2, Deque<ItemsToCompare> stack, Map<String, ?> options, Set<ItemsToCompare> visited, ItemsToCompare currentItem, int maxMapSize) {
        if (maxMapSize > 0 && (map1.size() > maxMapSize || map2.size() > maxMapSize)) {
            throw new SecurityException("Map size exceeds maximum allowed: " + maxMapSize);
        }
        if (map1.size() != map2.size()) {
            stack.addFirst(new ItemsToCompare(map1, map2, currentItem, Difference.MAP_SIZE_MISMATCH));
            return false;
        }
        HashMap fastLookup = new HashMap(DeepEquals.safeHashMapCapacity(map2.size()));
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            int hash = DeepEquals.deepHashCode(entry.getKey());
            fastLookup.computeIfAbsent(hash, k -> new ArrayList()).add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
        }
        Map<String, Object> childOptions = DeepEquals.sanitizedChildOptions(options, currentItem);
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            int keyHash = DeepEquals.deepHashCode(entry.getKey());
            Collection otherEntries = (Collection)fastLookup.get(keyHash);
            if (otherEntries == null || otherEntries.isEmpty()) {
                Map.Entry<?, ?> match = DeepEquals.findAndRemoveMatchingKey(entry.getKey(), fastLookup, childOptions, visited);
                if (match == null) {
                    stack.addFirst(new ItemsToCompare(null, null, entry.getKey(), currentItem, true, Difference.MAP_MISSING_KEY));
                    return false;
                }
                stack.addFirst(new ItemsToCompare(entry.getValue(), match.getValue(), entry.getKey(), currentItem, true, Difference.MAP_VALUE_MISMATCH));
                continue;
            }
            boolean foundMatch = false;
            Iterator iterator = otherEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry otherEntry = (Map.Entry)iterator.next();
                ScopedSet visitedCopy = new ScopedSet(visited);
                ArrayDeque<ItemsToCompare> probeStack = new ArrayDeque<ItemsToCompare>();
                if (!DeepEquals.deepEquals(entry.getKey(), otherEntry.getKey(), probeStack, childOptions, visitedCopy)) continue;
                stack.addFirst(new ItemsToCompare(entry.getValue(), otherEntry.getValue(), entry.getKey(), currentItem, true, Difference.MAP_VALUE_MISMATCH));
                iterator.remove();
                if (otherEntries.isEmpty()) {
                    fastLookup.remove(keyHash);
                }
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            Map.Entry<?, ?> match = DeepEquals.findAndRemoveMatchingKeyExcluding(entry.getKey(), fastLookup, keyHash, childOptions, visited);
            if (match == null) {
                stack.addFirst(new ItemsToCompare(null, null, entry.getKey(), currentItem, true, Difference.MAP_MISSING_KEY));
                return false;
            }
            stack.addFirst(new ItemsToCompare(entry.getValue(), match.getValue(), entry.getKey(), currentItem, true, Difference.MAP_VALUE_MISMATCH));
        }
        for (Collection remainingEntries : fastLookup.values()) {
            if (remainingEntries.isEmpty()) continue;
            Map.Entry firstEntry = (Map.Entry)remainingEntries.iterator().next();
            stack.addFirst(new ItemsToCompare(null, null, firstEntry.getKey(), currentItem, true, Difference.MAP_MISSING_KEY));
            return false;
        }
        return true;
    }

    private static Map.Entry<?, ?> findAndRemoveMatchingKey(Object key, Map<Integer, Collection<Map.Entry<?, ?>>> buckets, Map<String, ?> options, Set<ItemsToCompare> visited) {
        Iterator<Map.Entry<Integer, Collection<Map.Entry<?, ?>>>> it = buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Collection<Map.Entry<?, ?>>> b = it.next();
            Collection<Map.Entry<?, ?>> c = b.getValue();
            Iterator<Map.Entry<?, ?>> ci = c.iterator();
            while (ci.hasNext()) {
                Map.Entry<?, ?> e = ci.next();
                ScopedSet visitedCopy = new ScopedSet(visited);
                ArrayDeque<ItemsToCompare> probeStack = new ArrayDeque<ItemsToCompare>();
                if (!DeepEquals.deepEquals(key, e.getKey(), probeStack, options, visitedCopy)) continue;
                ci.remove();
                if (c.isEmpty()) {
                    it.remove();
                }
                return e;
            }
        }
        return null;
    }

    private static Map.Entry<?, ?> findAndRemoveMatchingKeyExcluding(Object key, Map<Integer, Collection<Map.Entry<?, ?>>> buckets, int excludeHash, Map<String, ?> options, Set<ItemsToCompare> visited) {
        Iterator<Map.Entry<Integer, Collection<Map.Entry<?, ?>>>> it = buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Collection<Map.Entry<?, ?>>> b = it.next();
            if (b.getKey() == excludeHash) continue;
            Collection<Map.Entry<?, ?>> c = b.getValue();
            Iterator<Map.Entry<?, ?>> ci = c.iterator();
            while (ci.hasNext()) {
                Map.Entry<?, ?> e = ci.next();
                ScopedSet visitedCopy = new ScopedSet(visited);
                ArrayDeque<ItemsToCompare> probeStack = new ArrayDeque<ItemsToCompare>();
                if (!DeepEquals.deepEquals(key, e.getKey(), probeStack, options, visitedCopy)) continue;
                ci.remove();
                if (c.isEmpty()) {
                    it.remove();
                }
                return e;
            }
        }
        return null;
    }

    private static boolean decomposeArray(Object array1, Object array2, Deque<ItemsToCompare> stack, ItemsToCompare currentItem, int maxArraySize) {
        block25: {
            block23: {
                Class<?> componentType;
                int len1;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block24: {
                                            Class<?> type1 = array1.getClass();
                                            Class<?> type2 = array2.getClass();
                                            int dim1 = 0;
                                            int dim2 = 0;
                                            while (type1.isArray()) {
                                                ++dim1;
                                                type1 = type1.getComponentType();
                                            }
                                            while (type2.isArray()) {
                                                ++dim2;
                                                type2 = type2.getComponentType();
                                            }
                                            if (dim1 != dim2) {
                                                stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_DIMENSION_MISMATCH));
                                                return false;
                                            }
                                            if (!array1.getClass().getComponentType().equals(array2.getClass().getComponentType())) {
                                                stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_COMPONENT_TYPE_MISMATCH));
                                                return false;
                                            }
                                            len1 = ArrayUtilities.getLength(array1);
                                            int len2 = ArrayUtilities.getLength(array2);
                                            if (maxArraySize > 0 && (len1 > maxArraySize || len2 > maxArraySize)) {
                                                throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
                                            }
                                            if (len1 != len2) {
                                                stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_LENGTH_MISMATCH));
                                                return false;
                                            }
                                            componentType = array1.getClass().getComponentType();
                                            if (!componentType.isPrimitive()) break block23;
                                            if (componentType != Boolean.TYPE) break block24;
                                            boolean[] a1 = (boolean[])array1;
                                            boolean[] a2 = (boolean[])array2;
                                            if (Arrays.equals(a1, a2)) {
                                                return true;
                                            }
                                            for (int i = 0; i < len1; ++i) {
                                                if (a1[i] == a2[i]) continue;
                                                stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                                                return false;
                                            }
                                            break block25;
                                        }
                                        if (componentType != Byte.TYPE) break block26;
                                        byte[] a1 = (byte[])array1;
                                        byte[] a2 = (byte[])array2;
                                        if (Arrays.equals(a1, a2)) {
                                            return true;
                                        }
                                        for (int i = 0; i < len1; ++i) {
                                            if (a1[i] == a2[i]) continue;
                                            stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                                            return false;
                                        }
                                        break block25;
                                    }
                                    if (componentType != Character.TYPE) break block27;
                                    char[] a1 = (char[])array1;
                                    char[] a2 = (char[])array2;
                                    if (Arrays.equals(a1, a2)) {
                                        return true;
                                    }
                                    for (int i = 0; i < len1; ++i) {
                                        if (a1[i] == a2[i]) continue;
                                        stack.addFirst(new ItemsToCompare((Object)Character.valueOf(a1[i]), (Object)Character.valueOf(a2[i]), new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                                        return false;
                                    }
                                    break block25;
                                }
                                if (componentType != Short.TYPE) break block28;
                                short[] a1 = (short[])array1;
                                short[] a2 = (short[])array2;
                                if (Arrays.equals(a1, a2)) {
                                    return true;
                                }
                                for (int i = 0; i < len1; ++i) {
                                    if (a1[i] == a2[i]) continue;
                                    stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                                    return false;
                                }
                                break block25;
                            }
                            if (componentType != Integer.TYPE) break block29;
                            int[] a1 = (int[])array1;
                            int[] a2 = (int[])array2;
                            if (Arrays.equals(a1, a2)) {
                                return true;
                            }
                            for (int i = 0; i < len1; ++i) {
                                if (a1[i] == a2[i]) continue;
                                stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                                return false;
                            }
                            break block25;
                        }
                        if (componentType != Long.TYPE) break block30;
                        long[] a1 = (long[])array1;
                        long[] a2 = (long[])array2;
                        if (Arrays.equals(a1, a2)) {
                            return true;
                        }
                        for (int i = 0; i < len1; ++i) {
                            if (a1[i] == a2[i]) continue;
                            stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                            return false;
                        }
                        break block25;
                    }
                    if (componentType != Float.TYPE) break block31;
                    float[] a1 = (float[])array1;
                    float[] a2 = (float[])array2;
                    if (Arrays.equals(a1, a2)) {
                        return true;
                    }
                    for (int i = 0; i < len1; ++i) {
                        if (DeepEquals.nearlyEqual(a1[i], a2[i])) continue;
                        stack.addFirst(new ItemsToCompare((Object)Float.valueOf(a1[i]), (Object)Float.valueOf(a2[i]), new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                        return false;
                    }
                    break block25;
                }
                if (componentType != Double.TYPE) break block25;
                double[] a1 = (double[])array1;
                double[] a2 = (double[])array2;
                if (Arrays.equals(a1, a2)) {
                    return true;
                }
                for (int i = 0; i < len1; ++i) {
                    if (DeepEquals.nearlyEqual(a1[i], a2[i])) continue;
                    stack.addFirst(new ItemsToCompare((Object)a1[i], (Object)a2[i], new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
                    return false;
                }
                break block25;
            }
            for (int i = len1 - 1; i >= 0; --i) {
                stack.addFirst(new ItemsToCompare(ArrayUtilities.getElement(array1, i), ArrayUtilities.getElement(array2, i), new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
            }
        }
        return true;
    }

    private static boolean decomposeObject(Object obj1, Object obj2, Deque<ItemsToCompare> stack, ItemsToCompare currentItem, int maxObjectFields) {
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj1.getClass());
        if (maxObjectFields > 0 && fields.size() > maxObjectFields) {
            throw new SecurityException("Object field count exceeds maximum allowed: " + maxObjectFields);
        }
        for (Field field : fields) {
            try {
                int modifiers;
                if (field.isSynthetic() || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers)) continue;
                Object value1 = field.get(obj1);
                Object value2 = field.get(obj2);
                stack.addFirst(new ItemsToCompare(value1, value2, field.getName(), currentItem, Difference.FIELD_VALUE_MISMATCH));
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private static boolean isIntegralNumber(Number n) {
        return n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof AtomicInteger || n instanceof AtomicLong;
    }

    private static boolean compareNumbers(Number a, Number b) {
        if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
            if (a instanceof BigDecimal || b instanceof BigDecimal) {
                try {
                    BigDecimal bd = a instanceof BigDecimal ? (BigDecimal)a : (BigDecimal)b;
                    if (bd.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) > 0 || bd.compareTo(BigDecimal.valueOf(-1.7976931348623157E308)) < 0) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            double d1 = a.doubleValue();
            double d2 = b.doubleValue();
            return DeepEquals.nearlyEqual(d1, d2);
        }
        if (DeepEquals.isIntegralNumber(a) && DeepEquals.isIntegralNumber(b)) {
            return a.longValue() == b.longValue();
        }
        try {
            BigDecimal x = Converter.convert2BigDecimal(a);
            BigDecimal y = Converter.convert2BigDecimal(b);
            return x.compareTo(y) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean nearlyEqual(double a, double b) {
        if (Double.doubleToLongBits(a) == Double.doubleToLongBits(b)) {
            return true;
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double diff = Math.abs(a - b);
        double norm = Math.max(Math.abs(a), Math.abs(b));
        return norm == 0.0 ? diff <= 1.0E-12 : diff <= 1.0E-12 * norm;
    }

    private static boolean nearlyEqual(float a, float b) {
        if (Float.floatToIntBits(a) == Float.floatToIntBits(b)) {
            return true;
        }
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return false;
        }
        if (Float.isInfinite(a) || Float.isInfinite(b)) {
            return false;
        }
        float diff = Math.abs(a - b);
        float norm = Math.max(Math.abs(a), Math.abs(b));
        return norm == 0.0f ? diff <= 1.0E-6f : diff <= 1.0E-6f * norm;
    }

    private static boolean compareAtomicBoolean(AtomicBoolean a, AtomicBoolean b) {
        return a.get() == b.get();
    }

    public static boolean hasCustomEquals(Class<?> c) {
        Method equals = ReflectionUtils.getMethod(c, "equals", Object.class);
        return equals.getDeclaringClass() != Object.class;
    }

    public static boolean hasCustomHashCode(Class<?> c) {
        Method hashCode = ReflectionUtils.getMethod(c, "hashCode", new Class[0]);
        return hashCode.getDeclaringClass() != Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deepHashCode(Object obj) {
        try {
            IdentitySet<Object> visited = new IdentitySet<Object>();
            int n = DeepEquals.deepHashCode(obj, visited);
            return n;
        }
        finally {
            Deque<Set<Object>> fmtStack = formattingStack.get();
            if (fmtStack != null && fmtStack.isEmpty()) {
                formattingStack.remove();
            }
        }
    }

    private static int deepHashCode(Object obj, Set<Object> visited) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        if (obj != null) {
            stack.addFirst(obj);
        }
        int hash = 0;
        while (!stack.isEmpty()) {
            Object[] components;
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = ArrayUtilities.getLength(obj);
                long result = 1L;
                for (int i = 0; i < len; ++i) {
                    Object element = ArrayUtilities.getElement(obj, i);
                    result = 31L * result + (long)DeepEquals.hashElement(visited, element);
                }
                hash += (int)result;
                continue;
            }
            if (obj instanceof List || obj instanceof Deque) {
                Collection col = (Collection)obj;
                long result = 1L;
                for (Object element : col) {
                    result = 31L * result + (long)DeepEquals.hashElement(visited, element);
                }
                hash += (int)result;
                continue;
            }
            if (obj instanceof Collection) {
                DeepEquals.addCollectionToStack(stack, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                Map m = (Map)obj;
                int mapHash = 0;
                for (Map.Entry e : m.entrySet()) {
                    int kh = DeepEquals.hashElement(visited, e.getKey());
                    int vh = DeepEquals.hashElement(visited, e.getValue());
                    mapHash ^= 31 * kh + vh;
                }
                hash += mapHash;
                continue;
            }
            if (obj instanceof Float) {
                hash += DeepEquals.hashFloat(((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Double) {
                hash += DeepEquals.hashDouble((Double)obj);
                continue;
            }
            if (DeepEquals.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            if (ReflectionUtils.isRecord(obj.getClass()) && (components = ReflectionUtils.getRecordComponents(obj.getClass())) != null) {
                for (Object component : components) {
                    Object value = ReflectionUtils.getRecordComponentValue(component, obj);
                    if (value == null) continue;
                    stack.addFirst(value);
                }
                continue;
            }
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj.getClass());
            for (Field field : fields) {
                try {
                    Object fieldValue;
                    int modifiers;
                    if (field.isSynthetic() || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers) || (fieldValue = field.get(obj)) == null) continue;
                    stack.addFirst(fieldValue);
                }
                catch (Exception exception) {}
            }
        }
        return hash;
    }

    private static int hashElement(Set<Object> visited, Object element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof Double) {
            return DeepEquals.hashDouble((Double)element);
        }
        if (element instanceof Float) {
            return DeepEquals.hashFloat(((Float)element).floatValue());
        }
        if (Converter.isSimpleTypeConversionSupported(element.getClass())) {
            return element.hashCode();
        }
        return DeepEquals.deepHashCode(element, visited);
    }

    private static int hashDouble(double value) {
        double scale;
        double quantized;
        if (Double.isNaN(value)) {
            return 2146959360;
        }
        if (Double.isInfinite(value)) {
            return value > 0.0 ? 0x7FF00000 : -1048576;
        }
        if (value == 0.0) {
            value = 0.0;
        }
        if ((quantized = (double)Math.round(value * (scale = 1.0E10)) / scale) == 0.0) {
            quantized = 0.0;
        }
        long bits = Double.doubleToLongBits(quantized);
        return (int)(bits ^ bits >>> 32);
    }

    private static int hashFloat(float value) {
        float scale;
        float quantized;
        if (Float.isNaN(value)) {
            return 2143289344;
        }
        if (Float.isInfinite(value)) {
            return value > 0.0f ? 2139095040 : -8388608;
        }
        if (value == 0.0f) {
            value = 0.0f;
        }
        if ((quantized = (float)Math.round(value * (scale = 100000.0f)) / scale) == 0.0f) {
            quantized = 0.0f;
        }
        return Float.floatToIntBits(quantized);
    }

    private static void addCollectionToStack(Deque<Object> stack, Collection<?> collection) {
        List<Object> items = collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
        for (int i = items.size() - 1; i >= 0; --i) {
            Object item = items.get(i);
            if (item == null) continue;
            stack.addFirst(item);
        }
    }

    private static String generateBreadcrumb(Deque<ItemsToCompare> stack) {
        ItemsToCompare diffItem = stack.peek();
        StringBuilder result = new StringBuilder();
        PathResult pr = DeepEquals.buildPathContextAndPhrase(diffItem);
        String pathStr = pr.path;
        result.append("[");
        result.append(pr.mismatchPhrase);
        result.append("] ");
        result.append(TRIANGLE_ARROW);
        result.append(" ");
        result.append(pathStr);
        result.append("\n");
        DeepEquals.formatDifference(result, diffItem);
        return result.toString();
    }

    private static PathResult buildPathContextAndPhrase(ItemsToCompare diffItem) {
        List<ItemsToCompare> path = DeepEquals.getPath(diffItem);
        StringBuilder sb = new StringBuilder();
        ItemsToCompare rootItem = path.get(0);
        sb.append(DeepEquals.formatRootObject(rootItem._key1));
        StringBuilder sb2 = new StringBuilder();
        for (int i = 1; i < path.size(); ++i) {
            ItemsToCompare cur = path.get(i);
            if (cur.mapKey != null) {
                DeepEquals.appendSpaceIfNeeded(sb2);
                String rhs = cur.difference == Difference.MAP_MISSING_KEY ? EMPTY : DeepEquals.formatValueConcise(cur._key1);
                sb2.append(ANGLE_LEFT).append(DeepEquals.formatMapKey(cur.mapKey)).append(" ").append(ARROW).append(" ").append(rhs).append(ANGLE_RIGHT);
                continue;
            }
            if (cur.fieldName != null) {
                sb2.append(".").append(cur.fieldName);
                continue;
            }
            if (cur.arrayIndices == null) continue;
            for (int idx : cur.arrayIndices) {
                boolean isArray = cur.difference.name().contains("ARRAY");
                sb2.append(isArray ? "[" : "(");
                sb2.append(idx);
                sb2.append(isArray ? "]" : ")");
            }
        }
        if (sb2.length() > 0) {
            sb.append(" ");
            sb.append(TRIANGLE_ARROW);
            sb.append(" ");
            sb.append((CharSequence)sb2);
        }
        String mismatchPhrase = DeepEquals.getContainingDescription(path);
        return new PathResult(sb.toString(), mismatchPhrase);
    }

    private static String getContainingDescription(List<ItemsToCompare> path) {
        String b;
        Difference diff;
        ListIterator<ItemsToCompare> it = path.listIterator(path.size());
        String a = it.previous().difference.getDescription();
        if (it.hasPrevious() && (diff = it.previous().difference) != null && (b = diff.getDescription()) != null) {
            return b;
        }
        return a;
    }

    private static void appendSpaceIfNeeded(StringBuilder sb) {
        char last;
        if (sb.length() > 0 && (last = sb.charAt(sb.length() - 1)) != ' ' && last != '.' && last != '[') {
            sb.append(' ');
        }
    }

    private static Class<?> getCollectionElementType(Collection<?> col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        for (Object item : col) {
            if (item == null) continue;
            return item.getClass();
        }
        return null;
    }

    private static List<ItemsToCompare> getPath(ItemsToCompare diffItem) {
        ArrayList<ItemsToCompare> path = new ArrayList<ItemsToCompare>();
        ItemsToCompare current = diffItem;
        while (current != null) {
            path.add(current);
            current = current.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private static void formatDifference(StringBuilder result, ItemsToCompare item) {
        DiffCategory parentCat;
        if (item.difference == null) {
            return;
        }
        if (item.difference == Difference.MAP_MISSING_KEY) {
            result.append(String.format("  Expected: key '%s' present%n  Found: (missing)", DeepEquals.formatDifferenceValue(item.mapKey)));
            return;
        }
        ItemsToCompare detailNode = item;
        DiffCategory category = item.difference.getCategory();
        if (item.parent != null && item.parent.difference != null && (parentCat = item.parent.difference.getCategory()) != DiffCategory.VALUE) {
            category = parentCat;
            detailNode = item.parent;
        }
        switch (category) {
            case SIZE: {
                result.append(String.format("  Expected size: %d%n  Found size: %d", DeepEquals.getContainerSize(detailNode._key1), DeepEquals.getContainerSize(detailNode._key2)));
                break;
            }
            case TYPE: {
                result.append(String.format("  Expected type: %s%n  Found type: %s", DeepEquals.getTypeDescription(detailNode._key1 != null ? detailNode._key1.getClass() : null), DeepEquals.getTypeDescription(detailNode._key2 != null ? detailNode._key2.getClass() : null)));
                break;
            }
            case LENGTH: {
                result.append(String.format("  Expected length: %d%n  Found length: %d", ArrayUtilities.getLength(detailNode._key1), ArrayUtilities.getLength(detailNode._key2)));
                break;
            }
            case DIMENSION: {
                result.append(String.format("  Expected dimensions: %d%n  Found dimensions: %d", DeepEquals.getDimensions(detailNode._key1), DeepEquals.getDimensions(detailNode._key2)));
                break;
            }
            default: {
                result.append(String.format("  Expected: %s%n  Found: %s", DeepEquals.formatDifferenceValue(detailNode._key1), DeepEquals.formatDifferenceValue(detailNode._key2)));
            }
        }
    }

    private static String formatDifferenceValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (Converter.isSimpleTypeConversionSupported(value.getClass())) {
            return DeepEquals.formatSimpleValue(value);
        }
        return DeepEquals.formatValueConcise(value);
    }

    private static int getDimensions(Object array) {
        if (array == null) {
            return 0;
        }
        int dimensions = 0;
        Class<?> type = array.getClass();
        while (type.isArray()) {
            ++dimensions;
            type = type.getComponentType();
        }
        return dimensions;
    }

    private static String formatValueConcise(Object value) {
        if (value == null) {
            return "null";
        }
        try {
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                String typeName = value.getClass().getSimpleName();
                return String.format("%s(%s)", typeName, col.isEmpty() ? EMPTY : "0.." + (col.size() - 1));
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                String typeName = value.getClass().getSimpleName();
                return String.format("%s(%s)", typeName, map.isEmpty() ? EMPTY : "0.." + (map.size() - 1));
            }
            if (value.getClass().isArray()) {
                int length = ArrayUtilities.getLength(value);
                String typeName = DeepEquals.getTypeDescription(value.getClass().getComponentType());
                return String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1));
            }
            if (Converter.isSimpleTypeConversionSupported(value.getClass())) {
                return DeepEquals.formatSimpleValue(value);
            }
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(value.getClass());
            StringBuilder sb = new StringBuilder(value.getClass().getSimpleName());
            sb.append(" {");
            boolean first = true;
            for (Field field : fields) {
                int modifiers;
                if (field.isSynthetic() || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers)) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                Object fieldValue = field.get(value);
                String fieldName = field.getName();
                if (DeepEquals.isSecureErrorsEnabled() && DeepEquals.isSensitiveField(fieldName)) {
                    sb.append(fieldName).append(": [REDACTED]");
                    continue;
                }
                sb.append(fieldName).append(": ");
                if (fieldValue == null) {
                    sb.append("null");
                    continue;
                }
                Class<?> fieldType = field.getType();
                if (Converter.isSimpleTypeConversionSupported(fieldType)) {
                    sb.append(DeepEquals.formatSimpleValue(fieldValue));
                    continue;
                }
                if (fieldType.isArray()) {
                    int length = ArrayUtilities.getLength(fieldValue);
                    String typeName = DeepEquals.getTypeDescription(fieldType.getComponentType());
                    sb.append(String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1)));
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    Collection col = (Collection)fieldValue;
                    sb.append(String.format("%s(%s)", fieldType.getSimpleName(), col.isEmpty() ? EMPTY : "0.." + (col.size() - 1)));
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    Map map = (Map)fieldValue;
                    sb.append(String.format("%s(%s)", fieldType.getSimpleName(), map.isEmpty() ? EMPTY : "0.." + (map.size() - 1)));
                    continue;
                }
                sb.append("{..}");
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            return value.getClass().getSimpleName();
        }
    }

    private static String formatSimpleValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof AtomicBoolean) {
            return String.valueOf(((AtomicBoolean)value).get());
        }
        if (value instanceof AtomicInteger) {
            return String.valueOf(((AtomicInteger)value).get());
        }
        if (value instanceof AtomicLong) {
            return String.valueOf(((AtomicLong)value).get());
        }
        if (value instanceof String) {
            String str = (String)value;
            return DeepEquals.isSecureErrorsEnabled() ? DeepEquals.sanitizeStringValue(str) : "\"" + str + "\"";
        }
        if (value instanceof Character) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return DeepEquals.formatNumber((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            return TS_FMT.format((Date)value) + " UTC";
        }
        if (value instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)value;
            return "TimeZone: " + timeZone.getID();
        }
        if (value instanceof URI) {
            return DeepEquals.isSecureErrorsEnabled() ? DeepEquals.sanitizeUriValue((URI)value) : value.toString();
        }
        if (value instanceof URL) {
            return DeepEquals.isSecureErrorsEnabled() ? DeepEquals.sanitizeUrlValue((URL)value) : value.toString();
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (DeepEquals.isSecureErrorsEnabled()) {
            return value.getClass().getSimpleName() + ":[REDACTED]";
        }
        return value.getClass().getSimpleName() + ":" + value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatValue(Object value) {
        Set<Object> currentSet;
        if (value == null) {
            return "null";
        }
        Deque<Set<Object>> stackOfSets = formattingStack.get();
        boolean pushedNewSet = false;
        if (stackOfSets.isEmpty()) {
            currentSet = new IdentitySet();
            stackOfSets.push(currentSet);
            pushedNewSet = true;
        } else {
            currentSet = stackOfSets.peek();
        }
        try {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                String string;
                                                if (!currentSet.add(value)) {
                                                    String string2 = "<circular " + value.getClass().getSimpleName() + ">";
                                                    return string2;
                                                }
                                                try {
                                                    if (!(value instanceof Number)) break block31;
                                                    string = DeepEquals.formatNumber((Number)value);
                                                    currentSet.remove(value);
                                                }
                                                catch (Throwable throwable) {
                                                    currentSet.remove(value);
                                                    throw throwable;
                                                }
                                                return string;
                                            }
                                            if (!(value instanceof String)) break block32;
                                            String s = (String)value;
                                            String string = DeepEquals.isSecureErrorsEnabled() ? DeepEquals.sanitizeStringValue(s) : "\"" + s + "\"";
                                            currentSet.remove(value);
                                            return string;
                                        }
                                        if (!(value instanceof Character)) break block33;
                                        String string = "'" + value + "'";
                                        currentSet.remove(value);
                                        return string;
                                    }
                                    if (!(value instanceof Date)) break block34;
                                    String string = TS_FMT.format((Date)value) + " UTC";
                                    currentSet.remove(value);
                                    return string;
                                }
                                if (!value.getClass().isEnum()) break block35;
                                String string = value.getClass().getSimpleName() + "." + ((Enum)value).name();
                                currentSet.remove(value);
                                return string;
                            }
                            if (!Converter.isSimpleTypeConversionSupported(value.getClass())) break block36;
                            String string = String.valueOf(value);
                            currentSet.remove(value);
                            return string;
                        }
                        if (!(value instanceof Collection)) break block37;
                        String string = DeepEquals.formatCollectionContents((Collection)value);
                        currentSet.remove(value);
                        return string;
                    }
                    if (!(value instanceof Map)) break block38;
                    String string = DeepEquals.formatMapContents((Map)value);
                    currentSet.remove(value);
                    return string;
                }
                if (!value.getClass().isArray()) break block39;
                String string = DeepEquals.formatArrayContents(value);
                currentSet.remove(value);
                return string;
            }
            String string = DeepEquals.formatComplexObject(value);
            currentSet.remove(value);
            return string;
        }
        finally {
            if (pushedNewSet) {
                stackOfSets.pop();
                if (stackOfSets.isEmpty()) {
                    formattingStack.remove();
                }
            }
        }
    }

    private static String formatArrayContents(Object array) {
        Class<?> type;
        int limit = 3;
        Class<?> componentType = type = array.getClass();
        while (componentType.getComponentType() != null) {
            componentType = componentType.getComponentType();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(componentType.getSimpleName());
        int outerLength = ArrayUtilities.getLength(array);
        sb.append("[").append(outerLength).append("]");
        for (Class<?> current = type.getComponentType(); current != null && current.isArray(); current = current.getComponentType()) {
            sb.append("[]");
        }
        sb.append("{");
        int length = ArrayUtilities.getLength(array);
        if (length > 0) {
            int showItems = Math.min(length, 3);
            for (int i = 0; i < showItems; ++i) {
                Object item;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((item = ArrayUtilities.getElement(array, i)) == null) {
                    sb.append("null");
                    continue;
                }
                if (item.getClass().isArray()) {
                    int subLength = ArrayUtilities.getLength(item);
                    sb.append('[');
                    for (int j = 0; j < Math.min(subLength, 3); ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(DeepEquals.formatValue(ArrayUtilities.getElement(item, j)));
                    }
                    if (subLength > 3) {
                        sb.append(", ...");
                    }
                    sb.append(']');
                    continue;
                }
                sb.append(DeepEquals.formatValue(item));
            }
            if (length > 3) {
                sb.append(", ...");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatCollectionContents(Collection<?> collection) {
        int limit = 3;
        StringBuilder sb = new StringBuilder();
        Class<?> type = collection.getClass();
        Class<?> elementType = DeepEquals.getCollectionElementType(collection);
        sb.append(type.getSimpleName());
        if (elementType != null) {
            sb.append("<").append(DeepEquals.getTypeSimpleName(elementType)).append(">");
        }
        sb.append("(").append(collection.size()).append(")");
        sb.append("{");
        if (!collection.isEmpty()) {
            Iterator<?> it = collection.iterator();
            for (int count = 0; count < 3 && it.hasNext(); ++count) {
                Object item;
                if (count > 0) {
                    sb.append(", ");
                }
                if ((item = it.next()) == null) {
                    sb.append("null");
                    continue;
                }
                if (item instanceof Collection) {
                    Collection subCollection = (Collection)item;
                    sb.append("(");
                    Iterator subIt = subCollection.iterator();
                    for (int j = 0; j < Math.min(subCollection.size(), 3); ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(DeepEquals.formatValue(subIt.next()));
                    }
                    if (subCollection.size() > 3) {
                        sb.append(", ...");
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(DeepEquals.formatValue(item));
            }
            if (collection.size() > 3) {
                sb.append(", ...");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatMapContents(Map<?, ?> map) {
        int limit = 3;
        StringBuilder sb = new StringBuilder();
        Class<?> type = map.getClass();
        Type[] typeArgs = DeepEquals.getMapTypes(map);
        sb.append(type.getSimpleName());
        if (typeArgs != null && typeArgs.length == 2) {
            sb.append("<").append(DeepEquals.getTypeSimpleName(typeArgs[0])).append(", ").append(DeepEquals.getTypeSimpleName(typeArgs[1])).append(">");
        }
        sb.append("(").append(map.size()).append(")");
        if (!map.isEmpty()) {
            Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
            for (int count = 0; count < 3 && it.hasNext(); ++count) {
                if (count > 0) {
                    sb.append(", ");
                }
                Map.Entry<?, ?> entry = it.next();
                sb.append(ANGLE_LEFT).append(DeepEquals.formatValue(entry.getKey())).append(" ").append(ARROW).append(" ").append(DeepEquals.formatValue(entry.getValue())).append(ANGLE_RIGHT);
            }
            if (map.size() > 3) {
                sb.append(", ...");
            }
        }
        return sb.toString();
    }

    private static String getTypeSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.getTypeName();
    }

    private static String formatComplexObject(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        sb.append(" {");
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj.getClass());
        boolean first = true;
        for (Field field : fields) {
            try {
                int modifiers;
                if (field.isSynthetic() || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers)) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String fieldName = field.getName();
                sb.append(fieldName).append(": ");
                if (DeepEquals.isSecureErrorsEnabled() && DeepEquals.isSensitiveField(fieldName)) {
                    sb.append("[REDACTED]");
                    continue;
                }
                Object value = field.get(obj);
                if (value == obj) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(DeepEquals.formatValue(value));
            }
            catch (Exception exception) {}
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatArrayNotation(Object array) {
        if (array == null) {
            return "null";
        }
        int length = ArrayUtilities.getLength(array);
        String typeName = DeepEquals.getTypeDescription(array.getClass().getComponentType());
        return String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1));
    }

    private static String formatCollectionNotation(Collection<?> col) {
        StringBuilder sb = new StringBuilder();
        sb.append(col.getClass().getSimpleName());
        Class<?> elementType = DeepEquals.getCollectionElementType(col);
        if (elementType != null && elementType != Object.class) {
            sb.append("<").append(DeepEquals.getTypeDescription(elementType)).append(">");
        }
        sb.append("(");
        if (col.isEmpty()) {
            sb.append(EMPTY);
        } else {
            sb.append("0..").append(col.size() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private static String formatMapNotation(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(map.getClass().getSimpleName());
        sb.append("(");
        if (map.isEmpty()) {
            sb.append(EMPTY);
        } else {
            sb.append("0..").append(map.size() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private static String formatMapKey(Object key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof String) {
            String s = (String)key;
            return DeepEquals.isSecureErrorsEnabled() ? DeepEquals.sanitizeStringValue(s) : "\"" + s + "\"";
        }
        String text = DeepEquals.formatValueConcise(key);
        return StringUtilities.removeLeadingAndTrailingQuotes(text);
    }

    private static String formatNumber(Number value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            double doubleValue = bd.doubleValue();
            if (Math.abs(doubleValue) >= 1.0E16 || Math.abs(doubleValue) < 1.0E-6 && doubleValue != 0.0) {
                return String.format(Locale.ROOT, "%.6e", doubleValue);
            }
            if (Math.abs(doubleValue) <= 1.0) {
                return bd.stripTrailingZeros().toPlainString();
            }
            return bd.stripTrailingZeros().toPlainString();
        }
        if (value instanceof Double || value instanceof Float) {
            double d = value.doubleValue();
            if (Math.abs(d) >= 1.0E16 || Math.abs(d) < 1.0E-6 && d != 0.0) {
                return String.format(Locale.ROOT, "%.6e", d);
            }
            if (value instanceof Double) {
                return String.format(Locale.ROOT, "%.15g", d).replaceAll("\\.?0+$", "");
            }
            return String.format(Locale.ROOT, "%.7g", d).replaceAll("\\.?0+$", "");
        }
        return value.toString();
    }

    private static String formatRootObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Collection) {
            return DeepEquals.formatCollectionNotation((Collection)obj);
        }
        if (obj instanceof Map) {
            return DeepEquals.formatMapNotation((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return DeepEquals.formatArrayNotation(obj);
        }
        if (Converter.isSimpleTypeConversionSupported(obj.getClass())) {
            return String.format("%s: %s", DeepEquals.getTypeDescription(obj.getClass()), DeepEquals.formatSimpleValue(obj));
        }
        return DeepEquals.formatValueConcise(obj);
    }

    private static String getTypeDescription(Class<?> type) {
        if (type == null) {
            return "Object";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return DeepEquals.getTypeDescription(componentType) + "[]";
        }
        return type.getSimpleName();
    }

    private static Type[] getMapTypes(Map<?, ?> map) {
        Type type = map.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    private static int getContainerSize(Object container) {
        if (container == null) {
            return 0;
        }
        if (container instanceof Collection) {
            return ((Collection)container).size();
        }
        if (container instanceof Map) {
            return ((Map)container).size();
        }
        if (container.getClass().isArray()) {
            return ArrayUtilities.getLength(container);
        }
        return 0;
    }

    private static String sanitizeStringValue(String str) {
        if (str == null) {
            return "null";
        }
        if (str.isEmpty()) {
            return "\"\"";
        }
        String lowerStr = str.toLowerCase(Locale.ROOT);
        if (DeepEquals.looksLikeSensitiveData(lowerStr)) {
            return "\"[REDACTED:" + str.length() + " chars]\"";
        }
        if (str.length() > 100) {
            return "\"" + str.substring(0, 97) + "...\"";
        }
        return "\"" + str + "\"";
    }

    private static String sanitizeUriValue(URI uri) {
        if (uri == null) {
            return "null";
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        StringBuilder sanitized = new StringBuilder();
        if (scheme != null) {
            sanitized.append(scheme).append("://");
        }
        if (host != null) {
            sanitized.append(host);
        }
        if (port != -1) {
            sanitized.append(":").append(port);
        }
        if (path != null && !path.isEmpty()) {
            sanitized.append(path);
        }
        if (uri.getQuery() != null || uri.getFragment() != null) {
            sanitized.append("?[QUERY_REDACTED]");
        }
        return sanitized.toString();
    }

    private static String sanitizeUrlValue(URL url) {
        if (url == null) {
            return "null";
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        StringBuilder sanitized = new StringBuilder();
        if (protocol != null) {
            sanitized.append(protocol).append("://");
        }
        if (host != null) {
            sanitized.append(host);
        }
        if (port != -1) {
            sanitized.append(":").append(port);
        }
        if (path != null && !path.isEmpty()) {
            sanitized.append(path);
        }
        if (url.getQuery() != null || url.getRef() != null) {
            sanitized.append("?[QUERY_REDACTED]");
        }
        return sanitized.toString();
    }

    private static boolean looksLikeSensitiveData(String lowerStr) {
        if (SENSITIVE_WORDS.matcher(lowerStr).matches()) {
            return true;
        }
        if (HEX_32_PLUS.matcher(lowerStr).matches()) {
            return true;
        }
        if (lowerStr.length() >= 32 && BASE64_PATTERN.matcher(lowerStr).matches()) {
            return true;
        }
        if (UUID_PATTERN.matcher(lowerStr).matches()) {
            return false;
        }
        return false;
    }

    private static boolean isSensitiveField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        String lowerFieldName = fieldName.toLowerCase(Locale.ROOT);
        return SENSITIVE_FIELD_NAMES.contains(lowerFieldName) || lowerFieldName.contains("password") || lowerFieldName.contains("secret") || lowerFieldName.contains("token");
    }

    static {
        TS_FMT.setTimeZone(TimeZone.getTimeZone("UTC"));
        BASE64_PATTERN = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
        HEX_32_PLUS = Pattern.compile("^[a-f0-9]{32,}$");
        SENSITIVE_WORDS = Pattern.compile(".*\\b(password|pwd|secret|token|credential|auth|apikey|api_key|secretkey|secret_key|privatekey|private_key)\\b.*");
        UUID_PATTERN = Pattern.compile("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
        formattingStack = ThreadLocal.withInitial(ArrayDeque::new);
        maxDepthBudgetStack = ThreadLocal.withInitial(ArrayDeque::new);
        SENSITIVE_FIELD_NAMES = CollectionUtilities.setOf("password", "pwd", "passwd", "secret", "token", "credential", "authorization", "authentication", "api_key", "apikey", "secretkey");
        DeepEquals.reloadSecurityProperties();
    }

    private static final class ItemsToCompare {
        private final Object _key1;
        private final Object _key2;
        private final ItemsToCompare parent;
        private final String fieldName;
        private final int[] arrayIndices;
        private final Object mapKey;
        private final Difference difference;
        private final int depth;

        private ItemsToCompare(Object k1, Object k2) {
            this(k1, k2, null, null, null, null, null, 0);
        }

        private ItemsToCompare(Object k1, Object k2, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, null, null, null, difference, parent != null ? parent.depth + 1 : 0);
        }

        private ItemsToCompare(Object k1, Object k2, String fieldName, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, fieldName, null, null, difference, parent != null ? parent.depth + 1 : 0);
        }

        private ItemsToCompare(Object k1, Object k2, int[] indices, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, null, indices, null, difference, parent != null ? parent.depth + 1 : 0);
        }

        private ItemsToCompare(Object k1, Object k2, Object mapKey, ItemsToCompare parent, boolean isMapKey, Difference difference) {
            this(k1, k2, parent, null, null, mapKey, difference, parent != null ? parent.depth + 1 : 0);
        }

        private ItemsToCompare(Object k1, Object k2, ItemsToCompare parent, String fieldName, int[] arrayIndices, Object mapKey, Difference difference, int depth) {
            this._key1 = k1;
            this._key2 = k2;
            this.parent = parent;
            this.fieldName = fieldName;
            this.arrayIndices = arrayIndices;
            this.mapKey = mapKey;
            this.difference = difference;
            this.depth = depth;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ItemsToCompare)) {
                return false;
            }
            ItemsToCompare that = (ItemsToCompare)other;
            return this._key1 == that._key1 && this._key2 == that._key2;
        }

        public int hashCode() {
            return System.identityHashCode(this._key1) * 31 + System.identityHashCode(this._key2);
        }
    }

    private static enum Difference {
        VALUE_MISMATCH("value mismatch", DiffCategory.VALUE),
        FIELD_VALUE_MISMATCH("field value mismatch", DiffCategory.VALUE),
        COLLECTION_SIZE_MISMATCH("collection size mismatch", DiffCategory.SIZE),
        COLLECTION_MISSING_ELEMENT("missing collection element", DiffCategory.VALUE),
        COLLECTION_TYPE_MISMATCH("collection type mismatch", DiffCategory.TYPE),
        COLLECTION_ELEMENT_MISMATCH("collection element mismatch", DiffCategory.VALUE),
        MAP_SIZE_MISMATCH("map size mismatch", DiffCategory.SIZE),
        MAP_MISSING_KEY("missing map key", DiffCategory.VALUE),
        MAP_VALUE_MISMATCH("map value mismatch", DiffCategory.VALUE),
        ARRAY_DIMENSION_MISMATCH("array dimensionality mismatch", DiffCategory.DIMENSION),
        ARRAY_COMPONENT_TYPE_MISMATCH("array component type mismatch", DiffCategory.TYPE),
        ARRAY_LENGTH_MISMATCH("array length mismatch", DiffCategory.LENGTH),
        ARRAY_ELEMENT_MISMATCH("array element mismatch", DiffCategory.VALUE),
        TYPE_MISMATCH("type mismatch", DiffCategory.TYPE);

        private final String description;
        private final DiffCategory category;

        private Difference(String description, DiffCategory category) {
            this.description = description;
            this.category = category;
        }

        String getDescription() {
            return this.description;
        }

        DiffCategory getCategory() {
            return this.category;
        }
    }

    private static final class ScopedSet
    extends AbstractSet<ItemsToCompare> {
        private final Set<ItemsToCompare> base;
        private Set<ItemsToCompare> local;

        ScopedSet(Set<ItemsToCompare> base) {
            this.base = base;
        }

        @Override
        public boolean contains(Object o) {
            return this.base.contains(o) || this.local != null && this.local.contains(o);
        }

        @Override
        public boolean add(ItemsToCompare item) {
            if (this.base.contains(item)) {
                return false;
            }
            if (this.local == null) {
                this.local = new HashSet<ItemsToCompare>();
            }
            return this.local.add(item);
        }

        @Override
        public Iterator<ItemsToCompare> iterator() {
            throw new UnsupportedOperationException("ScopedSet does not support iteration");
        }

        @Override
        public int size() {
            int size = this.base.size();
            if (this.local != null) {
                size += this.local.size();
            }
            return size;
        }
    }

    private static class PathResult {
        final String path;
        final String mismatchPhrase;

        PathResult(String path, String mismatchPhrase) {
            this.path = path;
            this.mismatchPhrase = mismatchPhrase;
        }
    }

    private static enum DiffCategory {
        VALUE,
        TYPE,
        SIZE,
        LENGTH,
        DIMENSION;

    }
}

