/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.FastByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] buf;
    private int count;

    public FastByteArrayOutputStream() {
        this(32);
    }

    public FastByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = FastByteArrayOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError("Required array size too large");
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Input byte array cannot be null");
        }
        if (len == 0) {
            return;
        }
        if (off < 0 || len < 0 || off > b.length || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] getBuffer() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] getInternalBuffer() {
        return this.buf;
    }

    public int getCount() {
        return this.count;
    }

    public FastByteArrayInputStream toInputStream() {
        return new FastByteArrayInputStream(this.toByteArray());
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(Charset charset) {
        return new String(this.buf, 0, this.count, charset);
    }

    public void writeTo(OutputStream out) {
        try {
            out.write(this.buf, 0, this.count);
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
    }

    @Override
    public void close() {
    }
}

