/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Color;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;

final class ArrayConversions {
    private ArrayConversions() {
    }

    static Object arrayToArray(Object sourceArray, Class<?> targetArrayType, Converter converter) {
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        int length = ArrayUtilities.getLength(sourceArray);
        Class<?> targetComponentType = targetArrayType.getComponentType();
        Object targetArray = Array.newInstance(targetComponentType, length);
        visited.put(sourceArray, targetArray);
        ArrayDeque<ArrayWorkItem> queue = new ArrayDeque<ArrayWorkItem>();
        queue.add(new ArrayWorkItem(sourceArray, targetArray, targetComponentType));
        while (!queue.isEmpty()) {
            ArrayWorkItem work = (ArrayWorkItem)queue.poll();
            Object src = work.sourceArray;
            Object tgt = work.targetArray;
            Class<?> compType = work.targetComponentType;
            int len = ArrayUtilities.getLength(src);
            for (int i = 0; i < len; ++i) {
                Object convertedValue;
                Object value = ArrayUtilities.getElement(src, i);
                if (value == null) {
                    convertedValue = null;
                } else if (value.getClass().isArray()) {
                    if (visited.containsKey(value)) {
                        Object existingTarget = visited.get(value);
                        convertedValue = compType.isAssignableFrom(existingTarget.getClass()) ? existingTarget : (compType.isPrimitive() ? ArrayConversions.getPrimitiveZeroValue(compType) : existingTarget);
                    } else if (compType.isArray() || compType == Object.class || compType.isAssignableFrom(value.getClass())) {
                        int valueLen = ArrayUtilities.getLength(value);
                        Class nestedComponentType = compType.isArray() ? compType.getComponentType() : Object.class;
                        Object nestedTarget = Array.newInstance(nestedComponentType, valueLen);
                        visited.put(value, nestedTarget);
                        queue.add(new ArrayWorkItem(value, nestedTarget, nestedComponentType));
                        convertedValue = nestedTarget;
                    } else {
                        convertedValue = converter.convert(value, compType);
                    }
                } else {
                    convertedValue = compType.isAssignableFrom(value.getClass()) ? value : converter.convert(value, compType);
                }
                ArrayUtilities.setElement(tgt, i, convertedValue);
            }
        }
        return targetArray;
    }

    private static Object getPrimitiveZeroValue(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return 0;
        }
        if (primitiveType == Long.TYPE) {
            return 0L;
        }
        if (primitiveType == Double.TYPE) {
            return 0.0;
        }
        if (primitiveType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (primitiveType == Short.TYPE) {
            return (short)0;
        }
        if (primitiveType == Byte.TYPE) {
            return (byte)0;
        }
        if (primitiveType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (primitiveType == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    static Object collectionToArray(Collection<?> collection, Class<?> arrayType, Converter converter) {
        IdentityHashMap visited = new IdentityHashMap();
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, collection.size());
        visited.put(collection, array);
        ArrayDeque<CollectionWorkItem> queue = new ArrayDeque<CollectionWorkItem>();
        queue.add(new CollectionWorkItem(collection, array, componentType));
        while (!queue.isEmpty()) {
            CollectionWorkItem work = (CollectionWorkItem)queue.poll();
            Collection<?> srcCollection = work.sourceCollection;
            Object tgtArray = work.targetArray;
            Class<?> compType = work.targetComponentType;
            int index = 0;
            for (Object item : srcCollection) {
                Object convertedValue;
                if (item == null) {
                    convertedValue = null;
                } else if (item instanceof Collection) {
                    if (visited.containsKey(item)) {
                        Object existingTarget = visited.get(item);
                        convertedValue = compType.isAssignableFrom(existingTarget.getClass()) ? (Object)existingTarget : (compType.isPrimitive() ? ArrayConversions.getPrimitiveZeroValue(compType) : (Object)existingTarget);
                    } else if (compType.isArray()) {
                        Collection nestedCollection = (Collection)item;
                        Class<?> nestedComponentType = compType.getComponentType();
                        Object nestedTarget = Array.newInstance(nestedComponentType, nestedCollection.size());
                        visited.put((Collection<?>)item, nestedTarget);
                        queue.add(new CollectionWorkItem(nestedCollection, nestedTarget, nestedComponentType));
                        convertedValue = nestedTarget;
                    } else {
                        convertedValue = compType.isAssignableFrom(item.getClass()) ? (Object)item : (Object)converter.convert(item, compType);
                    }
                } else {
                    convertedValue = compType.isAssignableFrom(item.getClass()) ? (Object)item : (Object)converter.convert(item, compType);
                }
                ArrayUtilities.setElement(tgtArray, index++, convertedValue);
            }
        }
        return array;
    }

    static Object enumSetToArray(EnumSet<?> enumSet, Class<?> targetArrayType) {
        Class<?> componentType = targetArrayType.getComponentType();
        Object array = Array.newInstance(componentType, enumSet.size());
        int i = 0;
        if (componentType == String.class) {
            for (Enum value : enumSet) {
                ArrayUtilities.setElement(array, i++, value.name());
            }
        } else if (componentType == Integer.class || componentType == Integer.TYPE || componentType == Long.class || componentType == Long.TYPE) {
            for (Enum value : enumSet) {
                ArrayUtilities.setElement(array, i++, value.ordinal());
            }
        } else if (componentType == Short.class || componentType == Short.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Enum ordinal too large for short: " + ordinal);
                }
                ArrayUtilities.setElement(array, i++, (short)ordinal);
            }
        } else if (componentType == Byte.class || componentType == Byte.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > 127) {
                    throw new IllegalArgumentException("Enum ordinal too large for byte: " + ordinal);
                }
                ArrayUtilities.setElement(array, i++, (byte)ordinal);
            }
        } else if (componentType == Class.class) {
            for (Enum value : enumSet) {
                ArrayUtilities.setElement(array, i++, value.getDeclaringClass());
            }
        } else {
            for (Enum value : enumSet) {
                ArrayUtilities.setElement(array, i++, value);
            }
        }
        return array;
    }

    static Color toColor(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length < 3 || array.length > 4) {
            throw new IllegalArgumentException("Color array must have 3 (RGB) or 4 (RGBA) elements, got: " + array.length);
        }
        int r = array[0];
        int g = array[1];
        int b = array[2];
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB values must be between 0-255, got: [" + r + ", " + g + ", " + b + "]");
        }
        if (array.length == 4) {
            int a = array[3];
            if (a < 0 || a > 255) {
                throw new IllegalArgumentException("Alpha value must be between 0-255, got: " + a);
            }
            return new Color(r, g, b, a);
        }
        return new Color(r, g, b);
    }

    static Dimension toDimension(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 2) {
            throw new IllegalArgumentException("Dimension array must have exactly 2 elements [width, height], got: " + array.length);
        }
        int width = array[0];
        int height = array[1];
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be non-negative, got: [" + width + ", " + height + "]");
        }
        return new Dimension(width, height);
    }

    static Point toPoint(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 2) {
            throw new IllegalArgumentException("Point array must have exactly 2 elements [x, y], got: " + array.length);
        }
        int x = array[0];
        int y = array[1];
        return new Point(x, y);
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 4) {
            throw new IllegalArgumentException("Rectangle array must have exactly 4 elements [x, y, width, height], got: " + array.length);
        }
        int x = array[0];
        int y = array[1];
        int width = array[2];
        int height = array[3];
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be non-negative, got: [width=" + width + ", height=" + height + "]");
        }
        return new Rectangle(x, y, width, height);
    }

    static Insets toInsets(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 4) {
            throw new IllegalArgumentException("Insets array must have exactly 4 elements [top, left, bottom, right], got: " + array.length);
        }
        int top = array[0];
        int left = array[1];
        int bottom = array[2];
        int right = array[3];
        return new Insets(top, left, bottom, right);
    }

    static File charArrayToFile(Object from, Converter converter) {
        char[] array = (char[])from;
        String path = new String(array);
        return converter.convert(path, File.class);
    }

    static File byteArrayToFile(Object from, Converter converter) {
        byte[] array = (byte[])from;
        String path = new String(array, StandardCharsets.UTF_8);
        return converter.convert(path, File.class);
    }

    static Path charArrayToPath(Object from, Converter converter) {
        char[] array = (char[])from;
        String path = new String(array);
        return converter.convert(path, Path.class);
    }

    static Path byteArrayToPath(Object from, Converter converter) {
        byte[] array = (byte[])from;
        String path = new String(array, StandardCharsets.UTF_8);
        return converter.convert(path, Path.class);
    }

    private static class ArrayWorkItem {
        final Object sourceArray;
        final Object targetArray;
        final Class<?> targetComponentType;

        ArrayWorkItem(Object sourceArray, Object targetArray, Class<?> targetComponentType) {
            this.sourceArray = sourceArray;
            this.targetArray = targetArray;
            this.targetComponentType = targetComponentType;
        }
    }

    private static class CollectionWorkItem {
        final Collection<?> sourceCollection;
        final Object targetArray;
        final Class<?> targetComponentType;

        CollectionWorkItem(Collection<?> sourceCollection, Object targetArray, Class<?> targetComponentType) {
            this.sourceCollection = sourceCollection;
            this.targetArray = targetArray;
            this.targetComponentType = targetComponentType;
        }
    }
}

