/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.Converter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public interface ConverterOptions {
    default public ZoneId getZoneId() {
        return ZoneId.systemDefault();
    }

    default public Locale getLocale() {
        return Locale.getDefault();
    }

    default public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    default public ClassLoader getClassLoader() {
        return ClassUtilities.getClassLoader(ConverterOptions.class);
    }

    default public <T> T getCustomOption(String name) {
        return null;
    }

    default public Map<String, Object> getCustomOptions() {
        return new HashMap<String, Object>();
    }

    default public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getZoneId());
    }

    default public Character trueChar() {
        return CommonValues.CHARACTER_ONE;
    }

    default public Character falseChar() {
        return CommonValues.CHARACTER_ZERO;
    }

    default public Map<Converter.ConversionPair, Convert<?>> getConverterOverrides() {
        return new HashMap();
    }

    default public int getMaxEnumNameLength() {
        return 1000;
    }
}

