/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit.api;

import com.clivern.wit.api.Contract;
import com.clivern.wit.api.endpoint.AppEndpoint;
import com.clivern.wit.exception.DataNotFound;
import com.clivern.wit.exception.DataNotValid;
import java.util.HashMap;
import java.util.Map;
import org.pmw.tinylog.Logger;

public class App
implements Contract {
    public String appId = "";
    public String accessToken = "";
    public String endpointName = "";
    public String contentType = AppEndpoint.CONTENT_TYPE;
    public String url = "";
    public String method = "";
    public Map<String, String> data = new HashMap<String, String>();
    public String finalData = "";
    public Map<String, String> headers = new HashMap<String, String>();
    public Integer offset = 0;
    public Integer limit = 500;

    public App(String endpointName) {
        this.endpointName = endpointName;
    }

    public App(String endpointName, String contentType) {
        this.endpointName = endpointName;
        this.contentType = contentType;
    }

    @Override
    public Boolean config() throws DataNotValid, DataNotFound {
        this.headers.put("Authorization", "Bearer " + this.accessToken);
        this.headers.put("Content-Type", this.contentType);
        if (this.endpointName.equals(AppEndpoint.GET)) {
            this.url = AppEndpoint.GET_ENDPOINT;
            this.method = AppEndpoint.GET_METHOD;
        } else if (this.endpointName.equals(AppEndpoint.CREATE)) {
            this.url = AppEndpoint.CREATE_ENDPOINT;
            this.method = AppEndpoint.CREATE_METHOD;
            if (this.getName().equals("") || this.getLang().equals("") || this.getPrivate().equals("")) {
                Logger.error((String)"Error! App Name, Lang and IsPrivate are required to create a New App.");
                throw new DataNotFound("Error! App Name, Lang and IsPrivate are required to create a New App.");
            }
        } else if (this.endpointName.equals(AppEndpoint.UPDATE)) {
            this.url = AppEndpoint.UPDATE_ENDPOINT;
            this.method = AppEndpoint.UPDATE_METHOD;
        } else if (this.endpointName.equals(AppEndpoint.DELETE)) {
            this.url = AppEndpoint.DELETE_ENDPOINT;
            this.method = AppEndpoint.DELETE_METHOD;
        } else {
            Logger.error((String)"Error! Invalid endpointName Value.");
            throw new DataNotValid("Error! Invalid endpointName Value.");
        }
        if (!this.data.isEmpty()) {
            this.finalData = this.finalData + "{";
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.finalData = this.finalData + "\"" + key + "\":\"" + value + "\",";
            }
            this.finalData = this.finalData.replaceAll(",$", "");
            this.finalData = this.finalData + "}";
        }
        this.url = this.url.replace("{$APP_ID}", this.appId);
        this.url = this.url.replace("{$OFFSET}", this.offset.toString());
        this.url = this.url.replace("{$LIMIT}", this.limit.toString());
        return true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getData() {
        return this.finalData;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.data.containsKey("name") ? this.data.get("name") : "";
    }

    public String getLang() {
        return this.data.containsKey("lang") ? this.data.get("lang") : "";
    }

    public String getPrivate() {
        return this.data.containsKey("private") ? this.data.get("private") : "";
    }

    public String getDesc() {
        return this.data.containsKey("desc") ? this.data.get("desc") : "";
    }

    public String getTimezone() {
        return this.data.containsKey("timezone") ? this.data.get("timezone") : "";
    }

    @Override
    public void setAppId(String appId) {
        if (this.appId.equals("")) {
            this.appId = appId;
        }
    }

    @Override
    public void setAccessToken(String accessToken) {
        if (this.accessToken.equals("")) {
            this.accessToken = accessToken;
        }
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.data.put("name", name);
    }

    public void setLang(String lang) {
        this.data.put("lang", lang);
    }

    public void setPrivate(String isPrivate) {
        this.data.put("private", isPrivate);
    }

    public void setDesc(String desc) {
        this.data.put("desc", desc);
    }

    public void setTimezone(String timezone) {
        this.data.put("timezone", timezone);
    }

    @Override
    public String debug() {
        String debug = "> curl -X" + this.method + " '" + this.url + "'";
        if (!this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                debug = debug + " -H \"" + key + ": " + value + "\"";
            }
        }
        if (!this.getData().equals("")) {
            debug = debug + " -d '" + this.getData() + "'";
        }
        return debug;
    }
}

