/*
 * Copyright 2010-2013, CloudBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.cloudbees.clickstack.domain.metadata;

import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:cleclerc@cloudbees.com">Cyrille Le Clerc</a>
 */
public class Papertrail extends Syslog {

    public static final List<String> TYPES = Arrays.asList("papertrail", "log");


    public Papertrail(Resource resource){
        super(resource);
        this.hostname = resource.getProperty("PAPERTRAIL_SYSLOG_HOSTNAME","logs.papertrailapp.com");
        this.port = Integer.parseInt(resource.getProperty("PAPERTRAIL_SYSLOG_PORT"));
        this.facility = "USER";
    }
}
