/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Resource;
import java.util.Arrays;
import java.util.List;

public class Email
extends Resource {
    public static final String HOST_PROPERTY = "SENDGRID_SMTP_HOST";
    public static final String PORT_PROPERTY = "SENDGRID_SMTP_PORT";
    public static final String USERNAME_PROPERTY = "SENDGRID_USERNAME";
    public static final String PASSWORD_PROPERTY = "SENDGRID_PASSWORD";
    public static final List<String> TYPES = Arrays.asList("email");

    protected Email(Resource resource) {
        super(resource.getProperties(), resource.getDescriptors());
        if (!Email.checkResource(resource)) {
            throw new IllegalArgumentException("Incorrect email resource definition.");
        }
    }

    protected static boolean checkResource(Resource resource) {
        return resource != null && TYPES.contains(resource.getType()) && resource.getProperty(HOST_PROPERTY) != null && resource.getProperty(USERNAME_PROPERTY) != null && resource.getProperty(PASSWORD_PROPERTY) != null;
    }

    public String getHost() {
        return this.getProperty(HOST_PROPERTY);
    }

    public int getPort() {
        return Integer.parseInt(this.getProperty(PORT_PROPERTY, "25"));
    }

    public String getUsername() {
        return this.getProperty(USERNAME_PROPERTY);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY);
    }
}

