/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Resource;
import java.util.Arrays;
import java.util.List;

public class SessionStore
extends Resource {
    public static final String NODES_PROPERTY = "servers";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    public static final List<String> TYPES = Arrays.asList("session-store");

    protected static boolean checkResource(Resource resource) {
        boolean isValid = resource != null;
        if (isValid) {
            isValid = TYPES.contains(resource.getType());
            isValid = isValid && resource.getProperty(NODES_PROPERTY) != null;
            isValid = isValid && resource.getProperty(USERNAME_PROPERTY) != null;
            isValid = isValid && resource.getProperty(PASSWORD_PROPERTY) != null;
        }
        return isValid;
    }

    protected SessionStore(Resource resource) {
        super(resource.getProperties(), resource.getDescriptors());
        if (!SessionStore.checkResource(resource)) {
            throw new IllegalArgumentException("Incorrect session store resource definition.");
        }
    }

    public String getNodes() {
        String nodes = "";
        String[] nodeArray = this.getProperty(NODES_PROPERTY).split(",");
        for (int i = 0; i < nodeArray.length; ++i) {
            if (i != 0) {
                nodes = nodes + ",";
            }
            nodes = nodes + "http://" + nodeArray[i] + ":8091/pools";
        }
        return nodes;
    }

    public String getUsername() {
        return this.getProperty(USERNAME_PROPERTY);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY);
    }
}

