/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.plugin.java;

import com.cloudbees.clickstack.domain.environment.Environment;
import com.cloudbees.clickstack.domain.metadata.Metadata;
import com.cloudbees.clickstack.plugin.java.JavaPluginResult;
import com.cloudbees.clickstack.util.Files2;
import com.cloudbees.clickstack.util.HttpUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPlugin {
    public static final String DEFAULT_JAVA_VERSION = "1.7";
    private static final Pattern VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FileSystem fs = FileSystems.getDefault();

    public JavaPluginResult setup(Metadata metadata, Environment environment) throws IOException {
        Path jreHome;
        Path javaHome;
        String javaVersion;
        switch (javaVersion = metadata.getRuntimeParameter("java", "version", DEFAULT_JAVA_VERSION)) {
            case "6": 
            case "1.6": {
                javaHome = this.fs.getPath("/opt/java6", new String[0]);
                break;
            }
            case "7": 
            case "1.7": {
                javaHome = this.fs.getPath("/opt/java7", new String[0]);
                break;
            }
            case "8": 
            case "1.8": {
                javaHome = this.fs.getPath("/opt/java8", new String[0]);
                break;
            }
            case "custom": {
                this.logger.warn("You're running with a custom JRE, AT YOUR OWN RISK");
                String path = this.expand(metadata.getRuntimeParameter("java", "home"), environment);
                javaHome = this.fs.getPath(path, new String[0]);
                break;
            }
            default: {
                javaHome = javaVersion.startsWith("http://") || javaVersion.startsWith("https://") ? this.installJvm(javaVersion, environment) : this.fs.getPath("/opt/", new String[0]).resolve(javaVersion);
            }
        }
        Preconditions.checkState((boolean)Files.exists(javaHome, new LinkOption[0]), (String)"JAVA_HOME %s does not exist for specified java version %s", (Object[])new Object[]{javaHome, javaVersion});
        Preconditions.checkState((boolean)Files.isDirectory(javaHome, new LinkOption[0]), (String)"JAVA_HOME %s is not a directory for specified java version %s", (Object[])new Object[]{javaHome, javaVersion});
        Path javaExecutable = javaHome.resolve("bin/java");
        if (!Files.exists(javaExecutable, new LinkOption[0]) && Files.exists(jreHome = javaHome.resolve("jre"), new LinkOption[0]) && Files.isDirectory(jreHome, new LinkOption[0])) {
            javaHome = jreHome;
            javaExecutable = javaHome.resolve("bin/java");
        }
        Preconditions.checkState((boolean)Files.exists(javaExecutable, new LinkOption[0]), (String)"java executable %s does not exist under JAVA_HOME %s for specified java version %s", (Object[])new Object[]{javaExecutable, javaHome, javaVersion});
        Preconditions.checkState((!Files.isDirectory(javaExecutable, new LinkOption[0]) ? 1 : 0) != 0, (String)"java executable %s under JAVA_HOME %s is not a file for specified java version %s", (Object[])new Object[]{javaExecutable, javaHome, javaVersion});
        Set<PosixFilePermission> posixFilePermissions = Files.getPosixFilePermissions(javaExecutable, new LinkOption[0]);
        if (!posixFilePermissions.containsAll(Arrays.asList(PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OWNER_EXECUTE))) {
            this.logger.warn("Missing permissions for {} ({}), add read & execute", (Object)javaExecutable, posixFilePermissions);
            Files2.chmodAddReadExecute(javaExecutable);
        }
        return new JavaPluginResult(javaHome, javaExecutable);
    }

    @Nonnull
    protected Path installJvm(@Nonnull String jvmPackageUrl, @Nonnull Environment environment) throws IOException {
        Path tmpFile = Files.createTempFile("jvm", ".tmp", new FileAttribute[0]);
        try {
            Path childDir;
            Path jvmFolder = environment.genappDir.resolve("jvm");
            HttpUtils.get(new URL(jvmPackageUrl), tmpFile);
            this.logger.debug("Install JVM {} in {}", (Object)jvmPackageUrl, (Object)jvmFolder);
            Files.createDirectories(jvmFolder, new FileAttribute[0]);
            String lowercaseUrl = jvmPackageUrl.toLowerCase();
            if (lowercaseUrl.endsWith(".zip")) {
                Files2.unzip(tmpFile, jvmFolder);
            } else if (lowercaseUrl.endsWith(".tgz") || lowercaseUrl.endsWith(".tar.gz")) {
                Files2.untgz(tmpFile, jvmFolder);
            } else {
                throw new IllegalStateException("Unsupported JVM url, expected suffix '.zip', '.tgz' or '.tar.gz'");
            }
            if (Files.exists(jvmFolder.resolve("bin/java"), new LinkOption[0])) {
                Path path = jvmFolder;
                return path;
            }
            try {
                childDir = Files2.findUniqueChildDirectory(jvmFolder);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("JAVA_HOME with JAVA_HOME/bin/java not found in " + jvmPackageUrl, e);
            }
            if (Files.exists(childDir.resolve("bin/java"), new LinkOption[0])) {
                Path path = childDir;
                return path;
            }
            throw new IllegalStateException("JAVA_HOME with JAVA_HOME/bin/java not found in dir " + childDir.getFileName() + " of " + jvmPackageUrl);
        }
        finally {
            Files.delete(tmpFile);
        }
    }

    public String expand(@Nullable String s, @Nonnull Environment env) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = this.resolve(key, env);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    private String resolve(String key, @Nonnull Environment env) {
        switch (key) {
            case "app_dir": {
                return env.appDir.toAbsolutePath().toString();
            }
            case "plugin_dir": {
                return env.clickstackDir.toAbsolutePath().toString();
            }
            case "pkg_dir": {
                return env.packageDir.toAbsolutePath().toString();
            }
            case "app_user": {
                return env.appUser;
            }
            case "app_id": {
                return env.appId;
            }
            case "app_port": {
                return String.valueOf(env.appPort);
            }
            case "control_dir": {
                return env.controlDir.toAbsolutePath().toString();
            }
            case "log_dir": {
                return env.logDir.toAbsolutePath().toString();
            }
            case "genapp_dir": {
                return env.genappDir.toAbsolutePath().toString();
            }
            case "app-extra-files": {
                return env.appExtraFiles.toAbsolutePath().toString();
            }
        }
        return key;
    }
}

