/*
 * Copyright 2010-2013, CloudBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.cloudbees.clickstack.domain.metadata;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * This class stores properties for a given name (i.e. java, tomcat, glassfish3, etc...)
 */

public class RuntimeProperty extends HashMap<String, String> {

    private String name;

    /**
     * Create a new RuntimeProperty from the name name and a map of key-value pairs.
     * @param name The parent name of the parameters.
     * @param parameters A key-value map of the parameters.
     */
    public RuntimeProperty (String name, Map<String, String> parameters) {
        this(name);
        putAll(parameters);
    }

    public RuntimeProperty (String name) {
        this.name = name;
    }

    public String getSection() {
        return name;
    }

    @Nullable
    public String getProperty(String name) {
        return get(name);
    }

    public String setProperty(String name, String value) {
        return put(name, value);
    }

    @Nullable
    public String getParameter(String parameterName) {
        return getProperty(parameterName);
    }

}
