/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.environment;

import com.cloudbees.clickstack.domain.metadata.Metadata;
import com.cloudbees.clickstack.util.Files2;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    @Nonnull
    public final Path appDir;
    @Nonnull
    public final Path clickstackDir;
    @Nonnull
    public final Path packageDir;
    @Nonnull
    public final String appUser;
    @Nonnull
    public final String appId;
    public final int appPort;
    @Nonnull
    public final Path controlDir;
    @Nonnull
    public final Path logDir;
    @Nonnull
    public final Path genappDir;
    @Nonnull
    private final Path appExtraFiles;
    public static final String DEFAULT_JAVA_VERSION = "1.7";
    private static final Pattern VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);

    public Environment(@Nonnull Path appDir, @Nonnull Path clickstackDir, @Nonnull Path packageDir, @Nonnull String appUser, @Nonnull String appId, int appPort) {
        this(appDir, clickstackDir, packageDir, appUser, appId, appPort, appDir.resolve(".genapp/control"), appDir.resolve(".genapp/log"));
    }

    public Environment(@Nonnull Path appDir, @Nonnull Path clickstackDir, @Nonnull Path packageDir, @Nonnull String appUser, @Nonnull String appId, int appPort, @Nonnull Path controlDir, @Nonnull Path logDir) {
        this.appDir = appDir;
        this.clickstackDir = clickstackDir;
        this.packageDir = packageDir;
        this.appUser = appUser;
        this.appId = appId;
        this.appPort = appPort;
        this.controlDir = controlDir;
        this.logDir = logDir;
        this.genappDir = appDir.resolve(".genapp");
        this.appExtraFiles = appDir.resolve("app-extra-files");
    }

    public String toString() {
        return "Environment{, \n appUser='" + this.appUser + '\'' + ", \n" + " appId='" + this.appId + '\'' + ", \n" + " appPort=" + this.appPort + ", \n" + " appDir=" + this.appDir.toAbsolutePath() + ", \n" + " logDir=" + this.logDir.toAbsolutePath() + ", \n" + " genappDir=" + this.genappDir.toAbsolutePath() + ", \n" + " controlDir=" + this.controlDir.toAbsolutePath() + ", \n" + " clickstackDir=" + this.clickstackDir.toAbsolutePath() + ", \n" + " packageDir=" + this.packageDir.toAbsolutePath() + ", \n" + '}';
    }

    @Nonnull
    public Path getJavaExecutable(Metadata metadata) throws IOException {
        Path javaPath = this.getJavaHome(metadata).resolve("bin/java");
        Preconditions.checkState((boolean)Files.exists(javaPath, new LinkOption[0]), (Object)"Java executable %s does not exist");
        Preconditions.checkState((!Files.isDirectory(javaPath, new LinkOption[0]) ? 1 : 0) != 0, (Object)"Java executable %s is not a file");
        return javaPath;
    }

    @Nonnull
    public Path getJavaHome(Metadata metadata) throws IOException {
        Path javaHome;
        String javaVersion;
        switch (javaVersion = metadata.getRuntimeParameter("java", "version", DEFAULT_JAVA_VERSION)) {
            case "6": 
            case "1.6": {
                javaHome = FileSystems.getDefault().getPath("/opt/java6", new String[0]);
                break;
            }
            case "7": 
            case "1.7": {
                javaHome = FileSystems.getDefault().getPath("/opt/java7", new String[0]);
                break;
            }
            case "8": 
            case "1.8": {
                javaHome = FileSystems.getDefault().getPath("/opt/java8", new String[0]);
                break;
            }
            case "custom": {
                LOGGER.warn("**WARNING** you're running with a custom JRE, at your own risk");
                String path = this.expand(metadata.getRuntimeParameter("java", "home"));
                javaHome = FileSystems.getDefault().getPath(path, new String[0]);
                Files2.chmodAddReadExecute(javaHome.resolve("bin"));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported java version " + javaVersion);
            }
        }
        Preconditions.checkState((boolean)Files.exists(javaHome, new LinkOption[0]), (Object)"JavaHome %s does not exist");
        Preconditions.checkState((boolean)Files.isDirectory(javaHome, new LinkOption[0]), (Object)"JavaHome %s is not a directory");
        return javaHome;
    }

    public String expand(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = this.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    private String resolve(String key) {
        switch (key) {
            case "app_dir": {
                return this.appDir.toAbsolutePath().toString();
            }
            case "plugin_dir": {
                return this.clickstackDir.toAbsolutePath().toString();
            }
            case "pkg_dir": {
                return this.packageDir.toAbsolutePath().toString();
            }
            case "app_user": {
                return this.appUser;
            }
            case "app_id": {
                return this.appId;
            }
            case "app_port": {
                return String.valueOf(this.appPort);
            }
            case "control_dir": {
                return this.controlDir.toAbsolutePath().toString();
            }
            case "log_dir": {
                return this.logDir.toAbsolutePath().toString();
            }
            case "genapp_dir": {
                return this.genappDir.toAbsolutePath().toString();
            }
            case "app-extra-files": {
                return this.appExtraFiles.toAbsolutePath().toString();
            }
        }
        return key;
    }
}

