/*
 * Copyright 2010-2013, CloudBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.cloudbees.clickstack.util;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * @author <a href="mailto:cleclerc@cloudbees.com">Cyrille Le Clerc</a>
 */
public class ApplicationUtils {

    /**
     * @param packageFile the given {@code app.war}, {@code app.zip} ...
     * @param appDir      the genapp appdir in which the app is deployed
     */
    public static void extractApplicationExtraFiles(@Nonnull Path packageFile, @Nonnull Path appDir) throws IOException {
        Path destDir = appDir.resolve("app-extra-files");
        if(!Files.exists(destDir)) {
            Files.createDirectories(destDir);
        }

        Files2.unzipSubDirectoryIfExists(packageFile, "META-INF/extra-files", destDir);
    }
    /**
     * @param packageFile the given {@code app.war}, {@code app.zip} ...
     * @param destDir      the directory in which the extra libs must be unzipped
     */
    public static void extractContainerExtraLibs(@Nonnull Path packageFile, @Nonnull Path destDir) throws IOException {
        if(!Files.exists(destDir)) {
            Files.createDirectories(destDir);
        }

        Files2.unzipSubDirectoryIfExists(packageFile, "META-INF/lib", destDir);
    }
}
