/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Resource;
import com.cloudbees.clickstack.domain.metadata.RuntimeProperty;
import com.cloudbees.clickstack.util.Strings2;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Metadata {
    private Map<String, Resource> resources;
    private Map<String, String> environment;
    private Map<String, RuntimeProperty> runtimeProperties;

    protected Metadata(Map<String, Resource> resources, Map<String, String> environment, Map<String, RuntimeProperty> runtimeProperties) {
        this.resources = resources;
        this.environment = environment;
        this.runtimeProperties = runtimeProperties;
    }

    public Metadata() {
        this.resources = new HashMap<String, Resource>();
        this.environment = new HashMap<String, String>();
        this.runtimeProperties = new HashMap<String, RuntimeProperty>();
    }

    @Nonnull
    public <R extends Resource> R getResource(String resourceName) {
        return (R)this.resources.get(resourceName);
    }

    @Nonnull
    public Map<String, Resource> getResources() {
        return this.resources;
    }

    @Nonnull
    public <R extends Resource> Collection<R> getResources(final Class<R> type) {
        return Collections2.filter(this.resources.values(), (Predicate)new Predicate<Resource>(){

            public boolean apply(@Nullable Resource r) {
                return type.isAssignableFrom(r.getClass());
            }
        });
    }

    public String getEnvironmentVariable(String variableName) {
        return this.environment.get(variableName);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public boolean hasSection(String section) {
        return this.runtimeProperties.containsKey(section);
    }

    @Nullable
    public RuntimeProperty getRuntimeProperty(String section) {
        RuntimeProperty runtimeProperty = this.runtimeProperties.get(section);
        if (runtimeProperty == null) {
            return null;
        }
        return runtimeProperty;
    }

    @Nullable
    public String getRuntimeParameter(String section, String name) {
        RuntimeProperty runtimeProperty = this.runtimeProperties.get(section);
        if (runtimeProperty == null) {
            return null;
        }
        return runtimeProperty.getParameter(name);
    }

    public String getRuntimeParameter(String section, String name, String defaultValue) {
        RuntimeProperty runtimeProperty = this.runtimeProperties.get(section);
        if (runtimeProperty == null) {
            return defaultValue;
        }
        String value = runtimeProperty.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setRuntimeParameter(String parameter, String value) {
        String section = Strings2.substringBeforeFirst(parameter, '.');
        String property = Strings2.substringAfterFirst(parameter, '.');
        if (section == null) {
            throw new IllegalArgumentException("no key found in '" + parameter + "'");
        }
        if (property == null) {
            throw new IllegalArgumentException("no property found in '" + parameter + "'");
        }
        this.setRuntimeParameter(section, property, value);
    }

    public void setRuntimeParameter(String section, String name, String value) {
        RuntimeProperty runtimeProperty = this.runtimeProperties.get(section);
        if (runtimeProperty == null) {
            runtimeProperty = new RuntimeProperty(section);
            this.runtimeProperties.put(section, runtimeProperty);
        }
        runtimeProperty.setProperty(name, value);
    }

    public static class Builder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Metadata fromFile(File metadataFile) throws IOException {
            try (FileInputStream metadataInputStream = new FileInputStream(metadataFile);){
                Metadata metadata = Builder.fromStream(metadataInputStream);
                return metadata;
            }
        }

        public static Metadata fromFile(@Nonnull Path metadataFile) throws IOException {
            if (!Files.exists(metadataFile, new LinkOption[0])) {
                throw new IllegalArgumentException("Given metadata.json file does not exist: " + metadataFile);
            }
            return Builder.fromStream(Files.newInputStream(metadataFile, new OpenOption[0]));
        }

        public static Metadata fromStream(InputStream metadataInputStream) throws IOException {
            ObjectMapper metadataObjectMapper = new ObjectMapper();
            JsonNode metadataRootNode = metadataObjectMapper.readTree(metadataInputStream);
            return Builder.fromJson(metadataRootNode);
        }

        public static Metadata fromJson(JsonNode metadataRootNode) throws IOException {
            Builder metadataBuilder = new Builder();
            return metadataBuilder.buildResources(metadataRootNode);
        }

        public static Metadata fromJsonString(String metadata, boolean allowSingleQuotes) throws IOException {
            ObjectMapper metadataObjectMapper = new ObjectMapper();
            metadataObjectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            JsonNode metadataRootNode = metadataObjectMapper.readTree(metadata);
            return Builder.fromJson(metadataRootNode);
        }

        private Metadata buildResources(JsonNode metadataRootNode) {
            TreeMap<String, Resource> resources = new TreeMap<String, Resource>();
            TreeMap<String, String> environment = new TreeMap<String, String>();
            TreeMap<String, RuntimeProperty> runtimeProperties = new TreeMap<String, RuntimeProperty>();
            Iterator fields = metadataRootNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                JsonNode content = (JsonNode)entry.getValue();
                String id = (String)entry.getKey();
                HashMap<String, String> entryMetadata = new HashMap<String, String>();
                Iterator properties = content.fields();
                while (properties.hasNext()) {
                    Map.Entry property = (Map.Entry)properties.next();
                    String entryName = (String)property.getKey();
                    JsonNode entryValueNode = (JsonNode)property.getValue();
                    if (entryValueNode.isTextual() || entryValueNode.isInt()) {
                        String entryValue = entryValueNode.asText();
                        entryMetadata.put(entryName, entryValue);
                    }
                    if (!id.equals("app") || !entryName.equals("env")) continue;
                    Iterator envVariables = entryValueNode.fields();
                    while (envVariables.hasNext()) {
                        Map.Entry envVariable = (Map.Entry)envVariables.next();
                        String envName = (String)envVariable.getKey();
                        JsonNode envValue = (JsonNode)envVariable.getValue();
                        if (!envValue.isTextual()) continue;
                        environment.put(envName, envValue.asText());
                    }
                }
                Resource resource = Resource.Builder.buildResource(entryMetadata);
                if (resource != null) {
                    resources.put(resource.getName(), resource);
                    continue;
                }
                if (id.equals("app")) continue;
                runtimeProperties.put(id, new RuntimeProperty(id, entryMetadata));
            }
            return new Metadata(resources, environment, runtimeProperties);
        }
    }
}

