/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import com.cloudbees.clickstack.util.Strings2;
import com.cloudbees.clickstack.util.exception.RuntimeIOException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files2 {
    static final Set<PosixFilePermission> PERMISSION_R = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r-----"));
    static final Set<PosixFilePermission> PERMISSION_RX = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
    static final Set<PosixFilePermission> PERMISSION_RW = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
    static final Set<PosixFilePermission> PERMISSION_RWX = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxrwx---"));
    static final Set<PosixFilePermission> PERMISSION_750 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
    static final Set<PosixFilePermission> PERMISSION_770 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxrwx---"));
    static final Set<PosixFilePermission> PERMISSION_640 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r-----"));
    private static final Logger logger = LoggerFactory.getLogger(Files2.class);

    public static void deleteDirectory(@Nonnull Path dir) throws RuntimeIOException {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    logger.trace("Delete file: {} ...", (Object)file);
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        logger.trace("Delete dir: {} ...", (Object)dir);
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception deleting '" + dir + "'", e);
        }
    }

    public static void chmodReadOnly(@Nonnull Path path) throws RuntimeIOException {
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("no dir expected here");
                }
                Files.setPosixFilePermissions(file, PERMISSION_R);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.setPosixFilePermissions(dir, PERMISSION_RX);
                return super.preVisitDirectory(dir, attrs);
            }
        };
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception changing permissions to readonly for " + path, e);
        }
    }

    public static void chmodSetReadOnly(@Nonnull Path path) throws RuntimeIOException {
        Files2.chmodOverwritePermissions(path, PERMISSION_R, PERMISSION_RX);
    }

    public static void chmodAddReadExecute(@Nonnull Path path) throws RuntimeIOException {
        Files2.chmodAddPermissions(path, PERMISSION_RX, PERMISSION_RX);
    }

    public static void chmodAddReadWrite(@Nonnull Path path) throws RuntimeIOException {
        Files2.chmodAddPermissions(path, PERMISSION_RW, PERMISSION_RWX);
    }

    @Deprecated
    public static void chmodReadExecute(Path path) throws RuntimeIOException {
        Files2.chmodAddReadExecute(path);
    }

    @Deprecated
    public static void chmodReadWrite(Path path) throws RuntimeIOException {
        Files2.chmodAddReadWrite(path);
    }

    private static FileSystem createZipFileSystem(Path zipFile, boolean create) throws IOException {
        URI uri = URI.create("jar:file:" + zipFile.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void unzip(String zipFilename, String destDirname) throws RuntimeIOException {
        Path zipFile = Paths.get(zipFilename, new String[0]);
        Path destDir = Paths.get(destDirname, new String[0]);
        Files2.unzip(zipFile, destDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path unzipSubFileIfExists(@Nonnull Path zipFile, @Nonnull String zipSubPath, @Nonnull Path destDir) throws RuntimeIOException {
        try {
            if (Files.notExists(destDir, new LinkOption[0])) {
                logger.trace("Create dir: {}", (Object)destDir);
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            try (FileSystem zipFileSystem = Files2.createZipFileSystem(zipFile, false);){
                Path root = zipFileSystem.getPath("/", new String[0]);
                Path subFile = root.resolve(zipSubPath);
                if (Files.exists(subFile, new LinkOption[0])) {
                    Path destFile = Strings2.beginWith(zipSubPath, "/") ? destDir.resolve("." + zipSubPath) : destDir.resolve(zipSubPath);
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                    Path path = Files.copy(subFile, destFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    return path;
                }
                Path path = null;
                return path;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception expanding " + zipFile + ":" + zipSubPath + " to " + destDir, e);
        }
    }

    public static void unzipSubDirectoryIfExists(@Nonnull Path zipFile, @Nonnull String zipSubPath, final @Nonnull Path destDir) throws RuntimeIOException {
        try {
            if (Files.notExists(destDir, new LinkOption[0])) {
                logger.trace("Create dir: {}", (Object)destDir);
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            try (FileSystem zipFileSystem = Files2.createZipFileSystem(zipFile, false);){
                final Path root = zipFileSystem.getPath(zipSubPath, new String[0]);
                if (Files.notExists(root, new LinkOption[0])) {
                    logger.trace("Zip sub path {} does not exist in {}", (Object)zipSubPath, (Object)zipFile);
                    return;
                }
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(destDir.toString(), root.relativize(file).toString());
                        logger.trace("Extract file {} to {} as {}", new Object[]{file, destDir, destFile});
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        dir.relativize(root).toString();
                        Path dirToCreate = Paths.get(destDir.toString(), root.relativize(dir).toString());
                        if (Files.notExists(dirToCreate, new LinkOption[0])) {
                            logger.trace("Create dir {}", (Object)dirToCreate);
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception expanding " + zipFile + ":" + zipSubPath + " to " + destDir, e);
        }
    }

    public static void unzip(@Nonnull Path zipFile, final @Nonnull Path destDir) throws RuntimeIOException {
        try {
            if (Files.notExists(destDir, new LinkOption[0])) {
                logger.trace("Create dir: {}", (Object)destDir);
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            try (FileSystem zipFileSystem = Files2.createZipFileSystem(zipFile, false);){
                Path root = zipFileSystem.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(destDir.toString(), file.toString());
                        logger.trace("Extract file {} to {}", (Object)file, (Object)destDir);
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                        if (Files.notExists(dirToCreate, new LinkOption[0])) {
                            logger.trace("Create dir {}", (Object)dirToCreate);
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception expanding " + zipFile + " to " + destDir, e);
        }
    }

    public static void untgz(String tgzFilename, String destDirname) throws RuntimeIOException {
        Path tgzFile = Paths.get(tgzFilename, new String[0]);
        Path destDir = Paths.get(destDirname, new String[0]);
        Files2.untgz(tgzFile, destDir);
    }

    public static void untgz(@Nonnull Path tgzFile, @Nonnull Path destDir) throws RuntimeIOException {
        try {
            TarArchiveEntry entry;
            if (Files.notExists(destDir, new LinkOption[0])) {
                logger.trace("Create dir: {}", (Object)destDir);
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(tgzFile, new OpenOption[0])));
            while ((entry = in.getNextTarEntry()) != null) {
                if (entry.isDirectory()) {
                    Path dir = destDir.resolve(entry.getName());
                    logger.trace("Create dir {}", (Object)dir);
                    Files.createDirectories(dir, new FileAttribute[0]);
                    continue;
                }
                Path file = destDir.resolve(entry.getName());
                logger.trace("Create file {}: {} bytes", (Object)file, (Object)entry.getSize());
                OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.close();
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception expanding " + tgzFile + " to " + destDir, e);
        }
    }

    public static void dump(@Nonnull Path path) throws RuntimeIOException {
        System.err.println("## DUMP FOLDER TREE ##");
        Files2.dump(path, 0);
    }

    private static void dump(@Nonnull Path path, int depth) throws RuntimeIOException {
        try {
            String icon = Files.isDirectory(path, new LinkOption[0]) ? " + " : " |- ";
            System.out.println(Strings.repeat((String)" ", (int)(++depth)) + icon + path.getFileName() + "\t" + PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
            if (Files.isDirectory(path, new LinkOption[0])) {
                DirectoryStream<Path> children = Files.newDirectoryStream(path);
                for (Path child : children) {
                    Files2.dump(child, depth);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception dumping " + path, e);
        }
    }

    public static void copyDirectoryContent(final @Nonnull Path srcDir, final @Nonnull Path destDir) throws RuntimeIOException {
        logger.trace("Copy from {} to {}", (Object)srcDir, (Object)destDir);
        SimpleFileVisitor<Path> copyDirVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = destDir.resolve(srcDir.relativize(dir));
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destDir.resolve(srcDir.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(srcDir, (FileVisitor<? super Path>)copyDirVisitor);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception copying content of dir " + srcDir + " to " + destDir, e);
        }
    }

    @Nonnull
    public static Path copyToDirectory(@Nonnull Path srcFile, @Nonnull Path destDir) throws RuntimeIOException {
        Preconditions.checkArgument((boolean)Files.exists(srcFile, new LinkOption[0]), (Object)"Src %s not found");
        Preconditions.checkArgument((!Files.isDirectory(srcFile, new LinkOption[0]) ? 1 : 0) != 0, (Object)"Src %s is a directory");
        Preconditions.checkArgument((boolean)Files.exists(destDir, new LinkOption[0]), (Object)"Dest %s not found");
        Preconditions.checkArgument((boolean)Files.isDirectory(destDir, new LinkOption[0]), (Object)"Dest %s is not a directory");
        try {
            return Files.copy(srcFile, destDir.resolve(srcFile.getFileName()), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception copying " + srcFile.getFileName() + " to " + srcFile, e);
        }
    }

    @Nonnull
    public static Path copyArtifactToDirectory(@Nonnull Path sourceDir, @Nonnull String artifactId, @Nonnull Path dest) throws RuntimeIOException {
        Path source = Files2.findArtifact(sourceDir, artifactId);
        try {
            return Files.copy(source, dest.resolve(source.getFileName()), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception copying " + source.getFileName() + " to " + sourceDir, e);
        }
    }

    @Nonnull
    public static Path findArtifact(@Nonnull Path srcDir, @Nonnull String artifactId) throws RuntimeIOException, IllegalStateException {
        return Files2.findArtifact(srcDir, artifactId, "jar");
    }

    @Deprecated
    @Nonnull
    public static Path findUniqueFolderBeginningWith(@Nonnull Path source, @Nullable String pattern) throws RuntimeIOException, IllegalStateException {
        return Files2.findUniqueDirectoryBeginningWith(source, pattern);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static Path findUniqueDirectoryBeginningWith(@Nonnull Path srcDir, final @Nonnull String pattern) throws RuntimeIOException, IllegalStateException {
        Preconditions.checkArgument((boolean)Files.isDirectory(srcDir, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{srcDir.toAbsolutePath()});
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String fileName = entry.getFileName().toString();
                if (pattern == null) {
                    return true;
                }
                return fileName.startsWith(pattern);
            }
        };
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(srcDir, (DirectoryStream.Filter<? super Path>)filter);){
                Path path = (Path)Iterables.getOnlyElement(paths);
                return path;
            }
            catch (NoSuchElementException e) {
                try {
                    throw new IllegalStateException("Directory beginning with '" + pattern + "' not found in path: " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath());
                    catch (IllegalArgumentException e2) {
                        throw new IllegalStateException("More than 1 directory beginning with '" + pattern + "' found in path: " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath() + " -> " + paths);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception finding unique child directory beginning with " + filter + "in " + srcDir);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static Path findUniqueChildDirectory(@Nonnull Path srcDir) throws RuntimeIOException, IllegalStateException {
        Preconditions.checkArgument((boolean)Files.isDirectory(srcDir, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{srcDir.toAbsolutePath()});
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(srcDir);){
                Path path = (Path)Iterables.getOnlyElement(paths);
                return path;
            }
            catch (NoSuchElementException e) {
                try {
                    throw new IllegalStateException("No child directory found in : " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath());
                    catch (IllegalArgumentException e2) {
                        throw new IllegalStateException("More than 1 child directory found in path: " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath() + " -> " + paths);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception finding unique child directory in " + srcDir);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static Path findArtifact(@Nonnull Path srcDir, final @Nonnull String artifactId, final @Nonnull String type) throws RuntimeIOException, IllegalStateException {
        Preconditions.checkArgument((boolean)Files.isDirectory(srcDir, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{srcDir.toAbsolutePath()});
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String fileName = entry.getFileName().toString();
                return fileName.startsWith(artifactId) && fileName.endsWith("." + type);
            }
        };
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(srcDir, (DirectoryStream.Filter<? super Path>)filter);){
                Path path = (Path)Iterables.getOnlyElement(paths);
                return path;
            }
            catch (NoSuchElementException e) {
                try {
                    throw new IllegalStateException("Artifact '" + artifactId + ":" + type + "' not found in path: " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath());
                    catch (IllegalArgumentException e2) {
                        throw new IllegalStateException("More than 1 version of artifact '" + artifactId + ":" + type + "' found in path: " + srcDir + ", absolutePath: " + srcDir.toAbsolutePath() + " -> " + paths);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception finding artifact " + artifactId + "@" + type + " in " + srcDir);
        }
    }

    private static void chmodOverwritePermissions(@Nonnull Path path, final @Nonnull Set<PosixFilePermission> filePermissions, final @Nonnull Set<PosixFilePermission> dirPermissions) throws RuntimeIOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Given path " + path + " does not exist");
        }
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("No dir expected here: " + file);
                }
                Files.setPosixFilePermissions(file, filePermissions);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.setPosixFilePermissions(dir, dirPermissions);
                return super.preVisitDirectory(dir, attrs);
            }
        };
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception setting permissions file permissions to " + filePermissions + " and folder permissions to " + dirPermissions + " on " + path, e);
        }
    }

    private static void chmodAddPermissions(@Nonnull Path path, final @Nonnull Set<PosixFilePermission> filePermissions, final @Nonnull Set<PosixFilePermission> dirPermissions) throws RuntimeIOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Given path " + path + " does not exist");
        }
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("No dir expected here: " + file);
                }
                Set<PosixFilePermission> existingPermissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
                Files.setPosixFilePermissions(file, (Set<PosixFilePermission>)Sets.union(existingPermissions, (Set)filePermissions));
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Set<PosixFilePermission> existingPermissions = Files.getPosixFilePermissions(dir, new LinkOption[0]);
                Files.setPosixFilePermissions(dir, (Set<PosixFilePermission>)Sets.union(existingPermissions, (Set)dirPermissions));
                return super.preVisitDirectory(dir, attrs);
            }
        };
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception setting permissions file permissions to " + filePermissions + " and folder permissions to " + dirPermissions + " on " + path, e);
        }
    }
}

