/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Database;
import com.cloudbees.clickstack.domain.metadata.Email;
import com.cloudbees.clickstack.domain.metadata.Papertrail;
import com.cloudbees.clickstack.domain.metadata.SessionStore;
import com.cloudbees.clickstack.domain.metadata.Syslog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Resource {
    public static final String NAME_DESCRIPTOR = "resource_name";
    public static final String TYPE_DESCRIPTOR = "resource_type";
    private Map<String, String> descriptors = new HashMap<String, String>();
    private Map<String, String> properties = new HashMap<String, String>();

    protected Resource(Map<String, String> properties, Map<String, String> descriptors) {
        if (!Resource.checkResource(properties, descriptors)) {
            throw new IllegalArgumentException("Incorrect resource definition.");
        }
        this.descriptors.putAll(descriptors);
        this.properties.putAll(properties);
    }

    private static boolean checkResource(Map<String, String> properties, Map<String, String> descriptors) {
        boolean isValid = descriptors != null;
        if (isValid) {
            isValid = descriptors.get(NAME_DESCRIPTOR) != null && descriptors.get(TYPE_DESCRIPTOR) != null;
            if (isValid = isValid && properties != null) {
                for (Map.Entry<String, String> property : properties.entrySet()) {
                    isValid = isValid && property.getKey() != null && property.getValue() != null;
                }
                for (Map.Entry<String, String> descriptor : descriptors.entrySet()) {
                    isValid = isValid && descriptor.getKey() != null && descriptor.getValue() != null;
                }
            }
        }
        return isValid;
    }

    public String getName() {
        return this.descriptors.get(NAME_DESCRIPTOR);
    }

    public String getType() {
        return this.descriptors.get(TYPE_DESCRIPTOR);
    }

    @Nullable
    public String getDescriptor(String descriptor) {
        return this.descriptors.get(descriptor);
    }

    @Nonnull
    public Map<String, String> getDescriptors() {
        return this.descriptors;
    }

    @Nullable
    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public String getProperty(String property, String defaultValue) {
        String value = this.properties.get(property);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> filterProperties(Collection<String> filter) {
        HashMap<String, String> filteredProperties = new HashMap<String, String>();
        for (String propertyName : filter) {
            if (!this.properties.containsKey(propertyName)) continue;
            filteredProperties.put(propertyName, this.properties.get(propertyName));
        }
        return filteredProperties;
    }

    public static class Builder {
        public static Resource buildResource(Map<String, String> metadata) {
            HashMap<String, String> properties = new HashMap<String, String>();
            HashMap<String, String> descriptors = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = entry.getValue();
                if (entryKey == null || entryValue == null) continue;
                if (entryKey.matches("^__.*__$")) {
                    entryKey = entryKey.substring(2, entryKey.length() - 2);
                    descriptors.put(entryKey, entryValue);
                    continue;
                }
                properties.put(entryKey, entryValue);
            }
            if (Resource.checkResource(properties, descriptors)) {
                Resource resource = new Resource(properties, descriptors);
                if (Database.TYPES.contains(resource.getType())) {
                    if (Database.checkResource(resource)) {
                        resource = new Database(resource);
                    }
                } else if (Email.TYPES.contains(resource.getType())) {
                    if (Email.checkResource(resource)) {
                        resource = new Email(resource);
                    }
                } else if (SessionStore.TYPES.contains(resource.getType())) {
                    if (SessionStore.checkResource(resource)) {
                        resource = new SessionStore(resource);
                    }
                } else if (Syslog.TYPES.contains(resource.getType())) {
                    resource = new Syslog(resource);
                } else if (Papertrail.TYPES.contains(resource.getType())) {
                    resource = new Papertrail(resource);
                }
                return resource;
            }
            return null;
        }
    }
}

