/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.integration.jul;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.integration.jul.AbstractHandler;
import com.cloudbees.syslog.integration.jul.SyslogMessageFormatter;
import com.cloudbees.syslog.integration.jul.util.LevelHelper;
import com.cloudbees.syslog.integration.jul.util.LogManagerHelper;
import com.cloudbees.syslog.sender.SyslogMessageSender;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SyslogHandler
extends AbstractHandler {
    private SyslogMessageSender syslogMessageSender;
    private String appName;
    private Facility facility = Facility.USER;
    private Severity severity = Severity.DEBUG;
    private String messageHostname;

    public SyslogHandler() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        UdpSyslogMessageSender udpSender = new UdpSyslogMessageSender();
        udpSender.setSyslogServerHostname(LogManagerHelper.getStringProperty(manager, cname + ".syslogServerHostname", "localhost"));
        udpSender.setSyslogServerPort(LogManagerHelper.getIntProperty(manager, cname + ".syslogServerPort", 514));
        this.appName = LogManagerHelper.getStringProperty(manager, cname + ".appName", this.appName);
        udpSender.setDefaultAppName(this.appName);
        this.facility = Facility.fromLabel(LogManagerHelper.getStringProperty(manager, cname + ".facility", this.facility.label()));
        udpSender.setDefaultFacility(this.facility);
        this.severity = Severity.fromLabel(LogManagerHelper.getStringProperty(manager, cname + ".severity", this.severity.label()));
        udpSender.setDefaultSeverity(this.severity);
        this.messageHostname = LogManagerHelper.getStringProperty(manager, cname + ".messageHostname", this.messageHostname);
        udpSender.setDefaultMessageHostname(this.messageHostname);
        this.syslogMessageSender = udpSender;
    }

    public SyslogHandler(@Nonnull SyslogMessageSender syslogMessageSender) {
        this(syslogMessageSender, Level.INFO, null);
    }

    public SyslogHandler(@Nonnull SyslogMessageSender syslogMessageSender, @Nonnull Level level, @Nullable Filter filter) {
        super(level, filter);
        this.syslogMessageSender = syslogMessageSender;
    }

    @Override
    @Nonnull
    protected Formatter getDefaultFormatter() {
        return new SyslogMessageFormatter();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        Severity severity = LevelHelper.toSeverity(record.getLevel());
        if (severity == null) {
            severity = this.severity;
        }
        SyslogMessage message = new SyslogMessage().withTimestamp(record.getMillis()).withSeverity(severity).withAppName(this.appName).withHostname(this.messageHostname).withFacility(this.facility).withMsg(msg);
        try {
            this.syslogMessageSender.sendMessage(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        if (this.syslogMessageSender instanceof Closeable) {
            try {
                ((Closeable)((Object)this.syslogMessageSender)).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getEncoding() {
        throw new IllegalStateException();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getMessageHostname() {
        return this.messageHostname;
    }

    public void setMessageHostname(String messageHostname) {
        this.messageHostname = messageHostname;
    }

    public SyslogMessageSender getSyslogMessageSender() {
        return this.syslogMessageSender;
    }

    public void setSyslogMessageSender(SyslogMessageSender syslogMessageSender) {
        this.syslogMessageSender = syslogMessageSender;
    }
}

