/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;

public class ConcurrentDateFormat {
    private final BlockingQueue<SimpleDateFormat> dateFormats;
    private final String pattern;
    private final Locale locale;
    private final TimeZone timeZone;

    public ConcurrentDateFormat(String pattern, Locale locale, TimeZone timeZone, int maxCacheSize) {
        this.dateFormats = new LinkedBlockingDeque<SimpleDateFormat>(maxCacheSize);
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public String format(@Nonnull Date date) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)this.dateFormats.poll();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(this.pattern, this.locale);
            dateFormat.setTimeZone(this.timeZone);
        }
        try {
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.dateFormats.offer(dateFormat);
        }
    }

    public String toString() {
        return "ConcurrentDateFormat[pattern=" + this.pattern + "]";
    }
}

