/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.TreeMap;

public class AwaitCodeRedirect
implements Command {
    public static final String COMMAND_ID = "awaitCodeRedirect";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        String[] queryPairs;
        RedirectReceiver rr;
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof String || parameters[1] instanceof VarAddress));
        VarAddress returnParameter = (VarAddress)parameters[0];
        ArrayList<String> keys = new ArrayList<String>();
        boolean legacy = parameters.length == 2;
        String url = parameters[1] instanceof VarAddress ? (String)environment.getVariable((VarAddress)parameters[1]) : (String)parameters[1];
        for (int i = 2; i < parameters.length; ++i) {
            if (parameters[i] instanceof VarAddress) {
                keys.add((String)environment.getVariable((VarAddress)parameters[i]));
                continue;
            }
            keys.add((String)parameters[i]);
        }
        if (legacy) {
            keys.add("code");
        }
        if ((rr = (RedirectReceiver)environment.getFromInstanceDependencyStorage("redirectReceiver")) == null) {
            throw new Exception("This service needs the RedirectReceiver to not be null");
        }
        String redirectUrl = rr.openAndAwait(url, environment.saveStateToString());
        String query = new URL(redirectUrl).getQuery();
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        for (String pair : queryPairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryMap.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        if (legacy) {
            environment.setVariable(returnParameter, queryMap.get("code"));
        } else {
            environment.setVariable(returnParameter, queryMap);
        }
    }
}

