/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.List;
import java.util.Map;

public class Push
implements Command {
    public static final String COMMAND_ID = "push";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress targetID = (VarAddress)parameters[0];
        Object source = parameters[1];
        Object value = null;
        value = source instanceof VarAddress ? environment.getVariable((VarAddress)source) : source;
        List<Object> targetIDParts = environment.decodeVariableAddress(targetID);
        for (int i = 2; i < parameters.length; ++i) {
            if (parameters[i] instanceof VarAddress) {
                targetIDParts.add(environment.getVariable((VarAddress)parameters[i]));
                continue;
            }
            targetIDParts.add(parameters[i]);
        }
        Object container = environment.getVariable(targetIDParts);
        if (container instanceof List) {
            ((List)container).add(value);
        } else if (container instanceof Map) {
            ((Map)container).put(String.valueOf(((Map)container).size()), value);
        } else if (container instanceof String) {
            String ch = value instanceof String ? (String)value : value.toString();
            container = ((String)container).concat(ch);
            environment.setVariable(targetIDParts, container);
        } else {
            throw new IllegalArgumentException("Push to 'container' type: " + container.getClass().getName() + " is not supported!");
        }
    }
}

