/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.http;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.types.ConnectError;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCall
implements Command {
    public static final String COMMAND_ID = "http.requestCall";
    private static final String USER_AGENT = "CloudRailSI";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String REQUEST_HEADERS = "requestHeaders";
    private static final String REQUEST_BODY = "requestBody";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String RESPONSE_HEADERS = "responseHeaders";
    private static final String RESPONSE_BODY = "responseBody";
    private static SSLContext sslContext = null;

    public static synchronized SSLSocketFactory getSocketFactory() throws Exception {
        if (sslContext == null) {
            try {
                char[] keyStorePasswd = "x3qsvbHxyg2JpazE3KGRJxnQhaMhnHtN".toCharArray();
                String keyStoreResourceName = "/com/cloudrail/si/servicecode/commands/http/ca-bundle.jks";
                sslContext = SSLContext.getInstance("TLSv1.2");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                InputStream keyStoreInputStream = RequestCall.class.getResourceAsStream("/com/cloudrail/si/servicecode/commands/http/ca-bundle.jks");
                keyStore.load(keyStoreInputStream, keyStorePasswd);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(keyStore);
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            }
            catch (Exception e) {
                throw new Exception("CloudRail SI failed to initialize the SSL context for authorization HTTPS requests");
            }
        }
        return sslContext.getSocketFactory();
    }

    @Override
    public String getID() {
        return COMMAND_ID;
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && parameters[1] instanceof VarAddress);
        VarAddress targetVar = (VarAddress)parameters[0];
        VarAddress optionsVar = (VarAddress)parameters[1];
        Map options = (Map)environment.getVariable(optionsVar);
        String url = (String)options.get(URL);
        String method = (String)options.get(METHOD);
        Map headers = (Map)options.get(REQUEST_HEADERS);
        InputStream body = (InputStream)options.get(REQUEST_BODY);
        URL u = new URL(url);
        String protocol = u.getProtocol();
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            InputStream responseStream;
            HttpURLConnection connection;
            if (protocol.equals("http")) {
                connection = (HttpURLConnection)u.openConnection();
            } else if (protocol.equals("https")) {
                connection = (HttpsURLConnection)u.openConnection();
                ((HttpsURLConnection)connection).setSSLSocketFactory(RequestCall.getSocketFactory());
            } else {
                throw new Exception("Unknown protocol");
            }
            connection.setRequestMethod(method);
            connection.setRequestProperty("User-Agent", USER_AGENT);
            if (method.equals("POST") && (headers == null || !headers.containsKey("Content-Type"))) {
                connection.setRequestProperty("Content-Type", "");
            }
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    connection.addRequestProperty((String)e.getKey(), (String)e.getValue());
                }
            }
            if (body != null) {
                int len;
                if (headers == null || !headers.containsKey("Content-Length")) {
                    connection.setChunkedStreamingMode(0);
                } else {
                    int length = Integer.parseInt((String)headers.get("Content-Length"));
                    connection.setFixedLengthStreamingMode(length);
                }
                if (!(body instanceof BufferedInputStream)) {
                    body = new BufferedInputStream(body);
                }
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                byte[] buffer = new byte[65536];
                while ((len = body.read(buffer, 0, buffer.length)) != -1) {
                    os.write(buffer, 0, len);
                }
                body.close();
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                responseHeaders.put(entry.getKey(), this.join(entry.getValue(), ", "));
            }
            try {
                responseStream = new BufferedInputStream(connection.getInputStream());
            }
            catch (IOException e) {
                responseStream = connection.getErrorStream();
            }
            response.put(CODE, connection.getResponseCode());
            response.put(MESSAGE, connection.getResponseMessage());
            response.put(RESPONSE_BODY, responseStream);
            response.put(RESPONSE_HEADERS, responseHeaders);
        }
        catch (ConnectException e) {
            ConnectError errorObj = new ConnectError(e.getMessage());
            environment.setThrownError(errorObj);
        }
        catch (SSLHandshakeException e) {
            ConnectError errorObj = new ConnectError(e.getMessage());
            environment.setThrownError(errorObj);
        }
        environment.setVariable(targetVar, response);
    }

    private String join(List<String> list, String separator) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(s);
            first = false;
        }
        return builder.toString();
    }
}

