/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.math;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Max
implements Command {
    public static final String COMMAND_ID = "math.max";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        boolean isDouble = false;
        double doubleResult = 0.0;
        long longResult = 0L;
        for (int i = 1; i < parameters.length; ++i) {
            if (parameters[i] instanceof VarAddress) {
                parameters[i] = environment.getVariable((VarAddress)parameters[i]);
            }
            if (!(parameters[i] instanceof Number)) {
                throw new IllegalArgumentException("command: math.max argument #" + i + " is not from type number!");
            }
            boolean bl = isDouble = isDouble || parameters[i] instanceof Double || parameters[i] instanceof Float;
            if (i <= 1) {
                if (isDouble) {
                    doubleResult = ((Number)parameters[i]).doubleValue();
                    continue;
                }
                longResult = ((Number)parameters[i]).longValue();
                doubleResult = longResult;
                continue;
            }
            if (isDouble) {
                doubleResult = Math.max(doubleResult, ((Number)parameters[i]).doubleValue());
                continue;
            }
            longResult = Math.max(longResult, ((Number)parameters[i]).longValue());
            doubleResult = longResult;
        }
        if (isDouble) {
            environment.setVariable(resultVar, (Object)doubleResult);
        } else {
            environment.setVariable(resultVar, (Object)longResult);
        }
    }
}

