/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Base64Encode
implements Command {
    public static final String COMMAND_ID = "string.base64encode";
    private static final String base64charsDefault = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String base64charsWebSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Number lbFlag;
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object sourceStringObj = parameters[1];
        boolean lineBreak = false;
        boolean webSafe = false;
        if (sourceStringObj instanceof VarAddress) {
            sourceStringObj = environment.getVariable((VarAddress)sourceStringObj);
        }
        if (parameters.length >= 3) {
            lbFlag = parameters[2] instanceof VarAddress ? (Number)((Number)environment.getVariable((VarAddress)parameters[2])) : (Number)((Number)parameters[2]);
            boolean bl = lineBreak = lbFlag.intValue() != 0;
        }
        if (parameters.length >= 4) {
            lbFlag = parameters[3] instanceof VarAddress ? (Number)((Number)environment.getVariable((VarAddress)parameters[3])) : (Number)((Number)parameters[3]);
            boolean bl = webSafe = lbFlag.intValue() != 0;
        }
        if (!(sourceStringObj instanceof String)) {
            throw new IllegalArgumentException("command: string.base64encode parameter sourceString is not from type String!");
        }
        String sourceString = (String)sourceStringObj;
        String resultString = Base64Encode.encode(sourceString, lineBreak, webSafe);
        environment.setVariable(resultVar, (Object)resultString);
    }

    public static String encode(String s, boolean lineBreak, boolean webSafe) {
        String base64chars = webSafe ? base64charsWebSafe : base64charsDefault;
        String r = "";
        String p = "";
        int c = s.length() % 3;
        if (c > 0) {
            while (c < 3) {
                p = p + "=";
                s = s + "\u0000";
                ++c;
            }
        }
        for (c = 0; c < s.length(); c += 3) {
            if (lineBreak && c > 0 && c / 3 * 4 % 76 == 0) {
                r = r + "\r\n";
            }
            int n = (s.charAt(c) << 16) + (s.charAt(c + 1) << 8) + s.charAt(c + 2);
            int n1 = n >> 18 & 0x3F;
            int n2 = n >> 12 & 0x3F;
            int n3 = n >> 6 & 0x3F;
            int n4 = n & 0x3F;
            r = r + "" + base64chars.charAt(n1) + base64chars.charAt(n2) + base64chars.charAt(n3) + base64chars.charAt(n4);
        }
        return r.substring(0, r.length() - p.length()) + p;
    }
}

