/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class IndexOf
implements Command {
    public static final String COMMAND_ID = "string.indexOf";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters.length <= 4 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        for (int i = 1; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        if (!(parameters[1] instanceof String)) {
            throw new IllegalArgumentException("command: string.indexOf parameter sourceString is not from type String!");
        }
        String sourceString = (String)parameters[1];
        Object findObj = parameters[2];
        int fromIdx = 0;
        if (parameters.length >= 4) {
            if (!(parameters[3] instanceof Number)) {
                throw new IllegalArgumentException("command: string.indexOf parameter length is not from type Number!");
            }
            fromIdx = ((Number)parameters[3]).intValue();
            if (fromIdx > sourceString.length()) {
                throw new IllegalArgumentException("command: string.indexOf parameter startIdx > sourceString_length!");
            }
        }
        Long idx = -1L;
        if (findObj instanceof Number) {
            idx = sourceString.indexOf(((Number)findObj).intValue(), fromIdx);
        } else if (findObj instanceof String) {
            idx = sourceString.indexOf((String)findObj, fromIdx);
        } else {
            throw new IllegalArgumentException("command: string.indexOf parameter find is not a String or a Number (Char)!");
        }
        environment.setVariable(resultVar, (Object)idx);
    }
}

