/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;

public class Substr
implements Command {
    public static final String COMMAND_ID = "string.substr";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters.length <= 4 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        for (int i = 1; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        if (!(parameters[1] instanceof String)) {
            throw new IllegalArgumentException("command: string.substr parameter sourceString is not from type String!");
        }
        if (!(parameters[2] instanceof Number)) {
            throw new IllegalArgumentException("command: string.substr parameter startIdx is not from type Number!");
        }
        String sourceString = (String)parameters[1];
        int startIdx = ((Number)parameters[2]).intValue();
        int length = sourceString.length() - startIdx;
        if (parameters.length >= 4) {
            if (!(parameters[3] instanceof Number)) {
                throw new IllegalArgumentException("command: string.substr parameter length is not from type Number!");
            }
            length = ((Number)parameters[3]).intValue();
            if (length + startIdx > sourceString.length()) {
                throw new IllegalArgumentException("command: string.substr parameter length > sourceString_length!");
            }
        }
        String substr = sourceString.substring(startIdx, startIdx + length);
        environment.setVariable(resultVar, (Object)substr);
    }
}

