/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.CloudStorage;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.CloudMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.SpaceAllocation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dropbox
implements CloudStorage {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("CloudStorage:getUserLogin", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.emailAddress"}});
            this.put("CloudStorage:getUserName", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.displayName"}});
            this.put("User:about", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -1000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:aboutRequest", "$P0"}});
            this.put("User:aboutRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://api.dropboxapi.com/2/users/get_current_account"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L4.Time"}, new Object[]{"set", "$P0.userInfo.emailAddress", "$L3.email"}, new Object[]{"set", "$P0.userInfo.displayName", "$L3.name.display_name"}});
            this.put("CloudStorage:download", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/download"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"json.stringify", "$L4", "$L3"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"set", "$P1", "$L5.responseBody"}});
            this.put("CloudStorage:upload", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkPositive", "$P0", "$P3"}, new Object[]{"if==than", "$P4", 0, 1}, new Object[]{"callFunc", "checkFileExists", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"if<=than", "$P3", 10000000, 2}, new Object[]{"callFunc", "simpleUpload", "$P0", "$P2", "$P1", "$P4"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "chunkedUpload", "$P0", "$P2", "$P1", "$P3", "$P4"}});
            this.put("CloudStorage:move", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.from_path", "$P1"}, new Object[]{"set", "$L0.to_path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/move"}});
            this.put("CloudStorage:delete", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P1"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/delete"}});
            this.put("CloudStorage:copy", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.from_path", "$P1"}, new Object[]{"set", "$L0.to_path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/copy"}});
            this.put("CloudStorage:createFolder", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P1"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/create_folder"}});
            this.put("CloudStorage:getMetadata", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Root does not have MetaData", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"callFunc", "makeMeta", "$P0", "$P1", "$L1"}});
            this.put("CloudStorage:getChildren", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 1}, new Object[]{"set", "$P2", ""}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/files/list_folder"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P1", "$L1"}, new Object[]{"if==than", "$L1.has_more", 1, 5}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.cursor", "$L1.cursor"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L2", "https://api.dropboxapi.com/2/files/list_folder/continue"}, new Object[]{"callFunc", "processRawMeta", "$P0", "$P1", "$L1"}, new Object[]{"jumpRel", -6}});
            this.put("CloudStorage:exists", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"set", "$P1", 1}, new Object[]{"return"}, new Object[]{"if<than", "$L4.code", 429, 5}, new Object[]{"json.parse", "$L0", "$L4.responseBody"}, new Object[]{"string.indexOf", "$L1", "$L0.error_summary", "not_found"}, new Object[]{"if!=than", "$L4", -1, 2}, new Object[]{"set", "$P1", 0}, new Object[]{"return"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if==than", "$S0.access_token", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://api.dropboxapi.com/2/auth/token/revoke"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$S0.access_token", null}});
            this.put("getAllocation", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"create", "$L1", "String"}, new Object[]{"set", "$L1", "https://api.dropboxapi.com/2/users/get_space_usage"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L4"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"create", "$L6", "SpaceAllocation"}, new Object[]{"set", "$L6.total", "$L5.allocation.allocated"}, new Object[]{"set", "$L6.used", "$L5.used"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("createShareLink", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Cannot share root", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "checkParentPathExists", "$P0", "$P2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.path", "$P2"}, new Object[]{"callFunc", "standardJSONRequest", "$P0", "$L1", "$L0", "https://api.dropboxapi.com/2/sharing/create_shared_link_with_settings"}, new Object[]{"set", "$P1", "$L1.url"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", null, "$S0.access_token", 1}, new Object[]{"return"}, new Object[]{"string.concat", "$L0", "https://www.dropbox.com/oauth2/authorize?response_type=code&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/oauth2/token"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L2.requestHeaders", "$L7"}, new Object[]{"string.concat", "$L3", "code=", "$L1", "&grant_type=authorization_code", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L2.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$S0.access_token", "$L6.access_token"}});
            this.put("standardJSONRequest", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "$P3"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/json"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"json.stringify", "$L3", "$P2"}, new Object[]{"stream.stringToStream", "$L4", "$L3"}, new Object[]{"set", "$L0.requestBody", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("makeMeta", new Object[]{new Object[]{"create", "$P1", "CloudMetaData"}, new Object[]{"set", "$P1.name", "$P2.name"}, new Object[]{"if!=than", "$P2.server_modified", null, 2}, new Object[]{"create", "$L1", "Date", "$P2.server_modified"}, new Object[]{"set", "$P1.modifiedAt", "$L1.time"}, new Object[]{"get", "$L0", "$P2", ".tag"}, new Object[]{"if==than", "$L0", "folder", 2}, new Object[]{"set", "$P1.folder", 1}, new Object[]{"jumpRel", 2}, new Object[]{"set", "$P1.folder", 0}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"set", "$P1.path", "$P2.path_display"}});
            this.put("processRawMeta", new Object[]{new Object[]{"set", "$L0", "$P2.entries"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"math.add", "$L2", "$L1", -1}, new Object[]{"if>=than", "$L2", 0, 5}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"callFunc", "makeMeta", "$P0", "$L4", "$L3"}, new Object[]{"push", "$P1", "$L4"}, new Object[]{"math.add", "$L2", "$L2", -1}, new Object[]{"jumpRel", -6}});
            this.put("simpleUpload", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P2"}, new Object[]{"if!=than", "$P3", 0, 1}, new Object[]{"set", "$L3.mode", "overwrite"}, new Object[]{"json.stringify", "$L4", "$L3"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("chunkedUpload", new Object[]{new Object[]{"stream.makeLimitedStream", "$L0", "$P1", 10000000}, new Object[]{"callFunc", "chunkedStart", "$P0", "$L1", "$L0"}, new Object[]{"math.add", "$L2", "$P3", -10000000}, new Object[]{"set", "$L5", 10000000}, new Object[]{"if>than", "$L2", 10000000, 7}, new Object[]{"stream.makeLimitedStream", "$L3", "$P1", 10000000}, new Object[]{"callFunc", "chunkedAppend", "$P0", "$L3", "$L1", "$L5"}, new Object[]{"math.add", "$L4", "$L2", -10000000}, new Object[]{"set", "$L2", "$L4"}, new Object[]{"math.add", "$L6", "$L5", 10000000}, new Object[]{"set", "$L5", "$L6"}, new Object[]{"jumpRel", -8}, new Object[]{"callFunc", "chunkedFinish", "$P0", "$P1", "$P2", "$L1", "$L5", "$P4"}});
            this.put("chunkedStart", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/start"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P2"}, new Object[]{"http.requestCall", "$L3", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"set", "$P1", "$L4.session_id"}});
            this.put("chunkedAppend", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/append_v2"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.session_id", "$P2"}, new Object[]{"set", "$L3.offset", "$P3"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.cursor", "$L3"}, new Object[]{"json.stringify", "$L4", "$L7"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("chunkedFinish", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://content.dropboxapi.com/2/files/upload_session/finish"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L2", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.Authorization", "$L2"}, new Object[]{"set", "$L1.Content-Type", "application/octet-stream"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.session_id", "$P3"}, new Object[]{"set", "$L3.offset", "$P4"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"if!=than", "$P5", 0, 1}, new Object[]{"set", "$L8.mode", "overwrite"}, new Object[]{"set", "$L8.path", "$P2"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.cursor", "$L3"}, new Object[]{"set", "$L7.commit", "$L8"}, new Object[]{"json.stringify", "$L4", "$L7"}, new Object[]{"set", "$L1.Dropbox-API-Arg", "$L4"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"set", "$L0.requestBody", "$P1"}, new Object[]{"http.requestCall", "$L5", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L5"}});
            this.put("validatePath", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Path shouldn't be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.substr", "$L0", "$P1", 0, 1}, new Object[]{"if!=than", "$L0", "/", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L1", "Number"}, new Object[]{"size", "$L1", "$P1"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L1", 0, 5}, new Object[]{"create", "$L2", "String"}, new Object[]{"string.substr", "$L2", "$P1", "$L1", 1}, new Object[]{"if==than", "$L2", "/", 2}, new Object[]{"create", "$L3", "Error", "Path should not end with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Passed argument is null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkPositive", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Passed argument should be bigger than 0.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 27}, new Object[]{"if==than", "$P1.code", 400, 3}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 401, 3}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 500, 6}, new Object[]{"stream.streamToString", "$L2", "$P1.responseBody"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.error_summary"}, new Object[]{"string.indexOf", "$L4", "$L0.error_summary", "not_found"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if==than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$L4", -1, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("checkParentPathExists", new Object[]{new Object[]{"string.lastIndexOf", "$L0", "$P1", "/"}, new Object[]{"string.substring", "$L1", "$P1", 0, "$L0"}, new Object[]{"if==than", "$L1", "", 1}, new Object[]{"return"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$L1"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if!=than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "Target folder not found.", "NotFound"}, new Object[]{"throwError", "$L5"}});
            this.put("checkFileExists", new Object[]{new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://api.dropboxapi.com/2/files/get_metadata"}, new Object[]{"set", "$L2.method", "POST"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L2.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.path", "$P1"}, new Object[]{"json.stringify", "$L3", "$L3"}, new Object[]{"stream.stringToStream", "$L2.requestBody", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L2"}, new Object[]{"if==than", "$L4.code", 200, 2}, new Object[]{"create", "$L5", "Error", "File already exists.", "Http"}, new Object[]{"throwError", "$L5"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Dropbox(RedirectReceiver redirectReceiver, String clientId, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("Dropbox");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public InputStream download(String filePath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "download");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:download", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "download");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void upload(String filePath, InputStream stream, long size, boolean overwrite) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "upload");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:upload", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "upload");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void move(String sourcePath, String destinationPath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "move");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:move", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "move");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void delete(String filePath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "delete");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:delete", this.interpreterStorage, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "delete");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void copy(String sourcePath, String destinationPath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "copy");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:copy", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "copy");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void createFolder(String folderPath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "createFolder");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createFolder", this.interpreterStorage, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "createFolder");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public CloudMetaData getMetadata(String filePath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "getMetadata");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getMetadata", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "getMetadata");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (CloudMetaData)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildren(String folderPath) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "getChildren");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildren", this.interpreterStorage, null, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "getChildren");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String getUserLogin() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "getUserLogin");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserLogin", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "getUserLogin");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getUserName() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "getUserName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "getUserName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String createShareLink(String path) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "createShareLink");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createShareLink", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "createShareLink");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public SpaceAllocation getAllocation() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "getAllocation");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getAllocation", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "getAllocation");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SpaceAllocation)ip.getParameter(1);
    }

    @Override
    public boolean exists(String path) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "exists");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:exists", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "exists");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return !ip.getParameter(1).equals(0);
    }

    @Override
    public void login() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "login");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "login");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Dropbox", "logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Dropbox", "logout");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    @Override
    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

