/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.PointsOfInterest;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.POI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GooglePlaces
implements PointsOfInterest {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"create", "$P0.crToPlaces", "Object"}, new Object[]{"create", "$P0.placesToCr", "Object"}, new Object[]{"callFunc", "addCategory", "$P0", "airport", "airport"}, new Object[]{"callFunc", "addCategory", "$P0", "amusement_park", "amusement_park"}, new Object[]{"callFunc", "addCategory", "$P0", "aquarium", "aquarium"}, new Object[]{"callFunc", "addCategory", "$P0", "art_gallery", "art_gallery"}, new Object[]{"callFunc", "addCategory", "$P0", "bakery", "bakery"}, new Object[]{"callFunc", "addCategory", "$P0", "bank", "bank"}, new Object[]{"callFunc", "addCategory", "$P0", "bar", "bar"}, new Object[]{"callFunc", "addCategory", "$P0", "beauty_salon", "beauty_salon"}, new Object[]{"callFunc", "addCategory", "$P0", "bicycle_store", "bicycle_store"}, new Object[]{"callFunc", "addCategory", "$P0", "book_store", "book_store"}, new Object[]{"callFunc", "addCategory", "$P0", "bowling_alley", "bowling_alley"}, new Object[]{"callFunc", "addCategory", "$P0", "bus_station", "bus_station"}, new Object[]{"callFunc", "addCategory", "$P0", "cafe", "cafe"}, new Object[]{"callFunc", "addCategory", "$P0", "car_dealer", "car_dealer"}, new Object[]{"callFunc", "addCategory", "$P0", "car_rental", "car_rental"}, new Object[]{"callFunc", "addCategory", "$P0", "car_wash", "car_wash"}, new Object[]{"callFunc", "addCategory", "$P0", "casino", "casino"}, new Object[]{"callFunc", "addCategory", "$P0", "cemetery", "cemetery"}, new Object[]{"callFunc", "addCategory", "$P0", "church", "church"}, new Object[]{"callFunc", "addCategory", "$P0", "clothing_store", "clothing_store"}, new Object[]{"callFunc", "addCategory", "$P0", "convenience_store", "convenience_store"}, new Object[]{"callFunc", "addCategory", "$P0", "courthouse", "courthouse"}, new Object[]{"callFunc", "addCategory", "$P0", "dentist", "dentist"}, new Object[]{"callFunc", "addCategory", "$P0", "department_store", "department_store"}, new Object[]{"callFunc", "addCategory", "$P0", "doctor", "doctor"}, new Object[]{"callFunc", "addCategory", "$P0", "electronics_store", "electronics_store"}, new Object[]{"callFunc", "addCategory", "$P0", "embassy", "embassy"}, new Object[]{"callFunc", "addCategory", "$P0", "finance", "finance"}, new Object[]{"callFunc", "addCategory", "$P0", "fire_station", "fire_station"}, new Object[]{"callFunc", "addCategory", "$P0", "florist", "florist"}, new Object[]{"callFunc", "addCategory", "$P0", "food", "food"}, new Object[]{"callFunc", "addCategory", "$P0", "funeral_home", "funeral_home"}, new Object[]{"callFunc", "addCategory", "$P0", "furniture_store", "furniture_store"}, new Object[]{"callFunc", "addCategory", "$P0", "gas_station", "gas_station"}, new Object[]{"callFunc", "addCategory", "$P0", "grocery_or_supermarket", "grocery_or_supermarket"}, new Object[]{"callFunc", "addCategory", "$P0", "gym", "gym"}, new Object[]{"callFunc", "addCategory", "$P0", "hardware_store", "hardware_store"}, new Object[]{"callFunc", "addCategory", "$P0", "health", "health"}, new Object[]{"callFunc", "addCategory", "$P0", "hindu_temple", "hindu_temple"}, new Object[]{"callFunc", "addCategory", "$P0", "hospital", "hospital"}, new Object[]{"callFunc", "addCategory", "$P0", "jewelry_store", "jewelry_store"}, new Object[]{"callFunc", "addCategory", "$P0", "laundry", "laundry"}, new Object[]{"callFunc", "addCategory", "$P0", "lawyer", "lawyer"}, new Object[]{"callFunc", "addCategory", "$P0", "library", "library"}, new Object[]{"callFunc", "addCategory", "$P0", "locksmith", "locksmith"}, new Object[]{"callFunc", "addCategory", "$P0", "mosque", "mosque"}, new Object[]{"callFunc", "addCategory", "$P0", "movie_theater", "movie_theater"}, new Object[]{"callFunc", "addCategory", "$P0", "museum", "museum"}, new Object[]{"callFunc", "addCategory", "$P0", "night_club", "night_club"}, new Object[]{"callFunc", "addCategory", "$P0", "parks", "parks"}, new Object[]{"callFunc", "addCategory", "$P0", "parking", "parking"}, new Object[]{"callFunc", "addCategory", "$P0", "pet_store", "pet_store"}, new Object[]{"callFunc", "addCategory", "$P0", "pharmacy", "pharmacy"}, new Object[]{"callFunc", "addCategory", "$P0", "physiotherapist", "physiotherapist"}, new Object[]{"callFunc", "addCategory", "$P0", "police", "police"}, new Object[]{"callFunc", "addCategory", "$P0", "post_office", "post_office"}, new Object[]{"callFunc", "addCategory", "$P0", "real_estate_agency", "real_estate_agency"}, new Object[]{"callFunc", "addCategory", "$P0", "restaurant", "restaurant"}, new Object[]{"callFunc", "addCategory", "$P0", "rv_park", "rv_park"}, new Object[]{"callFunc", "addCategory", "$P0", "school", "school"}, new Object[]{"callFunc", "addCategory", "$P0", "shoe_store", "shoe_store"}, new Object[]{"callFunc", "addCategory", "$P0", "shopping_mall", "shopping_mall"}, new Object[]{"callFunc", "addCategory", "$P0", "spa", "spa"}, new Object[]{"callFunc", "addCategory", "$P0", "stadium", "stadium"}, new Object[]{"callFunc", "addCategory", "$P0", "synagogue", "synagogue"}, new Object[]{"callFunc", "addCategory", "$P0", "taxi_stand", "taxi_stand"}, new Object[]{"callFunc", "addCategory", "$P0", "train_station", "train_station"}, new Object[]{"callFunc", "addCategory", "$P0", "travel_agency", "travel_agency"}, new Object[]{"callFunc", "addCategory", "$P0", "university", "university"}, new Object[]{"callFunc", "addCategory", "$P0", "veterinary_care", "veterinary_care"}, new Object[]{"callFunc", "addCategory", "$P0", "zoo", "zoo"}});
            this.put("getNearbyPOIs", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Latitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Longitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Radius"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P2", -90, "Latitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P3", -180, "Longitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P4", 0, "Radius"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P2", 90, "Latitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P3", 180, "Longitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P4", 40000, "Radius"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P6", "Categories"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "String", "https://maps.googleapis.com/maps/api/place/nearbysearch/json?"}, new Object[]{"string.concat", "$L1", "$L1", "key=", "$P0.apiKey"}, new Object[]{"string.concat", "$L2", "$P2", ",", "$P3"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&location=", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&radius=", "$P4"}, new Object[]{"if!=than", "$P5", null, 2}, new Object[]{"string.urlEncode", "$L2", "$P5"}, new Object[]{"string.concat", "$L1", "$L1", "&keyword=", "$L2"}, new Object[]{"if!=than", "$P6", null, 3}, new Object[]{"callFunc", "getCategoriesString", "$P0", "$L2", "$P6"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&types=", "$L2"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpResponse", "$P0", "$L3", "$L2"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"size", "$L5", "$L3.results"}, new Object[]{"if<than", "$L4", "$L5", 5}, new Object[]{"get", "$L6", "$L3.results", "$L4"}, new Object[]{"callFunc", "extractPOI", "$P0", "$L7", "$L6"}, new Object[]{"push", "$P1", "$L7"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -6}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkLessThan", new Object[]{new Object[]{"if<than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be less than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterThan", new Object[]{new Object[]{"if>than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be greater than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkIsEmpty", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be empty."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkHttpResponse", new Object[]{new Object[]{"if>=than", "$P2.code", 400, 10}, new Object[]{"if==than", "$P2.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P2.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P2.responseBody"}, new Object[]{"string.concat", "$L2", "$P2.code", " - ", "$L0.status"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P2.responseBody"}, new Object[]{"if!=than", "$L0.status", "OK", 6}, new Object[]{"if!=than", "$L0.error_message", null, 2}, new Object[]{"create", "$L3", "Error", "$L0.error_message", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$L0.error_message", null, 2}, new Object[]{"create", "$L3", "Error", "$L0.status", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("getCategoriesString", new Object[]{new Object[]{"create", "$P1", "String"}, new Object[]{"create", "$L0", "Number", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 10}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"get", "$L2", "$P0.crToPlaces", "$L2"}, new Object[]{"if==than", "$L2", null, 2}, new Object[]{"create", "$L3", "Error", "Unknown category.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$L0", 0, 1}, new Object[]{"string.concat", "$P1", "$P1", "|"}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -11}});
            this.put("extractPOI", new Object[]{new Object[]{"create", "$L0", "Array"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"size", "$L2", "$P2.types"}, new Object[]{"if<than", "$L1", "$L2", 6}, new Object[]{"get", "$L3", "$P2.types", "$L1"}, new Object[]{"get", "$L4", "$P0.placesToCr", "$L3"}, new Object[]{"if!=than", "$L4", null, 1}, new Object[]{"push", "$L0", "$L4"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -7}, new Object[]{"create", "$L1", "Location"}, new Object[]{"set", "$L1.latitude", "$P2.geometry.location.lat"}, new Object[]{"set", "$L1.longitude", "$P2.geometry.location.lng"}, new Object[]{"if!=than", "$P2.photos", null, 3}, new Object[]{"get", "$L2", "$P2.photos", 0}, new Object[]{"get", "$L3", "$L2.photo_reference"}, new Object[]{"string.concat", "$L4", "https://maps.googleapis.com/maps/api/place/photo?key=", "$P0.apiKey", "&photoreference=", "$L3", "&maxheight=", "$L2.height"}, new Object[]{"create", "$P1", "POI", "$L0", "$L4", "$L1", "$P2.name", null}});
            this.put("addCategory", new Object[]{new Object[]{"set", "$P0.crToPlaces", "$P2", "$P1"}, new Object[]{"set", "$P0.placesToCr", "$P1", "$P2"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public GooglePlaces(RedirectReceiver redirectReceiver, String apiKey) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("GooglePlaces");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("apiKey", apiKey);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public List<POI> getNearbyPOIs(Double latitude, Double longitude, Long radius, String searchTerm, List<String> categories) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("GooglePlaces", "getNearbyPOIs");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getNearbyPOIs", this.interpreterStorage, null, latitude, longitude, radius, searchTerm, categories);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("GooglePlaces", "getNearbyPOIs");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

