/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LinkedIn
implements Profile {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("getLIIdentifier", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"string.concat", "$P1", "linkedin-", "$P0.userData.id"}});
            this.put("getLIFullName", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"string.concat", "$P1", "$P0.userData.firstName", " ", "$P0.userData.lastName"}});
            this.put("getLIEmail", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"set", "$P1", "$P0.userData.emailAddress"}});
            this.put("getLIGender", new Object[0]);
            this.put("getLIDescription", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"set", "$P1", "$P0.userData.summary"}});
            this.put("getLIDateOfBirth", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"create", "$L0", "DateOfBirth"}, new Object[]{"if!=than", "$P0.userData.dateOfBirth", null, 6}, new Object[]{"if!=than", "$P0.userData.dateOfBirth.day", null, 1}, new Object[]{"set", "$L0.day", "$P0.userData.dateOfBirth.day"}, new Object[]{"if!=than", "$P0.userData.dateOfBirth.month", null, 1}, new Object[]{"set", "$L0.month", "$P0.userData.dateOfBirth.month"}, new Object[]{"if!=than", "$P0.userData.dateOfBirth.year", null, 1}, new Object[]{"set", "$L0.year", "$P0.userData.dateOfBirth.year"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("getLILocale", new Object[0]);
            this.put("getLIPictureURL", new Object[]{new Object[]{"callFunc", "checkUserData", "$P0"}, new Object[]{"set", "$P1", "$P0.userData.pictureUrl"}});
            this.put("loginLI", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("logoutLI", new Object[]{new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$P0.userData", null}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "String"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L0", "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=", "$P0.clientID", "&redirect_uri=", "$P0.redirectUri", "&state=", "$P0.state", "&scope=r_basicprofile%20r_emailaddress"}, new Object[]{"awaitCodeRedirect", "$L2", "$L0"}, new Object[]{"string.concat", "$L1", "grant_type=authorization_code&code=", "$L2", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientID", "&client_secret=", "$P0.clientSecret"}, new Object[]{"size", "$L15", "$L1"}, new Object[]{"string.concat", "$L15", "$L15"}, new Object[]{"stream.stringToStream", "$L3", "$L1"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"set", "$L4.Content-Length", "$L15"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://www.linkedin.com/uas/oauth2/accessToken"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 20}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("getUserData", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,email-address,summary,picture-url)?format=json"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"create", "$L3", "String"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"create", "$L5", "Date"}, new Object[]{"math.add", "$L6", "$L5.time", 60000}, new Object[]{"set", "$L4.expirationTime", "$L6"}, new Object[]{"set", "$P0.userData", "$L4"}});
            this.put("checkUserData", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if!=than", "$P0.userData", null, 2}, new Object[]{"if>=than", "$P0.userData.expirationTime", "$L0.time", 1}, new Object[]{"return"}, new Object[]{"callFunc", "getUserData", "$P0"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public LinkedIn(RedirectReceiver redirectReceiver, String clientID, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("LinkedIn");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    public String getIdentifier() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getIdentifier");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getIdentifier");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getFullName() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getFullName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getFullName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getEmail() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getEmail");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getEmail");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getGender() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getGender");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getGender");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getDescription() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getDescription");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public DateOfBirth getDateOfBirth() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getDateOfBirth");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getDateOfBirth");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    public String getLocale() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getLocale");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLILocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getLocale");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getPictureURL() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "getPictureURL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getLIPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "getPictureURL");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public void login() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "login");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("loginLI", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "login");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public void logout() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("LinkedIn", "logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("logoutLI", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("LinkedIn", "logout");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

