/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MicrosoftLive
implements Profile {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$P0.userInfo", null}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"string.concat", "$P1", "microsoftlive-", "$P0.userInfo.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.name", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.name"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.emails.account"}});
            this.put("Profile:getGender", new Object[0]);
            this.put("Profile:getDescription", new Object[0]);
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"create", "$P1", "DateOfBirth"}, new Object[]{"if!=than", "$P0.userInfo.birth_day", null, 1}, new Object[]{"set", "$P1.day", "$P0.userInfo.birth_day"}, new Object[]{"if!=than", "$P0.userInfo.birth_month", null, 1}, new Object[]{"set", "$P1.month", "$P0.userInfo.birth_month"}, new Object[]{"if!=than", "$P0.userInfo.birth_year", null, 1}, new Object[]{"set", "$P1.year", "$P0.userInfo.birth_year"}});
            this.put("Profile:getLocale", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.locale", null, 1}, new Object[]{"string.substring", "$P1", "$P0.userInfo.locale", 0, 2}});
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"string.concat", "$P1", "https://apis.live.net/v5.0/", "$P0.userInfo.id", "/picture"}});
            this.put("checkUserInfo", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if!=than", "$P0.userInfo", null, 2}, new Object[]{"if>than", "$P0.expirationTime", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://apis.live.net/v5.0/me?access_token=", "$S0.accessToken"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$P0.userInfo", "$L3.responseBody"}, new Object[]{"create", "$P0.expirationTime", "Date"}, new Object[]{"math.add", "$P0.expirationTime.time", "$P0.expirationTime.time", 60000}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"if==than", "$P1", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://login.live.com/oauth20_authorize.srf?client_id=", "$P0.clientID", "&scope=", "wl.emails%20wl.birthday", "&response_type=code&redirect_uri=", "$P0.redirectUri"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientID", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientID", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&refresh_token=", "$S0.refreshToken", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"size", "$L19", "$L2"}, new Object[]{"string.concat", "$L4.Content-Length", "$L19"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://login.live.com/oauth20_token.srf"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"set", "$S0.refreshToken", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 12}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L1", "$L0.error"}, new Object[]{"set", "$L2", "$L1.message"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$L2"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public MicrosoftLive(RedirectReceiver redirectReceiver, String clientID, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("MicrosoftLive");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    public String getIdentifier() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getIdentifier");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getIdentifier");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getFullName() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getFullName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getFullName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getEmail() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getEmail");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getEmail");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getGender() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getGender");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getGender");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getDescription() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getDescription");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public DateOfBirth getDateOfBirth() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getDateOfBirth");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getDateOfBirth");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    public String getLocale() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getLocale");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getLocale");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getPictureURL() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "getPictureURL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "getPictureURL");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public void login() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "login");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "login");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public void logout() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("MicrosoftLive", "logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("MicrosoftLive", "logout");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

