/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Slack
implements Profile {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$P0.userInfo", null}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"string.concat", "$P1", "slack-", "$P0.userInfo.team.id", "-", "$P0.userInfo.user.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.user.name", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.user.name"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.user.email", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.user.email"}});
            this.put("Profile:getGender", new Object[0]);
            this.put("Profile:getDescription", new Object[0]);
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"create", "$P1", "DateOfBirth"}});
            this.put("Profile:getLocale", new Object[0]);
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.user.image_192", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.user.image_192"}});
            this.put("checkUserInfo", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if!=than", "$P0.userInfo", null, 2}, new Object[]{"if>than", "$P0.expirationTime", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.url", "https://slack.com/api/users.identity?token=", "$S0.accessToken"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$P0.userInfo", "$L3"}, new Object[]{"create", "$P0.expirationTime", "Date"}, new Object[]{"math.add", "$P0.expirationTime.time", "$P0.expirationTime.time", 60000}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", null, "$S0.accessToken", 1}, new Object[]{"return"}, new Object[]{"string.concat", "$L0", "https://slack.com/oauth/authorize?redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&state=", "$P0.state", "&scope=", "identity.basic,identity.team,identity.avatar,identity.email"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"string.concat", "$L3", "code=", "$L1", "&redirect_uri=", "$P0.redirectUri", "&client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret"}, new Object[]{"string.concat", "$L2.url", "https://slack.com/api/oauth.access?", "$L3"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6", "$L5"}, new Object[]{"set", "$S0.accessToken", "$L6.access_token"}});
            this.put("validateResponse", new Object[]{new Object[]{"set", "$L1", "$P2"}, new Object[]{"if>=than", "$L1.code", 400, 10}, new Object[]{"if==than", "$L1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$L1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$L1.responseBody"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$L0.error"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$L1.responseBody"}, new Object[]{"if==than", "$L0.ok", 0, 2}, new Object[]{"create", "$L3", "Error", "$L0.error", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"set", "$P1", "$L0"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Slack(RedirectReceiver redirectReceiver, String clientId, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("Slack");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    public String getIdentifier() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getIdentifier");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getIdentifier");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getFullName() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getFullName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getFullName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getEmail() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getEmail");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getEmail");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getGender() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getGender");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getGender");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getDescription() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getDescription");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public DateOfBirth getDateOfBirth() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getDateOfBirth");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getDateOfBirth");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    public String getLocale() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getLocale");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getLocale");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getPictureURL() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "getPictureURL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "getPictureURL");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public void login() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "login");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "login");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public void logout() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Slack", "logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Slack", "logout");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

