/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.interfaces.Social;
import com.cloudrail.si.servicecode.InitSelfTest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.Statistics;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
implements Profile,
Social {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"delete", "$S0.oauthToken"}, new Object[]{"delete", "$S0.oauthTokenSecret"}, new Object[]{"set", "$P0.userInfo", null}});
            this.put("Social:postUpdate", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The status is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"size", "$L0", "$P1"}, new Object[]{"if>than", "$L0", 140, 2}, new Object[]{"create", "$L0", "Error", "The status is not allowed to contain more than 140 characters.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.urlEncode", "$L3", "$P1"}, new Object[]{"callFunc", "urlEncode", "$P0", "$L5", "$L3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://api.twitter.com/1.1/statuses/update.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"push", "$L1", "status"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.status", "$P1"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L4"}, new Object[]{"string.concat", "$L21", "status=", "$L5"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L21"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}});
            this.put("Social:getConnections", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/1.1/friends/ids.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "count"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"push", "$L1", "stringify_ids"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.count", "5000"}, new Object[]{"set", "$L3.stringify_ids", "true"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1", "$L3"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "?count=5000&stringify_ids=true"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"set", "$L3", "$L2.ids"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"size", "$L5", "$L3"}, new Object[]{"if<than", "$L4", "$L5", 5}, new Object[]{"get", "$L6", "$L3", "$L4"}, new Object[]{"string.concat", "$L6", "twitter-", "$L6"}, new Object[]{"push", "$P1", "$L6"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -6}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"string.concat", "$P1", "twitter-", "$P0.userInfo.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.name"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.email"}});
            this.put("Profile:getGender", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.gender"}});
            this.put("Profile:getDescription", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.description"}});
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.dateOfBirth"}});
            this.put("Profile:getLocale", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.locale"}});
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "User:getInfo", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.pictureURL"}});
            this.put("User:getInfo", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -10000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:sendInfoRequest", "$P0"}});
            this.put("User:sendInfoRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/1.1/account/verify_credentials.json"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_token"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L3", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L3.Time"}, new Object[]{"set", "$P0.userInfo.id", "$L2.id_str"}, new Object[]{"set", "$P0.userInfo.name", "$L2.name"}, new Object[]{"set", "$P0.userInfo.email", null}, new Object[]{"set", "$P0.userInfo.gender", null}, new Object[]{"set", "$P0.userInfo.description", "$L2.description"}, new Object[]{"create", "$P0.userInfo.dateOfBirth", "DateOfBirth"}, new Object[]{"set", "$P0.userInfo.locale", "$L2.lang"}, new Object[]{"set", "$P0.userInfo.pictureURL", "$L2.profile_image_url"}});
            this.put("oAuth1:signRequest", new Object[]{new Object[]{"if==than", "$P1.requestHeaders", null, 1}, new Object[]{"create", "$P1.requestHeaders", "Object"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.oauth_consumer_key", "$P0.clientID"}, new Object[]{"callFunc", "oAuth1:generateNonce", "$L0.oauth_nonce"}, new Object[]{"set", "$L0.oauth_signature_method", "HMAC-SHA1"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"math.multiply", "$L1", "$L1.Time", 0.001}, new Object[]{"math.floor", "$L1", "$L1"}, new Object[]{"string.format", "$L0.oauth_timestamp", "%d", "$L1"}, new Object[]{"set", "$L0.oauth_token", "$S0.oauthToken"}, new Object[]{"set", "$L0.oauth_version", "1.0"}, new Object[]{"string.urlEncode", "$L2", "$P1.url"}, new Object[]{"string.concat", "$L1", "$P1.method", "&", "$L2", "&"}, new Object[]{"set", "$L2", ""}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$P2"}, new Object[]{"if<than", "$L3", "$L4", 15}, new Object[]{"get", "$L5", "$P2", "$L3"}, new Object[]{"if==than", "$L5", "oauth_callback", 1}, new Object[]{"set", "$L0.oauth_callback", "$P0.redirectUri"}, new Object[]{"get", "$L6", "$L0", "$L5"}, new Object[]{"if>than", "$L3", 0, 1}, new Object[]{"string.concat", "$L2", "$L2", "&"}, new Object[]{"if==than", "$L6", null, 1}, new Object[]{"get", "$L6", "$P3", "$L5"}, new Object[]{"string.urlEncode", "$L6", "$L6"}, new Object[]{"if==than", "$L5", "status", 2}, new Object[]{"callFunc", "urlEncode", "$P0", "$L20", "$L6"}, new Object[]{"set", "$L6", "$L20"}, new Object[]{"string.concat", "$L2", "$L2", "$L5", "=", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -16}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "$L2"}, new Object[]{"set", "$L2", "$S0.oauthTokenSecret"}, new Object[]{"if==than", "$L2", null, 1}, new Object[]{"set", "$L2", ""}, new Object[]{"string.concat", "$L2", "$P0.clientSecret", "&", "$L2"}, new Object[]{"crypt.hmac.sha1", "$L2", "$L2", "$L1"}, new Object[]{"array.uint8ToBase64", "$L2", "$L2"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"set", "$L0.oauth_signature", "$L2"}, new Object[]{"set", "$L2", "OAuth "}, new Object[]{"if!=than", "$L0.oauth_callback", null, 2}, new Object[]{"string.urlEncode", "$L3", "$L0.oauth_callback"}, new Object[]{"string.concat", "$L2", "$L2", "oauth_callback", "=\"", "$L3", "\"", ", "}, new Object[]{"string.concat", "$L2", "$L2", "oauth_consumer_key", "=\"", "$L0.oauth_consumer_key", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_nonce", "=\"", "$L0.oauth_nonce", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature", "=\"", "$L0.oauth_signature", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature_method", "=\"", "$L0.oauth_signature_method", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_timestamp", "=\"", "$L0.oauth_timestamp", "\""}, new Object[]{"if!=than", "$L0.oauth_token", null, 1}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_token", "=\"", "$L0.oauth_token", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_version", "=\"", "$L0.oauth_version", "\""}, new Object[]{"set", "$P1.requestHeaders.Authorization", "$L2"}});
            this.put("oAuth1:generateNonce", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"string.format", "$L0", "%d", "$L0.Time"}, new Object[]{"hash.md5", "$L0", "$L0"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"set", "$P0", ""}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P0", "$P0", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("urlEncode", new Object[]{new Object[]{"string.split", "$L0", "$P2", "\\+"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"create", "$L2", "Number"}, new Object[]{"set", "$L2", 0}, new Object[]{"create", "$L4", "String"}, new Object[]{"if<than", "$L2", "$L1", 7}, new Object[]{"get", "$L5", "$L0", "$L2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"set", "$L4", "$L5"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L4", "$L4", "%20", "$L5"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"set", "$P1", "$L4"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"if!=than", "$S0.oauthToken", null, 2}, new Object[]{"if!=than", "$S0.oauthTokenSecret", null, 1}, new Object[]{"return"}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"set", "$L0.url", "https://api.twitter.com/oauth/request_token"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"push", "$L1", "oauth_callback"}, new Object[]{"push", "$L1", "oauth_consumer_key"}, new Object[]{"push", "$L1", "oauth_nonce"}, new Object[]{"push", "$L1", "oauth_signature_method"}, new Object[]{"push", "$L1", "oauth_timestamp"}, new Object[]{"push", "$L1", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L1"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"if!=than", "$L1.code", 200, 3}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"stream.streamToString", "$L2", "$L1.responseBody"}, new Object[]{"string.split", "$L2", "$L2", "&"}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$L2"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"if<than", "$L3", "$L4", 8}, new Object[]{"get", "$L5", "$L2", "$L3"}, new Object[]{"string.split", "$L6", "$L5", "=", 2}, new Object[]{"get", "$L7", "$L6", 0}, new Object[]{"get", "$L8", "$L6", 1}, new Object[]{"string.urlDecode", "$L8", "$L8"}, new Object[]{"set", "$L0", "$L8", "$L7"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -9}, new Object[]{"string.concat", "$L3", "https://api.twitter.com/oauth/authenticate?oauth_token=", "$L0.oauth_token"}, new Object[]{"awaitCodeRedirect", "$L3", "$L3", "oauth_token", "oauth_verifier"}, new Object[]{"set", "$S0.oauthToken", "$L3.oauth_token"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4.method", "POST"}, new Object[]{"set", "$L4.url", "https://api.twitter.com/oauth/access_token"}, new Object[]{"create", "$L4.requestHeaders", "Object"}, new Object[]{"set", "$L4.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"string.urlEncode", "$L5", "$L3.oauth_verifier"}, new Object[]{"string.concat", "$L5", "oauth_verifier=", "$L5"}, new Object[]{"stream.stringToStream", "$L4.requestBody", "$L5"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.oauth_verifier", "$L3.oauth_verifier"}, new Object[]{"create", "$L7", "Array"}, new Object[]{"push", "$L7", "oauth_callback"}, new Object[]{"push", "$L7", "oauth_consumer_key"}, new Object[]{"push", "$L7", "oauth_nonce"}, new Object[]{"push", "$L7", "oauth_signature_method"}, new Object[]{"push", "$L7", "oauth_timestamp"}, new Object[]{"push", "$L7", "oauth_verifier"}, new Object[]{"push", "$L7", "oauth_version"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L4", "$L7", "$L6"}, new Object[]{"http.requestCall", "$L9", "$L4"}, new Object[]{"if!=than", "$L9.code", 200, 3}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}, new Object[]{"create", "$L11", "Error", "$L10", "Authentication"}, new Object[]{"throwError", "$L11"}, new Object[]{"stream.streamToString", "$L10", "$L9.responseBody"}, new Object[]{"string.split", "$L10", "$L10", "&"}, new Object[]{"set", "$L11", 0}, new Object[]{"size", "$L12", "$L10"}, new Object[]{"create", "$L13", "Object"}, new Object[]{"if<than", "$L11", "$L12", 8}, new Object[]{"get", "$L14", "$L10", "$L11"}, new Object[]{"string.split", "$L15", "$L14", "=", 2}, new Object[]{"get", "$L16", "$L15", 0}, new Object[]{"get", "$L17", "$L15", 1}, new Object[]{"string.urlDecode", "$L17", "$L17"}, new Object[]{"set", "$L13", "$L17", "$L16"}, new Object[]{"math.add", "$L11", "$L11", 1}, new Object[]{"jumpRel", -9}, new Object[]{"string.urlDecode", "$S0.oauthToken", "$L13.oauth_token"}, new Object[]{"string.urlDecode", "$S0.oauthTokenSecret", "$L13.oauth_token_secret"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 9}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Twitter(RedirectReceiver redirectReceiver, String clientID, String clientSecret, String redirectUri) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new Thread(){

            public void run() {
                try {
                    InitSelfTest.initTest("Twitter");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public String getIdentifier() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getIdentifier");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getIdentifier");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getFullName() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getFullName");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getFullName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getEmail() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getEmail");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getEmail");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getGender() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getGender");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getGender");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getDescription() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getDescription");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public DateOfBirth getDateOfBirth() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getDateOfBirth");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getDateOfBirth");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    @Override
    public String getLocale() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getLocale");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getLocale");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getPictureURL() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getPictureURL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getPictureURL");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public void login() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "login");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "login");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "logout");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void postUpdate(String content) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "postUpdate");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:postUpdate", this.interpreterStorage, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "postUpdate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public List<String> getConnections() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Statistics.getInstance().addCall("Twitter", "getConnections");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:getConnections", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Statistics.getInstance().addError("Twitter", "getConnections");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    @Override
    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

