/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.statistics;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.JSONObject;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import com.cloudrail.si.statistics.SendStatisticsTask;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Statistics {
    private static final String libraryVersion = "2.6.2";
    private static final String SERVER_URL = "https://keys.cloudrail.com/api/entries";
    private static final long DELAY = 300000L;
    private static Statistics ourInstance = new Statistics();
    private JSONObject data = new JSONObject();
    private long next = 1L;
    private long count = 0L;
    private String entryID = null;
    private Timer timer = null;

    private Statistics() {
    }

    public static Statistics getInstance() {
        return ourInstance;
    }

    public synchronized void addCall(String service, String method) {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new SendStatisticsTask(), 300000L);
        }
        JSONObject calls = this.getMethodCalls(service, method);
        calls.put("count", (Long)calls.get("count") + 1L);
        ++this.count;
        if (this.count == this.next) {
            this.next *= 2L;
            this.sendStatistics();
        }
    }

    public synchronized void addError(String service, String method) {
        if (CloudRail.getAppKey() == null) {
            return;
        }
        JSONObject calls = this.getMethodCalls(service, method);
        calls.put("error", (Long)calls.get("error") + 1L);
    }

    public synchronized void sendStatistics() {
        if (this.count == 0L) {
            return;
        }
        JSONObject body = new JSONObject();
        if (this.entryID == null) {
            StringBuilder macSB = new StringBuilder();
            try {
                NetworkInterface netinterface = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
                byte[] macBytes = netinterface.getHardwareAddress();
                for (int i = 0; i < macBytes.length; ++i) {
                    if (i > 0) {
                        macSB.append(':');
                    }
                    macSB.append(String.format("%02x", macBytes[i]));
                }
            }
            catch (SocketException macBytes) {
            }
            catch (UnknownHostException macBytes) {
                // empty catch block
            }
            String mainClassName = null;
            Map<String, String> env = System.getenv();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                if (mainClassName != null || !entry.getKey().startsWith("JAVA_MAIN_CLASS")) continue;
                mainClassName = entry.getValue();
            }
            JSONObject app = new JSONObject();
            app.put("mainClass", mainClassName);
            String appHash = this.hashString(mainClassName);
            JSONObject client = new JSONObject();
            String osName = System.getProperty("os.name");
            client.put("os", osName);
            String clientHash = this.hashString(macSB + osName);
            body.put("appHash", appHash);
            body.put("clientHash", clientHash);
            body.put("platform", "Java");
            body.put("libraryVersion", libraryVersion);
            body.put("app", app);
            body.put("client", client);
        } else {
            body.put("id", this.entryID);
        }
        if (CloudRail.getAppKey() != null) {
            body.put("appKey", CloudRail.getAppKey());
        }
        body.put("data", this.data);
        boolean success = this.sendRequest(body.toJSONString());
        if (success) {
            this.data = new JSONObject();
            this.count = 0L;
            this.timer.cancel();
            this.timer = null;
        }
    }

    private JSONObject getMethodCalls(String service, String method) {
        JSONObject callsToService;
        if (!this.data.containsKey(service)) {
            this.data.put(service, new JSONObject());
        }
        if (!(callsToService = (JSONObject)this.data.get(service)).containsKey(method)) {
            JSONObject temp = new JSONObject();
            temp.put("count", 0L);
            temp.put("error", 0L);
            callsToService.put(method, temp);
        }
        return (JSONObject)callsToService.get(method);
    }

    private String hashString(String source) {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        m.reset();
        m.update(source.getBytes());
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext;
    }

    private boolean sendRequest(String body) {
        try {
            URL url = new URL(SERVER_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.close();
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException();
            }
            if (this.entryID == null) {
                String line;
                InputStream is = connection.getInputStream();
                BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                StringBuilder response = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
                rd.close();
                JSONObject resp = (JSONObject)new JSONParser().parse(response.toString());
                this.entryID = (String)resp.get("id");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

