/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.SandboxObject;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Address
extends SandboxObject {
    private String country;
    private String city;
    private String state;
    private String line1;
    private String line2;
    private String postalCode;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        String[] countries = Locale.getISOCountries();
        List<String> listCountries = Arrays.asList(countries);
        if (!listCountries.contains(country)) {
            throw new IllegalArgumentException("The country code is not valid. Please provide the correct ISO code.");
        }
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        if (this.country != null ? !this.country.equals(address.country) : address.country != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address.city) : address.city != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(address.state) : address.state != null) {
            return false;
        }
        if (this.line1 != null ? !this.line1.equals(address.line1) : address.line1 != null) {
            return false;
        }
        if (this.line2 != null ? !this.line2.equals(address.line2) : address.line2 != null) {
            return false;
        }
        return this.postalCode != null ? this.postalCode.equals(address.postalCode) : address.postalCode == null;
    }

    public int hashCode() {
        int result = this.country != null ? this.country.hashCode() : 0;
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.line1 != null ? this.line1.hashCode() : 0);
        result = 31 * result + (this.line2 != null ? this.line2.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Address{country='" + this.country + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", line1='" + this.line1 + '\'' + ", line2='" + this.line2 + '\'' + ", postalCode='" + this.postalCode + '\'' + '}';
    }
}

