/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.SandboxObject;
import java.util.Currency;

public class Refund
extends SandboxObject {
    private String id;
    private long amount;
    private long created;
    private String currency;
    private String chargeID;
    private String state;

    public Refund(Long amount, String chargeID, Long created, String id, String state, String currency) {
        if (chargeID == null || id == null || state == null) {
            throw new IllegalArgumentException("At least one of the parameters is null.");
        }
        if (!(state.equals("pending") || state.equals("succeeded") || state.equals("failed"))) {
            throw new IllegalArgumentException("Unknown state. Allowed values are: 'succeeded', 'failed' or 'pending'.");
        }
        if (!this.validateCurrency(currency)) {
            throw new IllegalArgumentException("The passed currency is invalid.");
        }
        this.amount = amount;
        this.chargeID = chargeID;
        this.created = created;
        this.id = id;
        this.state = state;
        this.currency = currency.toUpperCase();
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getChargeID() {
        return this.chargeID;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public String getState() {
        return this.state;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Refund)) {
            return false;
        }
        Refund refund = (Refund)o;
        if (this.amount != refund.amount) {
            return false;
        }
        if (this.created != refund.created) {
            return false;
        }
        if (!this.id.equals(refund.id)) {
            return false;
        }
        if (!this.chargeID.equals(refund.chargeID)) {
            return false;
        }
        if (!this.currency.equals(refund.currency)) {
            return false;
        }
        return this.state.equals(refund.state);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (int)(this.amount ^ this.amount >>> 32);
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + this.chargeID.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.currency.hashCode();
        return result;
    }

    public String toString() {
        return "Refund{id='" + this.id + '\'' + ", amount=" + this.amount + ", created=" + this.created + ", chargeID='" + this.chargeID + '\'' + ", state='" + this.state + '\'' + ", currency='" + this.currency + '\'' + '}';
    }

    private boolean validateCurrency(String currency) {
        Currency currency1 = Currency.getInstance(currency);
        return currency1 != null;
    }
}

