/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.CreditCard;
import com.cloudrail.si.types.SandboxObject;

public class Subscription
extends SandboxObject {
    private String id;
    private Long created;
    private String name;
    private String description;
    private String subscriptionPlanID;
    private Long lastCharge;
    private Long nextCharge;
    private CreditCard creditCard;
    private String state;

    public Subscription(Long created, String description, String id, Long lastCharge, String name, Long nextCharge, CreditCard creditCard, String state, String subscriptionPlanID) {
        if (description == null || id == null || name == null || creditCard == null || state == null || subscriptionPlanID == null) {
            throw new IllegalArgumentException("At least one of the parameters is undefined.");
        }
        if (!state.equals("active") && !state.equals("cancelled")) {
            throw new IllegalArgumentException("Unknown state. Allowed values are: 'active' or 'canceled'.");
        }
        this.created = created;
        this.description = description;
        this.id = id;
        this.lastCharge = lastCharge;
        this.name = name;
        this.nextCharge = nextCharge;
        this.creditCard = creditCard;
        this.state = state;
        this.subscriptionPlanID = subscriptionPlanID;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Long getLastCharge() {
        return this.lastCharge;
    }

    public String getName() {
        return this.name;
    }

    public Long getNextCharge() {
        return this.nextCharge;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getState() {
        return this.state;
    }

    public String getSubscriptionPlanID() {
        return this.subscriptionPlanID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.created != that.created) {
            return false;
        }
        if (this.lastCharge != that.lastCharge) {
            return false;
        }
        if (this.nextCharge != that.nextCharge) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.subscriptionPlanID.equals(that.subscriptionPlanID)) {
            return false;
        }
        if (!this.creditCard.equals(that.creditCard)) {
            return false;
        }
        return this.state.equals(that.state);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.subscriptionPlanID.hashCode();
        result = 31 * result + (int)(this.lastCharge ^ this.lastCharge >>> 32);
        result = 31 * result + (int)(this.nextCharge ^ this.nextCharge >>> 32);
        result = 31 * result + this.creditCard.hashCode();
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public String toString() {
        return "Subscription{id='" + this.id + '\'' + ", created=" + this.created + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", subscriptionPlanID='" + this.subscriptionPlanID + '\'' + ", lastCharge=" + this.lastCharge + ", nextCharge=" + this.nextCharge + ", creditCard=" + this.creditCard + ", state='" + this.state + '\'' + '}';
    }
}

