/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode;

import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.JSONValue;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ContainerFactory;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ParseException;
import com.cloudrail.si.types.JSONAware;
import com.cloudrail.si.types.SandboxObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sandbox {
    private static final int LIST_MAX_ADD_JUMP_ALLOWED = 32;
    private static final String JSON_AWARE_MARKER = "@JSONAware/";
    private Map<String, Object[]> serviceCode;
    private List<List<Object>> localVariablesStack;
    private List<List<Object>> parametersStack;
    private List<Object> persistentStorage;
    private List<String> codeFunctionName;
    private List<Integer> codeLine;
    private Object thrownError;
    private Map<String, Object> instanceDependencyStorage;

    public Sandbox() {
        this.setServiceCode(null);
        this.localVariablesStack = new ArrayList<List<Object>>();
        this.parametersStack = new ArrayList<List<Object>>();
        this.codeFunctionName = new ArrayList<String>();
        this.codeLine = new ArrayList<Integer>();
        this.persistentStorage = new ArrayList<Object>();
        this.thrownError = null;
    }

    public Sandbox(Map<String, Object[]> serviceCode) {
        this();
        this.setServiceCode(serviceCode);
        this.instanceDependencyStorage = new TreeMap<String, Object>();
    }

    public Sandbox(Map<String, Object[]> serviceCode, Map<String, Object> instanceDependencyStorage) {
        this();
        this.setServiceCode(serviceCode);
        this.instanceDependencyStorage = instanceDependencyStorage;
    }

    public Sandbox(Map<String, Object[]> serviceCode, List<Object> persistentStorage) {
        this();
        this.setServiceCode(serviceCode);
        this.persistentStorage = persistentStorage;
    }

    public Sandbox(Map<String, Object[]> serviceCode, List<Object> persistentStorage, Map<String, Object> instanceDependencyStorage) {
        this();
        this.setServiceCode(serviceCode);
        this.persistentStorage = persistentStorage;
        this.instanceDependencyStorage = instanceDependencyStorage;
    }

    public void createNewStackLevel(String functionName) {
        this.createNewStackLevel(functionName, 0);
    }

    public void createNewStackLevel(String functionName, int codeLine) {
        this.localVariablesStack.add(new ArrayList());
        this.parametersStack.add(new ArrayList());
        this.codeFunctionName.add(functionName);
        this.codeLine.add(codeLine);
    }

    public List<Object> currentLocalVariables() {
        if (this.localVariablesStack.isEmpty()) {
            return null;
        }
        return this.localVariablesStack.get(this.localVariablesStack.size() - 1);
    }

    public List<Object> currentParameters() {
        if (this.parametersStack.isEmpty()) {
            return null;
        }
        return this.parametersStack.get(this.parametersStack.size() - 1);
    }

    public List<List<Object>> getParameterStack() {
        return this.parametersStack;
    }

    public Object getParameter(int idx, int stacklevel) {
        if (this.parametersStack.isEmpty() || stacklevel >= this.parametersStack.size() || idx >= this.parametersStack.get(stacklevel).size()) {
            return null;
        }
        return this.parametersStack.get(stacklevel).get(idx);
    }

    public void callFunction(String functionName, Object[] parameters) {
        this.createNewStackLevel(functionName, -1);
        List<Object> parameterStack = this.currentParameters();
        parameterStack.addAll(Arrays.asList(parameters));
    }

    public void returnFromFunction() {
        if (this.codeFunctionName.size() <= 1) {
            return;
        }
        int currentStackLevel = this.codeFunctionName.size() - 1;
        Object[] callFunctionCommandParameters = Interpreter.decodeCommandParameters((Object[])this.serviceCode.get(this.codeFunctionName.get(currentStackLevel - 1))[this.codeLine.get(currentStackLevel - 1)]);
        for (int i = 1; i < callFunctionCommandParameters.length; ++i) {
            Object parameterVar = callFunctionCommandParameters[i];
            if (!(parameterVar instanceof VarAddress)) continue;
            Object value = this.parametersStack.get(currentStackLevel).get(i - 1);
            this.setVariable((VarAddress)parameterVar, value, currentStackLevel - 1);
        }
        this.codeFunctionName.remove(currentStackLevel);
        this.codeLine.remove(currentStackLevel);
        this.localVariablesStack.remove(currentStackLevel);
        this.parametersStack.remove(currentStackLevel);
        this.incrementCurrentServiceCodeLine();
    }

    public List<Object> decodeVariableAddress(VarAddress varAddress) {
        ArrayList<Object> decAdr = new ArrayList<Object>();
        String adr = varAddress.getVarAddress();
        assert (adr.charAt(0) != '$');
        if (adr.charAt(0) < '0' || adr.charAt(0) > '9') {
            decAdr.add(String.valueOf(adr.charAt(0)));
            adr = adr.substring(1);
        }
        String[] adrParts = adr.split("(?<=[^\\\\])\\.");
        for (int i = 0; i < adrParts.length; ++i) {
            String part = adrParts[i];
            if (part.matches("^\\d+$")) {
                decAdr.add(Integer.parseInt(part));
                continue;
            }
            decAdr.add(part.replaceAll("\\\\\\.", "."));
        }
        return decAdr;
    }

    private Object getEntry(Object container, List<Object> varAddress, boolean emptyIsNull) {
        Object entry = null;
        Object varAddressPart = varAddress.get(0);
        if (container instanceof List) {
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Number)) {
                throw new IndexOutOfBoundsException();
            }
            entry = emptyIsNull && ((Number)varAddressPart).intValue() >= ((List)container).size() ? null : (Object)((List)container).get(((Number)varAddressPart).intValue());
        } else if (container instanceof Map) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            entry = ((Map)container).get(varAddressPart);
        } else if (container instanceof String) {
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Integer)) {
                throw new IndexOutOfBoundsException();
            }
            entry = emptyIsNull && ((Number)varAddressPart).intValue() >= ((String)container).length() ? null : Integer.valueOf(((String)container).charAt(((Number)varAddressPart).intValue()));
        } else if (container instanceof SandboxObject) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            entry = ((SandboxObject)container).get((String)varAddressPart);
        } else if (container instanceof Double) {
            // empty if block
        }
        if (varAddress.size() > 1) {
            return this.getEntry(entry, varAddress.subList(1, varAddress.size()), emptyIsNull);
        }
        return entry;
    }

    public Object getVariable(VarAddress varAddress) {
        List<Object> varAddressParts = this.decodeVariableAddress(varAddress);
        return this.getVariable(varAddressParts, this.localVariablesStack.size() - 1, false);
    }

    public Object getVariable(VarAddress varAddress, boolean emptyIsNull) {
        List<Object> varAddressParts = this.decodeVariableAddress(varAddress);
        return this.getVariable(varAddressParts, this.localVariablesStack.size() - 1, emptyIsNull);
    }

    public Object getVariable(List<Object> varAddressParts) {
        return this.getVariable(varAddressParts, this.localVariablesStack.size() - 1, false);
    }

    public Object getVariable(List<Object> varAddressParts, int stacklevel, boolean emptyIsNull) {
        List<Object> variables = null;
        String part = (String)varAddressParts.get(0);
        if (part.equals("L")) {
            variables = this.localVariablesStack.get(stacklevel);
        } else if (part.equals("P")) {
            variables = this.parametersStack.get(stacklevel);
        } else if (part.equals("S")) {
            variables = this.persistentStorage;
        } else {
            throw new IndexOutOfBoundsException(varAddressParts.toString());
        }
        if (emptyIsNull && (Integer)varAddressParts.get(1) >= variables.size()) {
            return null;
        }
        Object localEntry = variables.get((Integer)varAddressParts.get(1));
        if (varAddressParts.size() <= 2) {
            return localEntry;
        }
        return this.getEntry(localEntry, varAddressParts.subList(2, varAddressParts.size()), emptyIsNull);
    }

    private boolean setEntry(Object container, List<Object> varAddress, Object value) {
        if (varAddress.size() > 1) {
            Object nextContainer = this.getEntry(container, varAddress.subList(0, varAddress.size() - 1), false);
            return this.setEntry(nextContainer, varAddress.subList(1, varAddress.size()), value);
        }
        Object varAddressPart = varAddress.get(0);
        if (container instanceof List) {
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Number) || ((Number)varAddressPart).intValue() >= ((List)container).size()) {
                throw new IndexOutOfBoundsException();
            }
            int idx = ((Number)varAddressPart).intValue();
            List list = (List)container;
            if (list.size() + 32 <= idx) {
                Object[] addnull = new Object[idx - list.size() + 1];
                list.addAll(Arrays.asList(addnull));
            }
            list.set(idx, value);
        } else if (container instanceof Map) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            ((Map)container).put((String)varAddressPart, value);
        } else if (container instanceof String) {
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Number)) {
                throw new IndexOutOfBoundsException();
            }
            int idx = ((Number)varAddressPart).intValue();
            String ch = value instanceof Number ? "" + ((Number)value).intValue() : value.toString();
            container = ((String)container).substring(0, idx) + ch + ((String)container).substring(idx + ch.length());
        } else if (container instanceof SandboxObject) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            ((SandboxObject)container).set((String)varAddressPart, value);
        } else if (container instanceof Double) {
            container = value;
        }
        return false;
    }

    public boolean setVariable(VarAddress varAddress, Object value) {
        return this.setVariable(varAddress, value, this.localVariablesStack.size() - 1);
    }

    public boolean setVariable(VarAddress varAddress, Object value, int stacklevel) {
        List<Object> varAddressParts = this.decodeVariableAddress(varAddress);
        return this.setVariable(varAddressParts, value, stacklevel);
    }

    public boolean setVariable(List<Object> varAddressParts, Object value) {
        return this.setVariable(varAddressParts, value, this.localVariablesStack.size() - 1);
    }

    public boolean setVariable(List<Object> varAddressParts, Object value, int stacklevel) {
        List<Object> variables = null;
        String part = (String)varAddressParts.get(0);
        if (part.equals("L")) {
            variables = this.localVariablesStack.get(stacklevel);
        } else if (part.equals("P")) {
            variables = this.parametersStack.get(stacklevel);
        } else if (part.equals("S")) {
            variables = this.persistentStorage;
        } else {
            throw new IndexOutOfBoundsException(varAddressParts.toString());
        }
        int varIdx = (Integer)varAddressParts.get(1);
        if (varAddressParts.size() <= 2) {
            if (variables.size() == varIdx) {
                variables.add(value);
            } else if (variables.size() > varIdx) {
                variables.set(varIdx, value);
            } else if (variables.size() + 32 > varIdx) {
                Object[] addnull = new Object[varIdx - variables.size() + 1];
                variables.addAll(Arrays.asList(addnull));
                variables.set(varIdx, value);
            } else {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return this.setEntry(variables.get(varIdx), varAddressParts.subList(2, varAddressParts.size()), value);
    }

    private boolean deleteEntry(Object container, List<Object> varAddress) {
        if (varAddress.size() > 1) {
            Object nextContainer = this.getEntry(container, varAddress.subList(0, varAddress.size() - 1), false);
            return this.deleteEntry(nextContainer, varAddress.subList(1, varAddress.size()));
        }
        Object varAddressPart = varAddress.get(0);
        if (container instanceof List) {
            List list;
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Number) || ((Number)varAddressPart).intValue() >= ((List)container).size()) {
                throw new IndexOutOfBoundsException();
            }
            int idx = ((Number)varAddressPart).intValue();
            if (idx < (list = (List)container).size()) {
                list.set(idx, null);
            }
            while (list.size() > 0 && list.get(list.size() - 1) == null) {
                list.remove(list.size() - 1);
            }
        } else if (container instanceof Map) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            ((Map)container).remove((String)varAddressPart);
        } else if (container instanceof String) {
            if (varAddressPart instanceof String && ((String)varAddressPart).matches("^\\d+$")) {
                varAddressPart = Integer.parseInt((String)varAddressPart);
            }
            if (!(varAddressPart instanceof Number)) {
                throw new IndexOutOfBoundsException();
            }
            int idx = ((Number)varAddressPart).intValue();
            container = ((String)container).substring(0, idx) + ((String)container).substring(idx + 1);
        } else if (container instanceof SandboxObject) {
            if (!(varAddressPart instanceof String)) {
                varAddressPart = varAddressPart.toString();
            }
            ((SandboxObject)container).set((String)varAddressPart, null);
        }
        return false;
    }

    public boolean deleteVariable(List<Object> varAddressParts) {
        return this.deleteVariable(varAddressParts, this.localVariablesStack.size() - 1);
    }

    public boolean deleteVariable(List<Object> varAddressParts, int stacklevel) {
        List<Object> variables = null;
        String part = (String)varAddressParts.get(0);
        if (part.equals("L")) {
            variables = this.localVariablesStack.get(stacklevel);
        } else if (part.equals("P")) {
            variables = this.parametersStack.get(stacklevel);
        } else if (part.equals("S")) {
            variables = this.persistentStorage;
        } else {
            throw new IndexOutOfBoundsException(varAddressParts.toString());
        }
        int varIdx = (Integer)varAddressParts.get(1);
        if (varAddressParts.size() <= 2) {
            if (varIdx < variables.size()) {
                variables.set(varIdx, null);
            }
            return true;
        }
        return this.deleteEntry(variables.get(varIdx), varAddressParts.subList(2, varAddressParts.size()));
    }

    public String currentFunctionName() {
        if (this.codeFunctionName.isEmpty()) {
            return null;
        }
        return this.codeFunctionName.get(this.codeFunctionName.size() - 1);
    }

    public List<String> getServiceCodeFunction() {
        return this.codeFunctionName;
    }

    public void setServiceCodeFunction(List<String> serviceCodeFunction) {
        this.codeFunctionName = serviceCodeFunction;
    }

    public int getCurrentServiceCodeLine() {
        if (this.codeLine.isEmpty()) {
            return -1;
        }
        return this.codeLine.get(this.codeLine.size() - 1);
    }

    public void setCurrentServiceCodeLine(int newline) {
        if (this.codeLine.isEmpty()) {
            return;
        }
        this.codeLine.set(this.codeLine.size() - 1, newline);
    }

    public void incrementCurrentServiceCodeLine() {
        this.incrementCurrentServiceCodeLine(1);
    }

    public void incrementCurrentServiceCodeLine(int addToLine) {
        if (this.codeLine.isEmpty()) {
            return;
        }
        int currentLine = this.codeLine.get(this.codeLine.size() - 1);
        this.codeLine.set(this.codeLine.size() - 1, currentLine + addToLine);
    }

    public List<Integer> getServiceCodeLine() {
        return this.codeLine;
    }

    public void setServiceCodeLine(List<Integer> serviceCodeLine) {
        this.codeLine = serviceCodeLine;
    }

    protected List<List<Object>> getLocalVariablesStack() {
        return this.localVariablesStack;
    }

    protected void setLocalVariablesStack(List<List<Object>> localVariablesStack) {
        this.localVariablesStack = localVariablesStack;
    }

    public int compareVariables(Object aObj, Object bObj, String commandID) {
        return this.compareVariables(aObj, bObj, commandID, true);
    }

    public int compareVariables(Object aObj, Object bObj, String commandID, boolean typeCheck) {
        if (aObj instanceof VarAddress) {
            aObj = this.getVariable((VarAddress)aObj, true);
        }
        if (bObj instanceof VarAddress) {
            bObj = this.getVariable((VarAddress)bObj, true);
        }
        int compare = -1;
        if (aObj instanceof Number && bObj instanceof Number) {
            if (aObj instanceof Integer) {
                aObj = new Long(((Number)aObj).longValue());
            }
            if (bObj instanceof Integer) {
                bObj = new Long(((Number)bObj).longValue());
            }
            if (aObj instanceof Float) {
                aObj = new Double(((Float)aObj).doubleValue());
            }
            if (bObj instanceof Float) {
                bObj = new Double(((Float)bObj).doubleValue());
            }
            if (aObj instanceof Double && bObj instanceof Long || aObj instanceof Long && bObj instanceof Double) {
                aObj = ((Number)aObj).doubleValue();
                bObj = ((Number)bObj).doubleValue();
            }
        }
        if (!(typeCheck || aObj != null && bObj != null)) {
            if (aObj == null && bObj == null) {
                return 0;
            }
            return -1;
        }
        if (!aObj.getClass().equals(bObj.getClass())) {
            if (!typeCheck) {
                return -1;
            }
            throw new IllegalArgumentException("command: " + commandID + " compare arguments not from the same type");
        }
        if (!(aObj instanceof Comparable)) {
            throw new IllegalArgumentException("command: " + commandID + " compare arguments from type '" + aObj.getClass().getName() + "' not impements the Comparable interface!");
        }
        compare = ((Comparable)aObj).compareTo(bObj);
        return compare;
    }

    public Object getFromInstanceDependencyStorage(String key) {
        return this.instanceDependencyStorage.get(key);
    }

    public Map<String, Object[]> getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(Map<String, Object[]> serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Object[] getServiceCodeFunction(String functionName) {
        if (!this.serviceCode.containsKey(functionName)) {
            return null;
        }
        return this.serviceCode.get(functionName);
    }

    public Object[] currentFunctionCode() {
        return this.getServiceCodeFunction(this.currentFunctionName());
    }

    public List<Object> getPersistentStorage() {
        return this.persistentStorage;
    }

    public void setPersistentStorage(List<Object> persistentStorage) {
        this.persistentStorage = persistentStorage;
    }

    public Object getThrownError() {
        return this.thrownError;
    }

    public void setThrownError(Object thrownError) {
        this.thrownError = thrownError;
    }

    public String saveStateToString() {
        ArrayList<List<Object>> savelist = new ArrayList<List<Object>>();
        savelist.add(this.codeFunctionName);
        savelist.add(this.codeLine);
        savelist.add(this.localVariablesStack);
        savelist.add(this.parametersStack);
        savelist.add(this.persistentStorage);
        Object replaced = this.replaceJSONAwares(savelist);
        return JSONValue.toJSONString(replaced);
    }

    public void loadStateFromString(String savedState) throws com.cloudrail.si.exceptions.ParseException {
        ArrayList savelist;
        try {
            savelist = (ArrayList)new JSONParser().parse(savedState, new ContainerFactory(){

                public Map createObjectContainer() {
                    return new TreeMap();
                }

                public List creatArrayContainer() {
                    return new ArrayList();
                }
            });
        }
        catch (ParseException e) {
            throw new com.cloudrail.si.exceptions.ParseException(e.getMessage());
        }
        savelist = (ArrayList)this.recreateJSONAwares(savelist);
        this.codeFunctionName = (List)savelist.get(0);
        this.codeLine = new ArrayList<Integer>();
        List jsonCodeLine = (List)savelist.get(1);
        for (int i = 0; i < jsonCodeLine.size(); ++i) {
            this.codeLine.add(((Long)jsonCodeLine.get(i)).intValue());
        }
        this.localVariablesStack = (List)savelist.get(2);
        List jsonParametersStack = (List)savelist.get(3);
        for (int i = 0; i < jsonParametersStack.size(); ++i) {
            if (i >= this.parametersStack.size()) {
                this.parametersStack.add((List<Object>)jsonParametersStack.get(i));
                continue;
            }
            this.parametersStack.set(i, (List<Object>)jsonParametersStack.get(i));
        }
        List jsonPersistentStorage = (List)savelist.get(4);
        for (int i = 0; i < jsonPersistentStorage.size(); ++i) {
            if (i >= this.persistentStorage.size()) {
                this.persistentStorage.add(jsonPersistentStorage.get(i));
                continue;
            }
            this.persistentStorage.set(i, jsonPersistentStorage.get(i));
        }
    }

    private Object replaceJSONAwares(Object obj) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            TreeMap newMap = new TreeMap();
            for (Map.Entry entry : m.entrySet()) {
                newMap.put(entry.getKey(), this.replaceJSONAwares(entry.getValue()));
            }
            return newMap;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object entry : l) {
                newList.add(this.replaceJSONAwares(entry));
            }
            return newList;
        }
        if (obj instanceof JSONAware) {
            JSONAware j = (JSONAware)obj;
            return JSON_AWARE_MARKER + obj.getClass().getSimpleName() + ":" + j.toJSONString();
        }
        if (obj instanceof InputStream) {
            return null;
        }
        return obj;
    }

    private Object recreateJSONAwares(Object obj) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            TreeMap newMap = new TreeMap();
            for (Map.Entry entry : m.entrySet()) {
                newMap.put(entry.getKey(), this.recreateJSONAwares(entry.getValue()));
            }
            return newMap;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object entry : l) {
                newList.add(this.recreateJSONAwares(entry));
            }
            return newList;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.startsWith(JSON_AWARE_MARKER)) {
                int start = JSON_AWARE_MARKER.length();
                String className = s.substring(start, s.indexOf(":"));
                String content = s.substring(s.indexOf(":") + 1);
                JSONAware j = null;
                try {
                    Class<?> typeClass = Class.forName("com.cloudrail.si.types." + className);
                    j = ((JSONAware)typeClass.newInstance()).fromJSONString(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return j;
            }
            return obj;
        }
        return obj;
    }
}

