/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.crypt.hmac;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.ArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha1
implements Command {
    public static final String COMMAND_ID = "crypt.hmac.sha1";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length == 3 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object keyObj = parameters[1];
        Object massageObj = parameters[2];
        if (keyObj instanceof VarAddress) {
            keyObj = environment.getVariable((VarAddress)keyObj);
        }
        if (!(keyObj instanceof String)) {
            throw new IllegalArgumentException("command: crypt.hmac.sha1 parameter key is not from type String!");
        }
        if (massageObj instanceof VarAddress) {
            massageObj = environment.getVariable((VarAddress)massageObj);
        }
        if (!(massageObj instanceof String)) {
            throw new IllegalArgumentException("command: crypt.hmac.sha1 parameter massage is not from type String!");
        }
        String key = (String)keyObj;
        String massage = (String)massageObj;
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        Mac hmac = Mac.getInstance("HmacSHA1");
        hmac.init(keySpec);
        byte[] resultBytes = hmac.doFinal(massage.getBytes());
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < resultBytes.length; ++i) {
            result.add(Long.valueOf(resultBytes[i] & 0xFF));
        }
        environment.setVariable(resultVar, result);
    }
}

