/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.json;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.ContainerFactory;
import com.cloudrail.si.servicecode.commands.json.jsonsimple.parser.JSONParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Parse
implements Command {
    public String getID() {
        return "json.parse";
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        Object obj;
        Object input;
        assert (parameters.length == 2 && parameters[0] instanceof VarAddress && (parameters[1] instanceof VarAddress || parameters[1] instanceof InputStream || parameters[1] instanceof String));
        VarAddress result = (VarAddress)parameters[0];
        if (parameters[1] instanceof VarAddress) {
            VarAddress inputAdd = (VarAddress)parameters[1];
            input = environment.getVariable(inputAdd);
            assert (input instanceof InputStream || input instanceof String);
        } else {
            input = parameters[1];
        }
        JSONParser parser = new JSONParser();
        if (input instanceof InputStream) {
            InputStream stream = (InputStream)input;
            obj = parser.parse((Reader)new InputStreamReader(stream), (ContainerFactory)new CloudRailContainerFactory());
            stream.close();
        } else {
            String string = (String)input;
            obj = parser.parse(string, (ContainerFactory)new CloudRailContainerFactory());
        }
        environment.setVariable(result, obj);
    }

    private class CloudRailContainerFactory
    implements ContainerFactory {
        private CloudRailContainerFactory() {
        }

        public Map createObjectContainer() {
            return new TreeMap();
        }

        public List creatArrayContainer() {
            return new ArrayList();
        }
    }
}

