/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.math;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.text.NumberFormat;
import java.util.Locale;

public class Add
implements Command {
    public static final String COMMAND_ID = "math.add";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        boolean isDouble = false;
        double doubleResult = 0.0;
        long longResult = 0L;
        for (int i = 1; i < parameters.length; ++i) {
            if (parameters[i] instanceof VarAddress) {
                parameters[i] = environment.getVariable((VarAddress)parameters[i]);
            }
            if (parameters[i] instanceof String) {
                parameters[i] = NumberFormat.getInstance(Locale.US).parse((String)parameters[i]);
            }
            if (!(parameters[i] instanceof Number)) {
                throw new IllegalArgumentException("command: math.add argument #" + i + " is not from type number!");
            }
            boolean bl = isDouble = isDouble || parameters[i] instanceof Double || parameters[i] instanceof Float;
            if (isDouble) {
                doubleResult += ((Number)parameters[i]).doubleValue();
                continue;
            }
            doubleResult = longResult += ((Number)parameters[i]).longValue();
        }
        if (isDouble) {
            environment.setVariable(resultVar, (Object)doubleResult);
        } else {
            environment.setVariable(resultVar, (Object)longResult);
        }
    }
}

