/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.stream;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeJoinedStream
implements Command {
    @Override
    public String getID() {
        return "stream.makeJoinedStream";
    }

    @Override
    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 3 && parameters[0] instanceof VarAddress);
        VarAddress resAddress = (VarAddress)parameters[0];
        Stack<InputStream> streams = new Stack<InputStream>();
        for (int i = parameters.length - 1; i > 0; --i) {
            InputStream parameter;
            assert (parameters[i] instanceof VarAddress || parameters[i] instanceof InputStream);
            if (parameters[i] instanceof VarAddress) {
                VarAddress streamAddress = (VarAddress)parameters[i];
                parameter = (InputStream)environment.getVariable(streamAddress);
            } else {
                parameter = (InputStream)parameters[i];
            }
            streams.push(parameter);
        }
        InputStream result = this.joinStreams(streams);
        environment.setVariable(resAddress, (Object)result);
    }

    private InputStream joinStreams(Stack<InputStream> streams) {
        if (streams.size() > 1) {
            return new SequenceInputStream(streams.pop(), this.joinStreams(streams));
        }
        return streams.pop();
    }
}

