/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.servicecode.commands.string;

import com.cloudrail.si.servicecode.Command;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.VarAddress;
import java.util.Arrays;
import java.util.Locale;

public class Format
implements Command {
    public static final String COMMAND_ID = "string.format";

    public String getID() {
        return COMMAND_ID;
    }

    public void execute(Sandbox environment, Object[] parameters) throws Exception {
        assert (parameters.length >= 2 && parameters[0] instanceof VarAddress);
        VarAddress resultVar = (VarAddress)parameters[0];
        Object formatObj = parameters[1];
        if (formatObj instanceof VarAddress) {
            formatObj = environment.getVariable((VarAddress)formatObj);
        }
        if (!(formatObj instanceof String)) {
            throw new IllegalArgumentException("command: string.format parameter format is not from type String!");
        }
        String format = (String)formatObj;
        for (int i = 2; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof VarAddress)) continue;
            parameters[i] = environment.getVariable((VarAddress)parameters[i]);
        }
        String result = String.format(Locale.US, format, Arrays.copyOfRange(parameters, 2, parameters.length));
        environment.setVariable(resultVar, (Object)result);
    }
}

