/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.CloudStorage;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.CloudMetaData;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.SpaceAllocation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box
implements CloudStorage {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("CloudStorage:getUserLogin", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.emailAddress"}});
            this.put("CloudStorage:getUserName", new Object[]{new Object[]{"callFunc", "User:about", "$P0"}, new Object[]{"set", "$P1", "$P0.userInfo.displayName"}});
            this.put("User:about", new Object[]{new Object[]{"if!=than", "$P0.userInfo", null, 4}, new Object[]{"create", "$L0", "Date"}, new Object[]{"math.add", "$L0", "$L0.Time", -1000}, new Object[]{"if>than", "$P0.userInfo.lastUpdate", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "User:aboutRequest", "$P0"}});
            this.put("User:aboutRequest", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://api.box.com/2.0/users/me"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2", "user about", 200}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"create", "$P0.userInfo", "Object"}, new Object[]{"create", "$L4", "Date"}, new Object[]{"set", "$P0.userInfo.lastUpdate", "$L4.Time"}, new Object[]{"set", "$P0.userInfo.emailAddress", "$L3.login"}, new Object[]{"set", "$P0.userInfo.displayName", "$L3.name"}});
            this.put("CloudStorage:download", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L3", "https://api.box.com/2.0/files/", "$L0.id", "/content"}, new Object[]{"set", "$L2.url", "$L3"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5", "download request", 200}, new Object[]{"set", "$P1", "$L5.responseBody"}});
            this.put("CloudStorage:upload", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkNull", "$P0", "$P2"}, new Object[]{"callFunc", "checkPositive", "$P0", "$P3"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if!=than", "$P4", 0, 4}, new Object[]{"callFunc", "resolvePath", "$P0", "$L20", "$P1", 1}, new Object[]{"if!=than", "$L20", null, 2}, new Object[]{"callFunc", "uploadOverwrite", "$P0", "$P1", "$P2", "$L20"}, new Object[]{"return"}, new Object[]{"string.lastIndexOf", "$L0", "$P1", "/"}, new Object[]{"math.add", "$L1", "$L0", 1}, new Object[]{"string.substring", "$L2", "$P1", "$L1"}, new Object[]{"string.substring", "$L3", "$P1", 0, "$L0"}, new Object[]{"if==than", "$L3", "", 1}, new Object[]{"set", "$L3", "/"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L4", "$L3"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.name", "$L2"}, new Object[]{"create", "$L5.parent", "Object"}, new Object[]{"set", "$L5.parent.id", "$L4.id"}, new Object[]{"json.stringify", "$L6", "$L5"}, new Object[]{"string.lastIndexOf", "$L7", "$L2", "."}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"string.substring", "$L7", "$L2", "$L7"}, new Object[]{"set", "$L14", "$L7"}, new Object[]{"getMimeType", "$L7", "$L7"}, new Object[]{"if==than", "$L7", null, 2}, new Object[]{"debug.out", "No MIME type could be guessed for file extension '", "$L14", "', using 'application/octet-stream' as default"}, new Object[]{"set", "$L7", "application/octet-stream"}, new Object[]{"set", "$L8", "72365asfa72138jas5685oksco05"}, new Object[]{"string.concat", "$L9", "--", "$L8", "\r\n", "Content-Disposition: form-data; name=\"attributes\"", "\r\n\r\n", "$L6", "\r\n", "--", "$L8", "\r\n", "Content-Disposition: form-data; name=\"file\"; filename=\"someName\"", "\r\n", "Content-Type: ", "$L7", "\r\n\r\n"}, new Object[]{"string.concat", "$L10", "\r\n--", "$L8", "--\r\n"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"stream.stringToStream", "$L10", "$L10"}, new Object[]{"stream.makeJoinedStream", "$L11", "$L9", "$P2", "$L10"}, new Object[]{"create", "$L12", "Object"}, new Object[]{"set", "$L12.url", "https://upload.box.com/api/2.0/files/content"}, new Object[]{"set", "$L12.method", "POST"}, new Object[]{"set", "$L12.requestBody", "$L11"}, new Object[]{"create", "$L12.requestHeaders", "Object"}, new Object[]{"string.concat", "$L12.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"string.concat", "$L12.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$L8"}, new Object[]{"http.requestCall", "$L13", "$L12"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L13", "upload request", 201}});
            this.put("uploadOverwrite", new Object[]{new Object[]{"string.lastIndexOf", "$L0", "$P1", "/"}, new Object[]{"math.add", "$L1", "$L0", 1}, new Object[]{"string.substring", "$L2", "$P1", "$L1"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"json.stringify", "$L6", "$L5"}, new Object[]{"string.lastIndexOf", "$L7", "$L2", "."}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"string.substring", "$L7", "$L2", "$L7"}, new Object[]{"set", "$L14", "$L7"}, new Object[]{"getMimeType", "$L7", "$L7"}, new Object[]{"if==than", "$L7", null, 2}, new Object[]{"debug.out", "No MIME type could be guessed for file extension '", "$L14", "', using 'application/octet-stream' as default"}, new Object[]{"set", "$L7", "application/octet-stream"}, new Object[]{"set", "$L8", "72365asfa72138jas5685oksco05"}, new Object[]{"string.concat", "$L9", "--", "$L8", "\r\n", "Content-Disposition: form-data; name=\"attributes\"", "\r\n\r\n", "$L6", "\r\n", "--", "$L8", "\r\n", "Content-Disposition: form-data; name=\"file\"; filename=\"someName\"", "\r\n", "Content-Type: ", "$L7", "\r\n\r\n"}, new Object[]{"string.concat", "$L10", "\r\n--", "$L8", "--\r\n"}, new Object[]{"stream.stringToStream", "$L9", "$L9"}, new Object[]{"stream.stringToStream", "$L10", "$L10"}, new Object[]{"stream.makeJoinedStream", "$L11", "$L9", "$P2", "$L10"}, new Object[]{"create", "$L12", "Object"}, new Object[]{"string.concat", "$L12.url", "https://upload.box.com/api/2.0/files/", "$P3.id", "/content"}, new Object[]{"set", "$L12.method", "POST"}, new Object[]{"set", "$L12.requestBody", "$L11"}, new Object[]{"create", "$L12.requestHeaders", "Object"}, new Object[]{"string.concat", "$L12.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"string.concat", "$L12.requestHeaders.Content-Type", "multipart/form-data; boundary=", "$L8"}, new Object[]{"http.requestCall", "$L13", "$L12"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L13", "upload request", 200}});
            this.put("CloudStorage:move", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2", 1}, new Object[]{"if!=than", "$L0", null, 2}, new Object[]{"create", "$L0", "Error", "Destination already exists.", "Http"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P1"}, new Object[]{"string.lastIndexOf", "$L1", "$P2", "/"}, new Object[]{"math.add", "$L2", "$L1", 1}, new Object[]{"string.substring", "$L3", "$P2", "$L2"}, new Object[]{"string.substring", "$L4", "$P2", 0, "$L1"}, new Object[]{"if==than", "$L4", "", 1}, new Object[]{"set", "$L4", "/"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L5", "$L4"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"string.concat", "$L6.url", "https://api.box.com/2.0/", "$L0.type", "s/", "$L0.id"}, new Object[]{"set", "$L6.method", "PUT"}, new Object[]{"create", "$L6.requestHeaders", "Object"}, new Object[]{"string.concat", "$L6.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.name", "$L3"}, new Object[]{"create", "$L7.parent", "Object"}, new Object[]{"set", "$L7.parent.id", "$L5.id"}, new Object[]{"json.stringify", "$L7", "$L7"}, new Object[]{"stream.stringToStream", "$L6.requestBody", "$L7"}, new Object[]{"http.requestCall", "$L8", "$L6"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L8", "move request", 204}});
            this.put("CloudStorage:delete", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P1"}, new Object[]{"if==than", "$L0.type", "file", 2}, new Object[]{"string.concat", "$L1", "https://api.box.com/2.0/files/", "$L0.id"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L1", "https://api.box.com/2.0/folders/", "$L0.id", "?recursive=true"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "$L1"}, new Object[]{"set", "$L2.method", "DELETE"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L3", "delete request", 204}});
            this.put("CloudStorage:copy", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P1"}, new Object[]{"string.lastIndexOf", "$L1", "$P2", "/"}, new Object[]{"math.add", "$L2", "$L1", 1}, new Object[]{"string.substring", "$L3", "$P2", "$L2"}, new Object[]{"string.substring", "$L4", "$P2", 0, "$L1"}, new Object[]{"if==than", "$L4", "", 1}, new Object[]{"set", "$L4", "/"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L5", "$L4"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"string.concat", "$L6.url", "https://api.box.com/2.0/", "$L0.type", "s/", "$L0.id", "/copy"}, new Object[]{"set", "$L6.method", "POST"}, new Object[]{"create", "$L6.requestHeaders", "Object"}, new Object[]{"string.concat", "$L6.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.name", "$L3"}, new Object[]{"create", "$L7.parent", "Object"}, new Object[]{"set", "$L7.parent.id", "$L5.id"}, new Object[]{"json.stringify", "$L7", "$L7"}, new Object[]{"stream.stringToStream", "$L6.requestBody", "$L7"}, new Object[]{"http.requestCall", "$L8", "$L6"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L8", "copy request", 201}});
            this.put("CloudStorage:createFolder", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P1"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"string.lastIndexOf", "$L1", "$P1", "/"}, new Object[]{"math.add", "$L2", "$L1", 1}, new Object[]{"string.substring", "$L3", "$P1", "$L2"}, new Object[]{"string.substring", "$L4", "$P1", 0, "$L1"}, new Object[]{"if==than", "$L4", "", 1}, new Object[]{"set", "$L4", "/"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L5", "$L4"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"set", "$L6.url", "https://api.box.com/2.0/folders"}, new Object[]{"set", "$L6.method", "POST"}, new Object[]{"create", "$L6.requestHeaders", "Object"}, new Object[]{"string.concat", "$L6.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"set", "$L7.name", "$L3"}, new Object[]{"create", "$L7.parent", "Object"}, new Object[]{"set", "$L7.parent.id", "$L5.id"}, new Object[]{"json.stringify", "$L7", "$L7"}, new Object[]{"stream.stringToStream", "$L6.requestBody", "$L7"}, new Object[]{"http.requestCall", "$L8", "$L6"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L8", "create folder request", 201}});
            this.put("CloudStorage:getMetadata", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Root does not have MetaData", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L3", "https://api.box.com/2.0/", "$L0.type", "s/", "$L0.id"}, new Object[]{"set", "$L2.url", "$L3"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5", "metadata retrieval", 200}, new Object[]{"json.parse", "$L4", "$L5.responseBody"}, new Object[]{"string.lastIndexOf", "$L6", "$P2", "/"}, new Object[]{"string.substring", "$L7", "$P2", 0, "$L6"}, new Object[]{"callFunc", "makeMeta", "$P0", "$P1", "$L4", "$L7"}});
            this.put("CloudStorage:getChildren", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L3", "https://api.box.com/2.0/folders/", "$L0.id", "/items?fields=name,size,type,modified_at"}, new Object[]{"set", "$L2.url", "$L3"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5", "children metadata retrieval", 200}, new Object[]{"json.parse", "$L4", "$L5.responseBody"}, new Object[]{"size", "$L6", "$L4.entries"}, new Object[]{"set", "$L7", 0}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if<than", "$L7", "$L6", 5}, new Object[]{"get", "$L8", "$L4.entries", "$L7"}, new Object[]{"callFunc", "makeMeta", "$P0", "$L9", "$L8", "$P2"}, new Object[]{"push", "$P1", "$L9"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -6}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"if==than", "$S0.access_token", null, 1}, new Object[]{"return"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.url", "https://api.box.com/oauth2/revoke"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L1", "client_id=", "$P0.clientId", "&client_secret=", "$P0.clientSecret", "&token=", "$S0.access_token"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L1"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2", "token revokation", 200}, new Object[]{"set", "$S0.access_token", null}});
            this.put("getAllocation", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L0.url", "https://api.box.com/2.0/users/me"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2", "user about", 200}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"create", "$L6", "SpaceAllocation"}, new Object[]{"set", "$L6.total", "$L3.space_amount"}, new Object[]{"set", "$L6.used", "$L3.space_used"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("createShareLink", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Cannot share root", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2"}, new Object[]{"create", "$L7", "Object"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"set", "$L7.shared_link", "$L8"}, new Object[]{"json.stringify", "$L7", "$L7"}, new Object[]{"stream.stringToStream", "$L7", "$L7"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L3", "https://api.box.com/2.0/", "$L0.type", "s/", "$L0.id"}, new Object[]{"set", "$L2.url", "$L3"}, new Object[]{"set", "$L2.method", "PUT"}, new Object[]{"set", "$L2.requestBody", "$L7"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5", "metadata retrieval", 200}, new Object[]{"json.parse", "$L4", "$L5.responseBody"}, new Object[]{"set", "$P1", "$L4.shared_link.url"}});
            this.put("exists", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"if==than", "$P2", "/", 2}, new Object[]{"create", "$L2", "Error", "Root does not have MetaData", "IllegalArgument"}, new Object[]{"throwError", "$L2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2", 1}, new Object[]{"if==than", "$L0", null, 2}, new Object[]{"set", "$P1", 0}, new Object[]{"return"}, new Object[]{"set", "$P1", 1}});
            this.put("getThumbnail", new Object[]{new Object[]{"callFunc", "validatePath", "$P0", "$P2"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"callFunc", "resolvePath", "$P0", "$L0", "$P2"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"string.concat", "$L1.url", "https://api.box.com/2.0/files/", "$L0.id", "/thumbnail.jpg?min_height=128&min_width=128"}, new Object[]{"set", "$L1.method", "GET"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L2.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"set", "$L1.requestHeaders", "$L2"}, new Object[]{"http.requestCall", "$L3", "$L1"}, new Object[]{"if==than", "$L3.code", 404, 1}, new Object[]{"return"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L3", "get thumbnail", 200}, new Object[]{"set", "$P1", "$L3.responseBody"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.access_token", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "$P1", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expires_in"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "$P1", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L2", "String"}, new Object[]{"if==than", "$P2", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://account.box.com/api/oauth2/authorize?response_type=code&client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&state=", "$P0.state"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&client_secret=", "$P0.clientSecret", "&refresh_token=", "$S0.refresh_token", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://api.box.com/oauth2/token"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"if==than", "$P2", "accessToken", 2}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L6", "authentication", 200}, new Object[]{"jumpRel", 3}, new Object[]{"if>=than", "$L6.code", 400, 2}, new Object[]{"callFunc", "authenticate", "$P0", "$P1", "accessToken"}, new Object[]{"return"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.access_token", "$L8.access_token"}, new Object[]{"set", "$S0.refresh_token", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expires_in", "$L9"}});
            this.put("resolvePath", new Object[]{new Object[]{"if==than", "$P2", "/", 4}, new Object[]{"create", "$P1", "Object"}, new Object[]{"set", "$P1.id", "0"}, new Object[]{"set", "$P1.type", "folder"}, new Object[]{"return"}, new Object[]{"string.substring", "$L0", "$P2", 1}, new Object[]{"callFunc", "resolvePathRelative", "$P0", "$P1", "$L0", "0", "$P3"}});
            this.put("resolvePathRelative", new Object[]{new Object[]{"string.indexOf", "$L0", "$P2", "/"}, new Object[]{"if!=than", "$L0", -1, 2}, new Object[]{"string.substring", "$L1", "$P2", 0, "$L0"}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$L1", "$P2"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"string.concat", "$L3", "https://api.box.com/2.0/folders/", "$P3", "/items?fields=name"}, new Object[]{"set", "$L2.url", "$L3"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.access_token"}, new Object[]{"http.requestCall", "$L5", "$L2"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5", "path resolving", 200}, new Object[]{"json.parse", "$L4", "$L5.responseBody"}, new Object[]{"callFunc", "searchEntry", "$P0", "$L6", "$L4.entries", "$L1"}, new Object[]{"if==than", "$L6", null, 5}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"return"}, new Object[]{"create", "$L9", "Error", "Path does not point to an existing element", "NotFound"}, new Object[]{"throwError", "$L9"}, new Object[]{"if==than", "$L0", -1, 2}, new Object[]{"set", "$P1", "$L6"}, new Object[]{"return"}, new Object[]{"math.add", "$L7", "$L0", 1}, new Object[]{"string.substring", "$L8", "$P2", "$L7"}, new Object[]{"callFunc", "resolvePathRelative", "$P0", "$P1", "$L8", "$L6.id", "$P4"}});
            this.put("searchEntry", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"set", "$L1", 0}, new Object[]{"if<than", "$L1", "$L0", 8}, new Object[]{"get", "$L2", "$P2", "$L1"}, new Object[]{"if==than", "$L2.name", "$P3", 4}, new Object[]{"create", "$P1", "Object"}, new Object[]{"set", "$P1.id", "$L2.id"}, new Object[]{"set", "$P1.type", "$L2.type"}, new Object[]{"return"}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -9}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if!=than", "$P1.code", "$P3", 20}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
            this.put("makeMeta", new Object[]{new Object[]{"create", "$P1", "CloudMetaData"}, new Object[]{"set", "$P1.name", "$P2.name"}, new Object[]{"if!=than", "$P2.modified_at", null, 1}, new Object[]{"callFunc", "extractTimeWithTimezone", "$P0", "$P1.modifiedAt", "$P2.modified_at"}, new Object[]{"if==than", "$P2.type", "folder", 2}, new Object[]{"set", "$P1.folder", 1}, new Object[]{"jumpRel", 2}, new Object[]{"set", "$P1.folder", 0}, new Object[]{"set", "$P1.size", "$P2.size"}, new Object[]{"if==than", "$P3", "/", 2}, new Object[]{"string.concat", "$P1.path", "$P3", "$P2.name"}, new Object[]{"return"}, new Object[]{"string.concat", "$P1.path", "$P3", "/", "$P2.name"}});
            this.put("extractTimeWithTimezone", new Object[]{new Object[]{"set", "$L0", "$P2"}, new Object[]{"string.split", "$L1", "$L0", "\\+"}, new Object[]{"size", "$L2", "$L1"}, new Object[]{"if==than", "$L2", 2, 10}, new Object[]{"get", "$L3", "$L1", 1}, new Object[]{"string.slit", "$L4", "$L3", ":"}, new Object[]{"get", "$L5", "$l4", 0}, new Object[]{"get", "$L10", "$L1", 0}, new Object[]{"string.concat", "$L10", "$L10", "Z"}, new Object[]{"create", "$L11", "Date", "$L10"}, new Object[]{"set", "$L12", "$L11.time"}, new Object[]{"math.multiply", "$L13", "$L5", 3600000}, new Object[]{"math.add", "$P1", "$L12", "$L13"}, new Object[]{"return"}, new Object[]{"get", "$L3", "$L1", 0}, new Object[]{"string.split", "$L4", "$L3", "-"}, new Object[]{"size", "$L5", "$L4"}, new Object[]{"math.add", "$L6", "$L5", -1}, new Object[]{"get", "$L7", "$L4", "$L6"}, new Object[]{"string.split", "$L8", "$L7", ":"}, new Object[]{"get", "$L9", "$L8", 0}, new Object[]{"math.multiply", "$L10", "$L9", -3600000}, new Object[]{"create", "$L11", "Number", 0}, new Object[]{"create", "$L12", "String"}, new Object[]{"math.add", "$L20", "$L6", -1}, new Object[]{"if<than", "$L11", "$L6", 6}, new Object[]{"get", "$L13", "$L4", "$L11"}, new Object[]{"string.concat", "$L12", "$L12", "$L13"}, new Object[]{"if!=than", "$L11", "$L20", 1}, new Object[]{"string.concat", "$L12", "$L12", "-"}, new Object[]{"math.add", "$L11", "$L11", 1}, new Object[]{"jumpRel", -7}, new Object[]{"string.concat", "$L12", "$L12", "Z"}, new Object[]{"create", "$L14", "Date", "$L12"}, new Object[]{"set", "$L15", "$L14.time"}, new Object[]{"math.add", "$P1", "$L15", "$L10"}});
            this.put("validatePath", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Path shouldn't be null", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L0", "String"}, new Object[]{"string.substr", "$L0", "$P1", 0, 1}, new Object[]{"if!=than", "$L0", "/", 2}, new Object[]{"create", "$L0", "Error", "Path should start with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"create", "$L1", "Number"}, new Object[]{"size", "$L1", "$P1"}, new Object[]{"math.add", "$L1", "$L1", -1}, new Object[]{"if!=than", "$L1", 0, 5}, new Object[]{"create", "$L2", "String"}, new Object[]{"string.substr", "$L2", "$P1", "$L1", 1}, new Object[]{"if==than", "$L2", "/", 2}, new Object[]{"create", "$L3", "Error", "Path should not end with '/'.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "Passed argument is null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkPositive", new Object[]{new Object[]{"if<than", "$P1", 0, 2}, new Object[]{"create", "$L0", "Error", "Passed argument should be bigger than 0.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Box(RedirectReceiver redirectReceiver, String clientId, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Box").start();
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public InputStream download(String filePath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "download").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:download", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "download").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void upload(String filePath, InputStream stream, long size, boolean overwrite) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "upload").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:upload", this.interpreterStorage, filePath, stream, size, overwrite ? 1L : 0L);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "upload").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void move(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "move").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:move", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "move").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void delete(String filePath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "delete").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:delete", this.interpreterStorage, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "delete").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void copy(String sourcePath, String destinationPath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "copy").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:copy", this.interpreterStorage, sourcePath, destinationPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "copy").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void createFolder(String folderPath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "createFolder").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:createFolder", this.interpreterStorage, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "createFolder").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public CloudMetaData getMetadata(String filePath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getMetadata").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getMetadata", this.interpreterStorage, null, filePath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getMetadata").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (CloudMetaData)ip.getParameter(1);
    }

    @Override
    public List<CloudMetaData> getChildren(String folderPath) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getChildren").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getChildren", this.interpreterStorage, null, folderPath);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getChildren").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String getUserLogin() {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getUserLogin").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserLogin", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getUserLogin").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getUserName() {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getUserName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("CloudStorage:getUserName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getUserName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String createShareLink(String path) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "createShareLink").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createShareLink", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "createShareLink").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public SpaceAllocation getAllocation() {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getAllocation").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getAllocation", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getAllocation").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SpaceAllocation)ip.getParameter(1);
    }

    @Override
    public boolean exists(String path) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "exists").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("exists", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "exists").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return !ip.getParameter(1).equals(0);
    }

    @Override
    public InputStream getThumbnail(String path) {
        CloudRail.validateKey();
        new ReportCallTask("Box", "getThumbnail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getThumbnail", this.interpreterStorage, null, path);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "getThumbnail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (InputStream)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        new ReportCallTask("Box", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        new ReportCallTask("Box", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Box", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    @Override
    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

