/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.interfaces.Social;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Facebook
implements Profile,
Social {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("Social:postUpdate", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "The content is not allowed to be null.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L3", "String"}, new Object[]{"string.urlEncode", "$L3", "$P1"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "https://graph.facebook.com/v2.6/me/feed?message=", "$L3"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}});
            this.put("Social:getConnections", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "https://graph.facebook.com/v2.6/me/friends"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}, new Object[]{"create", "$L3", "String"}, new Object[]{"stream.streamToString", "$L3", "$L2.responseBody"}, new Object[]{"json.parse", "$L4", "$L3"}, new Object[]{"create", "$L9", "Number"}, new Object[]{"size", "$L9", "$L4.data"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"if!=than", "$L9", 0, 11}, new Object[]{"set", "$L5", "$L4.data.items"}, new Object[]{"create", "$L6", "Number"}, new Object[]{"size", "$L6", "$L5"}, new Object[]{"create", "$L7", "Number", 0}, new Object[]{"if<than", "$L7", "$L6", 6}, new Object[]{"create", "$L8", "Object"}, new Object[]{"get", "$L8", "$L5", "$L7"}, new Object[]{"string.concat", "$L9", "facebook-", "$L8.id"}, new Object[]{"push", "$P1", "$L9"}, new Object[]{"math.add", "$L7", "$L7", 1}, new Object[]{"jumpRel", -7}});
            this.put("Authenticating:login", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}});
            this.put("Authenticating:logout", new Object[]{new Object[]{"set", "$P0.userInfo", null}, new Object[]{"if!=than", "$S0.accessToken", null, 10}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L1", "https://graph.facebook.com/v2.6/me/permissions"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L2"}});
            this.put("Profile:getIdentifier", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"string.concat", "$P1", "facebook-", "$P0.userInfo.id"}});
            this.put("Profile:getFullName", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.name", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.name"}});
            this.put("Profile:getEmail", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.email", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.email"}});
            this.put("Profile:getGender", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.gender", null, 7}, new Object[]{"if==than", "$P0.userInfo.gender", "male", 2}, new Object[]{"set", "$P1", "$P0.userInfo.gender"}, new Object[]{"return"}, new Object[]{"if==than", "$P0.userInfo.gender", "female", 2}, new Object[]{"set", "$P1", "$P0.userInfo.gender"}, new Object[]{"return"}, new Object[]{"set", "$P1", "other"}});
            this.put("Profile:getDescription", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.bio", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.bio"}});
            this.put("Profile:getDateOfBirth", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"create", "$P1", "DateOfBirth"}, new Object[]{"if!=than", "$P0.userInfo.birthday", null, 10}, new Object[]{"string.split", "$L0", "$P0.userInfo.birthday", "/"}, new Object[]{"get", "$L1", "$L0", 0}, new Object[]{"if!=than", "$L1", "00", 1}, new Object[]{"math.add", "$P1.month", "$L1", 0}, new Object[]{"get", "$L1", "$L0", 1}, new Object[]{"if!=than", "$L1", "00", 1}, new Object[]{"math.add", "$P1.day", "$L1", 0}, new Object[]{"get", "$L1", "$L0", 2}, new Object[]{"if!=than", "$L1", "0000", 1}, new Object[]{"math.add", "$P1.year", "$L1", 0}});
            this.put("Profile:getLocale", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.locale", null, 3}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.substring", "$L1", "$P0.userInfo.locale", 0, 2}, new Object[]{"set", "$P1", "$L1"}});
            this.put("Profile:getPictureURL", new Object[]{new Object[]{"callFunc", "checkUserInfo", "$P0"}, new Object[]{"if!=than", "$P0.userInfo.picture.data.url", null, 1}, new Object[]{"set", "$P1", "$P0.userInfo.picture.data.url"}});
            this.put("checkUserInfo", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if!=than", "$P0.userInfo", null, 2}, new Object[]{"if>than", "$P0.expirationTime", "$L0", 1}, new Object[]{"return"}, new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://graph.facebook.com/v2.5/me?fields=locale,gender,name,birthday,email,bio"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$P0.userInfo", "$L3.responseBody"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.url", "https://graph.facebook.com/v2.6/me/picture?fields=url&type=large&redirect=false"}, new Object[]{"create", "$L2.requestHeaders", "Object"}, new Object[]{"string.concat", "$L2.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L2.method", "GET"}, new Object[]{"http.requestCall", "$L3", "$L2"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L3"}, new Object[]{"json.parse", "$L4", "$L3.responseBody"}, new Object[]{"set", "$P0.userInfo.picture", "$L4"}, new Object[]{"create", "$P0.expirationTime", "Date"}, new Object[]{"math.add", "$P0.expirationTime.time", "$P0.expirationTime.time", 60000}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0"}});
            this.put("authenticate", new Object[]{new Object[]{"create", "$L0", "String"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.urlEncode", "$L3", "$P0.redirectUri"}, new Object[]{"string.concat", "$L0", "https://www.facebook.com/dialog/oauth?response_type=code&client_id=", "$P0.clientID", "&redirect_uri=", "$L3", "&state=", "$P0.state", "&scope=public_profile%2Cemail%2Cuser_birthday%2Cuser_about_me%2Cpublish_actions%2Cuser_friends"}, new Object[]{"awaitCodeRedirect", "$L2", "$L0"}, new Object[]{"string.concat", "$L1", "https://graph.facebook.com/v2.3/oauth/access_token?client_id=", "$P0.clientID", "&redirect_uri=", "$L3", "&client_secret=", "$P0.clientSecret", "&code=", "$L2"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "$L1"}, new Object[]{"set", "$L5.method", "GET"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 13}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L2", "$L0.error_user_msg"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "$L2", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Facebook(RedirectReceiver redirectReceiver, String clientID, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Facebook").start();
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public String getIdentifier() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getIdentifier").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getIdentifier").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getFullName() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getFullName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getFullName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getEmail() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getGender() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getGender").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getGender").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getDescription() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getDescription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getDescription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public DateOfBirth getDateOfBirth() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getDateOfBirth").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getDateOfBirth").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    @Override
    public String getLocale() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getLocale").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getLocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getLocale").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public String getPictureURL() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getPictureURL").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Profile:getPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getPictureURL").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    @Override
    public void login() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:login", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void logout() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Authenticating:logout", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public void postUpdate(String content) {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "postUpdate").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:postUpdate", this.interpreterStorage, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "postUpdate").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    @Override
    public List<String> getConnections() {
        CloudRail.validateKey();
        new ReportCallTask("Facebook", "getConnections").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("Social:getConnections", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Facebook", "getConnections").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    @Override
    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    @Override
    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

