/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Email;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailJet
implements Email {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("sendMJEMail", new Object[]{new Object[]{"callFunc", "validateParameters", "$P0", "$P1", "$P2", "$P3", "$P4", "$P5", "$P6"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"set", "$L1.url", "https://api.mailjet.com/v3/send"}, new Object[]{"set", "$L1.method", "POST"}, new Object[]{"create", "$L1.requestHeaders", "Object"}, new Object[]{"set", "$L1.requestHeaders.Content-Type", "application/json"}, new Object[]{"create", "$L7", "String"}, new Object[]{"string.concat", "$L7", "$P0.clientID", ":", "$P0.clientSecret"}, new Object[]{"string.base64encode", "$L7", "$L7"}, new Object[]{"string.concat", "$L1.requestHeaders.Authorization", "Basic ", "$L7"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"set", "$L2.FromEmail", "$P1"}, new Object[]{"set", "$L2.FromName", "$P2"}, new Object[]{"create", "$L3", "Array"}, new Object[]{"set", "$L3", "$P3"}, new Object[]{"callFunc", "processAddresses", "$P0", "$L20", "$L3"}, new Object[]{"set", "$L2.To", "$L20"}, new Object[]{"set", "$L2.Subject", "$P4"}, new Object[]{"if!=than", "$P5", null, 1}, new Object[]{"set", "$L2.Text-part", "$P5"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"set", "$L2.Html-part", "$P6"}, new Object[]{"create", "$L4", "Array"}, new Object[]{"set", "$L4", "$P7"}, new Object[]{"if==than", "$L4", null, 1}, new Object[]{"set", "$L2.Cc", null}, new Object[]{"if!=than", "$L4", null, 2}, new Object[]{"callFunc", "processAddresses", "$P0", "$L21", "$L4"}, new Object[]{"set", "$L2.Cc", "$L21"}, new Object[]{"create", "$L5", "Array"}, new Object[]{"set", "$L5", "$P8"}, new Object[]{"if==than", "$L5", null, 1}, new Object[]{"set", "$L2.Bcc", null}, new Object[]{"if!=than", "$L5", null, 2}, new Object[]{"callFunc", "processAddresses", "$P0", "$L23", "$L5"}, new Object[]{"set", "$L2.Bcc", "$L23"}, new Object[]{"json.stringify", "$L6", "$L2"}, new Object[]{"debug.out", "JSON Body: ", "$L6"}, new Object[]{"stream.stringToStream", "$L1.requestBody", "$L6"}, new Object[]{"create", "$L8", "Object"}, new Object[]{"http.requestCall", "$L8", "$L1"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L8"}, new Object[]{"create", "$L9", "String"}, new Object[]{"stream.streamToString", "$L9", "$L8.responseBody"}, new Object[]{"debug.out", "$L9"}});
            this.put("buildRequestObject", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0", "application/json", "Content-Type"}, new Object[]{"create", "$P1", "Object"}, new Object[]{"set", "$P1.url", "https://api.mailjet.com/v3/send"}, new Object[]{"set", "$P1.method", "POST"}, new Object[]{"set", "$P1.requestHeaders", "$L0"}});
            this.put("processAddresses", new Object[]{new Object[]{"create", "$L0", "Number"}, new Object[]{"size", "$L0", "$P2"}, new Object[]{"create", "$L1", "Number", 0}, new Object[]{"create", "$L2", "String", ""}, new Object[]{"if<than", "$L1", "$L0", 5}, new Object[]{"create", "$L3", "String"}, new Object[]{"get", "$L3", "$P2", "$L1"}, new Object[]{"string.concat", "$L2", "$L2", "$L3", ","}, new Object[]{"math.add", "$L1", "$L1", 1}, new Object[]{"jumpRel", -6}, new Object[]{"size", "$L4", "$L2"}, new Object[]{"if!=than", "$L4", 0, 2}, new Object[]{"math.add", "$L4", "$L4", -1}, new Object[]{"string.substr", "$L2", "$L2", 0, "$L4"}, new Object[]{"set", "$P1", "$L2"}});
            this.put("validateParameters", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L0", "Error", "A valid sender address has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L0", "Error", "A sender name has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P3", null, 2}, new Object[]{"create", "$L0", "Error", "At least one address of a recipient has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P4", null, 2}, new Object[]{"create", "$L0", "Error", "A subject has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P5", null, 6}, new Object[]{"if==than", "$P6", null, 2}, new Object[]{"create", "$L0", "Error", "Either textBody or htmlBody has to be set (or both).", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P6", "", 2}, new Object[]{"create", "$L0", "Error", "Either textBody or htmlBody has to be set (or both).", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P5", "", 6}, new Object[]{"if==than", "$P6", null, 2}, new Object[]{"create", "$L0", "Error", "Either textBody or htmlBody has to be set (or both).", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P6", "", 2}, new Object[]{"create", "$L0", "Error", "Either textBody or htmlBody has to be set (or both).", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P1", "", 2}, new Object[]{"create", "$L0", "Error", "A valid sender address has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P2", "", 2}, new Object[]{"create", "$L0", "Error", "A sender name has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"if==than", "$P4", "", 2}, new Object[]{"create", "$L0", "Error", "A subject has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}, new Object[]{"size", "$L1", "$P3"}, new Object[]{"if==than", "$L1", 0, 2}, new Object[]{"create", "$L0", "Error", "At least one address of a recipient has to be provided.", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 9}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public MailJet(RedirectReceiver redirectReceiver, String clientID, String clientSecret) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("MailJet").start();
        this.interpreterStorage.put("clientID", clientID);
        this.interpreterStorage.put("clientSecret", clientSecret);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public void sendEmail(String fromAddress, String fromName, List<String> toAddresses, String subject, String textBody, String htmlBody, List<String> ccAddresses, List<String> bccAddresses) {
        CloudRail.validateKey();
        new ReportCallTask("MailJet", "sendEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendMJEMail", this.interpreterStorage, fromAddress, fromName, toAddresses, subject, textBody, htmlBody, ccAddresses, bccAddresses);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("MailJet", "sendEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

