/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Payment;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.Charge;
import com.cloudrail.si.types.CreditCard;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.Refund;
import com.cloudrail.si.types.Subscription;
import com.cloudrail.si.types.SubscriptionPlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stripe
implements Payment {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("createCharge", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P2", "Amount"}, new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P3", "Currency"}, new Object[]{"callFunc", "checkCurrency", "$P0", "$P3"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Credit Card"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"callFunc", "createSource", "$P0", "$L2", "$P4"}, new Object[]{"string.concat", "$L0.requestBody", "amount=", "$P2", "&currency=", "$P3", "&", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/charges"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L3.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveCharge", "$P0", "$P1", "$L5"}});
            this.put("getCharge", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Identifier"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L1", "https://api.stripe.com/v1/charges/", "$P2"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveCharge", "$P0", "$P1", "$L5"}});
            this.put("listCharges", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "From"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "To"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P2", "From"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "To"}, new Object[]{"callFunc", "checkGreaterEqualThan", "$P0", "$P2", "$P3", "From", "To"}, new Object[]{"create", "$L20", "Date"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P3", "$L20.time", "To", "Current Date"}, new Object[]{"create", "$L6", "Array"}, new Object[]{"callFunc", "getListCharges", "$P0", "$L6", "$P2", "$P3", null}, new Object[]{"size", "$L7", "$L6"}, new Object[]{"create", "$L8", "Number", 0}, new Object[]{"create", "$L9", "Array"}, new Object[]{"create", "$L10", "Number", 0}, new Object[]{"if<than", "$L8", "$L7", 9}, new Object[]{"get", "$L11", "$L6", "$L8"}, new Object[]{"callFunc", "retrieveCharge", "$P0", "$L12", "$L11"}, new Object[]{"if==than", "$P4", null, 1}, new Object[]{"push", "$L9", "$L12"}, new Object[]{"if!=than", "$P4", null, 2}, new Object[]{"if==than", "$L12.source", "$P4", 1}, new Object[]{"push", "$L9", "$L12"}, new Object[]{"math.add", "$L8", "$L8", 1}, new Object[]{"jumpRel", -10}, new Object[]{"set", "$P1", "$L9"}});
            this.put("refundCharge", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Identifier"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L0.requestBody", "charge=", "$P2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/refunds"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L3.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveRefund", "$P0", "$P1", "$L5"}});
            this.put("partiallyRefundCharge", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Identifier"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "Amount"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.concat", "$L0.requestBody", "charge=", "$P2", "&amount=", "$P3"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/refunds"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L3.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveRefund", "$P0", "$P1", "$L5"}});
            this.put("getRefund", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Identifier"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L1", "https://api.stripe.com/v1/refunds/", "$P2"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveRefund", "$P0", "$P1", "$L5"}});
            this.put("getRefundsForCharge", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Identifier"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L1", "https://api.stripe.com/v1/charges/", "$P2"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"create", "$L6", "Array"}, new Object[]{"set", "$L7", "$L5.refunds.data"}, new Object[]{"size", "$L8", "$L7"}, new Object[]{"create", "$L9", "Number", 0}, new Object[]{"if<than", "$L9", "$L8", 5}, new Object[]{"get", "$L10", "$L7", "$L9"}, new Object[]{"callFunc", "getRefund", "$P0", "$L11", "$L10.id"}, new Object[]{"push", "$L6", "$L11"}, new Object[]{"math.add", "$L9", "$L9", 1}, new Object[]{"jumpRel", -6}, new Object[]{"set", "$P1", "$L6"}});
            this.put("createSubscriptionPlan", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Name"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P4", "Currency"}, new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P5", "Description"}, new Object[]{"callFunc", "checkNull", "$P0", "$P6", "Interval"}, new Object[]{"callFunc", "checkNull", "$P0", "$P7", "Interval count"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P3", "Amount"}, new Object[]{"callFunc", "checkLessThanZero", "$P0", "$P7", "Interval Count"}, new Object[]{"callFunc", "checkInterval", "$P0", "$P6"}, new Object[]{"callFunc", "checkCurrency", "$P0", "$P4"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"string.urlEncode", "$L10", "$P2"}, new Object[]{"string.concat", "$L0.requestBody", "name=", "$L10", "&amount=", "$P3", "&currency=", "$P4", "&statement_descriptor=", "$P5", "&interval=", "$P6", "&interval_count=", "$P7", "&id=", "$L10"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/plans"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L3.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"callFunc", "retrieveSubscriptionPlan", "$P0", "$P1", "$L5"}});
            this.put("listSubscriptionPlans", new Object[]{new Object[]{"create", "$L0", "Array"}, new Object[]{"callFunc", "getListSubscriptions", "$P0", "$L0", null}, new Object[]{"size", "$L2", "$L0"}, new Object[]{"create", "$L3", "Number", 0}, new Object[]{"create", "$L5", "Array"}, new Object[]{"if<than", "$L3", "$L2", 5}, new Object[]{"get", "$L4", "$L0", "$L3"}, new Object[]{"callFunc", "retrieveSubscriptionPlan", "$P0", "$L6", "$L4"}, new Object[]{"push", "$L5", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -6}, new Object[]{"set", "$P1", "$L5"}});
            this.put("createSubscription", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P2", "Plan Identifier"}, new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P3", "Name"}, new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P4", "Description"}, new Object[]{"callFunc", "checkNull", "$P0", "$P5", "CreditCard"}, new Object[]{"callFunc", "createCustomer", "$P0", "$L0", "$P5"}, new Object[]{"set", "$L1", "$L0.id"}, new Object[]{"callFunc", "retrieveCustomerSource", "$P0", "$L2", "$L0"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"set", "$L3.method", "POST"}, new Object[]{"string.urlEncode", "$L15", "$P4"}, new Object[]{"string.urlEncode", "$L16", "$P3"}, new Object[]{"string.concat", "$L3.requestBody", "plan=", "$P2", "&customer=", "$L1", "&", "metadata[description]=", "$L15", "&metadata[name]=", "$L16"}, new Object[]{"stream.stringToStream", "$L3.requestBody", "$L3.requestBody"}, new Object[]{"string.concat", "$L3.url", "https://api.stripe.com/v1/subscriptions"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L4"}, new Object[]{"set", "$L4.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L3.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L5", "$L3"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L5"}, new Object[]{"json.parse", "$L6", "$L5.responseBody"}, new Object[]{"callFunc", "retrieveSubscription", "$P0", "$P1", "$L6", "$L2"}});
            this.put("cancelSubscription", new Object[]{new Object[]{"callFunc", "checkStringNullOrEmpty", "$P0", "$P1", "Identifier"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "DELETE"}, new Object[]{"string.urlEncode", "$P1", "$P1"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/subscriptions/", "$P1"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L1"}, new Object[]{"set", "$L0.requestHeaders", "$L1"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L2"}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkStringNullOrEmpty", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P1", "", 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkLessThanZero", new Object[]{new Object[]{"if<=than", "$P1", 0, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be less than 0."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterEqualThan", new Object[]{new Object[]{"if>=than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be greater or equals than ", "$P4"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterThan", new Object[]{new Object[]{"if>than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be greater or equals than ", "$P4"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterThanToday", new Object[]{new Object[]{"create", "$L1", "Date"}, new Object[]{"if>than", "$P1", "$L1.time", 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be greater than current date"}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkCurrency", new Object[]{new Object[]{"size", "$L0", "$P1"}, new Object[]{"if!=than", "$L0", 3, 2}, new Object[]{"create", "$L1", "Error", "Currency code has to have three letters.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("addAuthenticationHeader", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"string.concat", "$L1", "$P0.secretKey", ":"}, new Object[]{"string.base64encode", "$L1", "$L1"}, new Object[]{"string.concat", "$L2", "Basic ", "$L1"}, new Object[]{"set", "$L0.Authorization", "$L2"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("createSource", new Object[]{new Object[]{"create", "$L0", "String"}, new Object[]{"string.concat", "$L0", "$L0", "source[exp_month]=", "$P2.expire_month", "&"}, new Object[]{"string.concat", "$L0", "$L0", "source[exp_year]=", "$P2.expire_year", "&"}, new Object[]{"string.concat", "$L0", "$L0", "source[number]=", "$P2.number", "&"}, new Object[]{"string.concat", "$L0", "$L0", "source[object]=", "card", "&"}, new Object[]{"string.concat", "$L0", "$L0", "source[cvc]=", "$P2.cvc", "&"}, new Object[]{"if!=than", "$P2.address", null, 12}, new Object[]{"if!=than", "$P2.address.city", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_city]=", "$P2.address.city", "&"}, new Object[]{"if!=than", "$P2.address.country", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_country]=", "$P2.address.country", "&"}, new Object[]{"if!=than", "$P2.address.line1", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_line1]=", "$P2.address.line1", "&"}, new Object[]{"if!=than", "$P2.address.line2", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_line2]=", "$P2.address.line2", "&"}, new Object[]{"if!=than", "$P2.address.state", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_state]=", "$P2.address.state", "&"}, new Object[]{"if!=than", "$P2.address.postalCode", null, 1}, new Object[]{"string.concat", "$L0", "$L0", "source[address_zip]=", "$P2.address.postalCode", "&"}, new Object[]{"if==than", "$P2.firstName", null, 1}, new Object[]{"set", "$P2.firstName", ""}, new Object[]{"if==than", "$P2.lastName", null, 1}, new Object[]{"set", "$P2.lastName", ""}, new Object[]{"string.concat", "$L1", "$P2.firstName", " ", "$P2.lastName"}, new Object[]{"string.urlEncode", "$L1", "$L1"}, new Object[]{"string.concat", "$L0", "$L0", "source[name]=", "$L1", "&"}, new Object[]{"string.concat", "$L0", "$L0", "metadata[firstName]=", "$P2.firstName", "&"}, new Object[]{"string.concat", "$L0", "$L0", "metadata[lastName]=", "$P2.lastName"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("retrieveCharge", new Object[]{new Object[]{"set", "$L10", "$P2.id"}, new Object[]{"set", "$L11", "$P2.amount"}, new Object[]{"set", "$L12", "$P2.currency"}, new Object[]{"set", "$L13", "$P2.created"}, new Object[]{"set", "$L14", "$P2.status"}, new Object[]{"set", "$L15", "$P2.refunded"}, new Object[]{"callFunc", "retrieveSource", "$P0", "$L1", "$P2.source", "$P2.metadata"}, new Object[]{"create", "$L0", "Charge", "$L11", "$L13", "$L12", "$L10", "$L15", "$L1", "$L14"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("retrieveSource", new Object[]{new Object[]{"string.concat", "$L16", "xxxxxxxxxxxx", "$P2.last4"}, new Object[]{"set", "$L17", "$P2.exp_month"}, new Object[]{"set", "$L18", "$P2.exp_year"}, new Object[]{"string.lowerCase", "$L19", "$P2.brand"}, new Object[]{"create", "$L20", "String", ""}, new Object[]{"create", "$L21", "String", ""}, new Object[]{"if!=than", "$P3.firstName", null, 2}, new Object[]{"set", "$L20", "$P3.firstName"}, new Object[]{"set", "$L21", "$P3.lastName"}, new Object[]{"if==than", "$P3.firstName", null, 14}, new Object[]{"if!=than", "$P2.name", null, 13}, new Object[]{"create", "$L2", "Array"}, new Object[]{"string.split", "$L2", "$P2.name", " "}, new Object[]{"size", "$L3", "$L2"}, new Object[]{"create", "$L4", "Number"}, new Object[]{"get", "$L20", "$L2", "$L4"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"create", "$L6", "String", ""}, new Object[]{"if<than", "$L4", "$L3", 4}, new Object[]{"get", "$L5", "$L2", "$L4"}, new Object[]{"string.concat", "$L6", "$L6", "$L5"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -5}, new Object[]{"set", "$L21", "$L6"}, new Object[]{"create", "$L7", "Address"}, new Object[]{"if!=than", "$P2.address_country", null, 1}, new Object[]{"set", "$L7.country", "$P2.address_country"}, new Object[]{"if!=than", "$P2.address_city", null, 1}, new Object[]{"set", "$L7.city", "$P2.address_city"}, new Object[]{"if!=than", "$P2.address_state", null, 1}, new Object[]{"set", "$L7.state", "$P2.address_state"}, new Object[]{"if!=than", "$P2.address_line1", null, 1}, new Object[]{"set", "$L7.line1", "$P2.address_line1"}, new Object[]{"if!=than", "$P2.address_line2", null, 1}, new Object[]{"set", "$L7.line2", "$P2.address_line2"}, new Object[]{"if!=than", "$P2.address_zip", null, 1}, new Object[]{"set", "$L7.postalCode", "$P2.address_zip"}, new Object[]{"create", "$L1", "CreditCard", null, "$L17", "$L18", "$L16", "$L19", "$L20", "$L21", "$L7"}, new Object[]{"set", "$P1", "$L1"}});
            this.put("getListCharges", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L20", "$P2"}, new Object[]{"string.concat", "$L20", "$L20", ""}, new Object[]{"string.substring", "$L20", "$L20", 0, 10}, new Object[]{"math.add", "$L20", "$L20", 0}, new Object[]{"set", "$L21", "$P3"}, new Object[]{"string.concat", "$L21", "$L21", ""}, new Object[]{"string.substring", "$L21", "$L21", 0, 10}, new Object[]{"math.add", "$L21", "$L21", 0}, new Object[]{"string.concat", "$L1", "created%5Bgte%5D=", "$L20", "&", "created%5Blte%5D=", "$L21", "&limit=", "100"}, new Object[]{"if!=than", "$P4", null, 1}, new Object[]{"string.concat", "$L1", "$L1", "&", "starting_after=", "$P4"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L2", "https://api.stripe.com/v1/charges", "?", "$L1"}, new Object[]{"set", "$L0.url", "$L2"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"set", "$L10", "$L5.data"}, new Object[]{"size", "$L11", "$L10"}, new Object[]{"create", "$L12", "Number", 0}, new Object[]{"if<than", "$L12", "$L11", 4}, new Object[]{"get", "$L13", "$L10", "$L12"}, new Object[]{"push", "$P1", "$L13"}, new Object[]{"math.add", "$L12", "$L12", 1}, new Object[]{"jumpRel", -5}, new Object[]{"if==than", "$L5.has_more", 0, 1}, new Object[]{"return"}, new Object[]{"size", "$L6", "$P1"}, new Object[]{"math.add", "$L6", "$L6", -1}, new Object[]{"get", "$L7", "$P1", "$L6"}, new Object[]{"callFunc", "getListCharges", "$P0", "$P1", "$P2", "$P3", "$L7.id"}});
            this.put("getListSubscriptions", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L1", "https://api.stripe.com/v1/plans?limit=100"}, new Object[]{"if!=than", "$P2", null, 2}, new Object[]{"string.urlEncode", "$P2", "$P2"}, new Object[]{"string.concat", "$L1", "$L1", "&starting_after=", "$P2"}, new Object[]{"set", "$L0.url", "$L1"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$L5", "$L4.responseBody"}, new Object[]{"create", "$L10", "Array"}, new Object[]{"set", "$L10", "$L5.data"}, new Object[]{"size", "$L11", "$L10"}, new Object[]{"create", "$L12", "Number", 0}, new Object[]{"if<than", "$L12", "$L11", 4}, new Object[]{"get", "$L13", "$L10", "$L12"}, new Object[]{"push", "$P1", "$L13"}, new Object[]{"math.add", "$L12", "$L12", 1}, new Object[]{"jumpRel", -5}, new Object[]{"if==than", "$L5.has_more", 0, 1}, new Object[]{"return"}, new Object[]{"size", "$L6", "$P1"}, new Object[]{"math.add", "$L6", "$L6", -1}, new Object[]{"get", "$L7", "$P1", "$L6"}, new Object[]{"callFunc", "getListSubscriptions", "$P0", "$P1", "$L7.id"}});
            this.put("retrieveRefund", new Object[]{new Object[]{"set", "$L0", "$P2.amount"}, new Object[]{"set", "$L1", "$P2.charge"}, new Object[]{"set", "$L2", "$P2.created"}, new Object[]{"set", "$L3", "$P2.id"}, new Object[]{"set", "$L4", "$P2.status"}, new Object[]{"set", "$L5", "$P2.currency"}, new Object[]{"string.upperCase", "$L5", "$L5"}, new Object[]{"create", "$L6", "Refund", "$L0", "$L1", "$L2", "$L3", "$L4", "$L5"}, new Object[]{"set", "$P1", "$L6"}});
            this.put("retrieveSubscriptionPlan", new Object[]{new Object[]{"set", "$L0", "$P2.id"}, new Object[]{"set", "$L1", "$P2.amount"}, new Object[]{"set", "$L3", "$P2.created"}, new Object[]{"set", "$L4", "$P2.currency"}, new Object[]{"string.upperCase", "$L4", "$L4"}, new Object[]{"set", "$L5", "$P2.interval"}, new Object[]{"set", "$L6", "$P2.interval_count"}, new Object[]{"set", "$L7", "$P2.name"}, new Object[]{"set", "$L8", "$P2.statement_descriptor"}, new Object[]{"math.add", "$L6", "$L6", 0}, new Object[]{"create", "$L9", "SubscriptionPlan", "$L1", "$L3", "$L4", "$L8", "$L0", "$L5", "$L6", "$L7"}, new Object[]{"set", "$P1", "$L9"}});
            this.put("retrieveSubscription", new Object[]{new Object[]{"set", "$L0", "$P2.created"}, new Object[]{"set", "$L1", "$P2.metadata.description"}, new Object[]{"set", "$L2", "$P2.id"}, new Object[]{"set", "$L3", "$P2. current_period_start"}, new Object[]{"set", "$L4", "$P2.metadata.name"}, new Object[]{"set", "$L5", "$P2.current_period_end"}, new Object[]{"set", "$L6", "$P3"}, new Object[]{"set", "$L7", "$P2.status"}, new Object[]{"set", "$L8", "$P2.plan.id"}, new Object[]{"create", "$L9", "Subscription", "$L0", "$L1", "$L2", "$L3", "$L4", "$L5", "$L6", "$L7", "$L8"}, new Object[]{"set", "$P1", "$L9"}});
            this.put("createCustomer", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"create", "$L1", "String"}, new Object[]{"callFunc", "createSource", "$P0", "$L2", "$P2"}, new Object[]{"string.concat", "$L0.requestBody", "$L2"}, new Object[]{"stream.stringToStream", "$L0.requestBody", "$L0.requestBody"}, new Object[]{"string.concat", "$L0.url", "https://api.stripe.com/v1/customers"}, new Object[]{"callFunc", "addAuthenticationHeader", "$P0", "$L3"}, new Object[]{"set", "$L3.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"set", "$L0.requestHeaders", "$L3"}, new Object[]{"http.requestCall", "$L4", "$L0"}, new Object[]{"callFunc", "checkHttpErrors", "$P0", "$L4"}, new Object[]{"json.parse", "$P1", "$L4.responseBody"}});
            this.put("retrieveCustomerSource", new Object[]{new Object[]{"create", "$L0", "Array"}, new Object[]{"set", "$L0", "$P2.sources.data"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"if>than", "$L1", 0, 1}, new Object[]{"get", "$L2", "$L0", 0}, new Object[]{"set", "$L2", "$L2"}, new Object[]{"callFunc", "retrieveSource", "$P0", "$L3", "$L2", "$P2.metadata"}, new Object[]{"set", "$P1", "$L3"}});
            this.put("checkInterval", new Object[]{new Object[]{"if!=than", "$P1", "day", 5}, new Object[]{"if!=than", "$P1", "month", 4}, new Object[]{"if!=than", "$P1", "week", 3}, new Object[]{"if!=than", "$P1", "year", 2}, new Object[]{"create", "$L0", "Error", "Interval must be one of day, month, week, year", "IllegalArgument"}, new Object[]{"throwError", "$L0"}});
            this.put("checkHttpErrors", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 27}, new Object[]{"if>=than", "$P1.code", 500, 8}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"string.concat", "$L10", "The returned code was ", "$P1.code", " ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L10", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 3}, new Object[]{"string.concat", "$L10", "The reurned code was ", "$P1.code", " ", "$P1.message"}, new Object[]{"create", "$L3", "Error", "$L10", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"set", "$L1", "$L0.error"}, new Object[]{"set", "$L2", "$L1.message"}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 400, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if>=than", "$P1.code", 402, 5}, new Object[]{"if<=than", "$P1.code", 509, 4}, new Object[]{"if!=than", "$P1.code", 503, 3}, new Object[]{"if!=than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 404, 2}, new Object[]{"create", "$L3", "Error", "$L2", "NotFound"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Stripe(RedirectReceiver redirectReceiver, String secretKey) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Stripe").start();
        this.interpreterStorage.put("secretKey", secretKey);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public Charge createCharge(Long amount, String currency, CreditCard source) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "createCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createCharge", this.interpreterStorage, null, amount, currency, source);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "createCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Charge)ip.getParameter(1);
    }

    @Override
    public Charge getCharge(String id) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "getCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "getCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Charge)ip.getParameter(1);
    }

    @Override
    public List<Charge> listCharges(Long from, Long to, CreditCard creditCard) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "listCharges").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listCharges", this.interpreterStorage, null, from, to, creditCard);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "listCharges").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public Refund refundCharge(String id) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "refundCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("refundCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "refundCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public Refund partiallyRefundCharge(String id, Long amount) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "partiallyRefundCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("partiallyRefundCharge", this.interpreterStorage, null, id, amount);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "partiallyRefundCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public Refund getRefund(String id) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "getRefund").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getRefund", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "getRefund").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Refund)ip.getParameter(1);
    }

    @Override
    public List<Refund> getRefundsForCharge(String id) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "getRefundsForCharge").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getRefundsForCharge", this.interpreterStorage, null, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "getRefundsForCharge").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public SubscriptionPlan createSubscriptionPlan(String name, Long amount, String currency, String description, String interval, Long intervalCount) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "createSubscriptionPlan").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createSubscriptionPlan", this.interpreterStorage, null, name, amount, currency, description, interval, intervalCount);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "createSubscriptionPlan").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (SubscriptionPlan)ip.getParameter(1);
    }

    @Override
    public List<SubscriptionPlan> listSubscriptionPlans() {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "listSubscriptionPlans").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("listSubscriptionPlans", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "listSubscriptionPlans").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    @Override
    public Subscription createSubscription(String planID, String name, String description, CreditCard source) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "createSubscription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("createSubscription", this.interpreterStorage, null, planID, name, description, source);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "createSubscription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (Subscription)ip.getParameter(1);
    }

    @Override
    public void cancelSubscription(String id) {
        CloudRail.validateKey();
        new ReportCallTask("Stripe", "cancelSubscription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("cancelSubscription", this.interpreterStorage, id);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Stripe", "cancelSubscription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

