/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.SMS;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Twilio
implements SMS {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("sendSMSTW", new Object[]{new Object[]{"callFunc", "validateUserInput", "$P0", "$P1", "$P2", "$P3"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "POST"}, new Object[]{"string.concat", "$L0.url", "https://api.twilio.com/2010-04-01/Accounts/", "$P0.accountSid", "/Messages.json"}, new Object[]{"string.urlEncode", "$P1", "$P1"}, new Object[]{"string.urlEncode", "$P2", "$P2"}, new Object[]{"string.urlEncode", "$P3", "$P3"}, new Object[]{"string.concat", "$L1", "From=", "$P1", "&To=", "$P2", "&Body=", "$P3"}, new Object[]{"stream.stringToStream", "$L3", "$L1"}, new Object[]{"set", "$L0.requestBody", "$L3"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L4", "$P0.accountSid", ":", "$P0.authToken"}, new Object[]{"string.base64encode", "$L5", "$L4"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Basic ", "$L5"}, new Object[]{"set", "$L0.requestHeaders.Content-Type", "application/x-www-form-urlencoded"}, new Object[]{"create", "$L6", "Object"}, new Object[]{"http.requestCall", "$L6", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"debug.out", "$L7"}});
            this.put("validateUserInput", new Object[]{new Object[]{"if==than", "$P1", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P2", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if==than", "$P3", null, 2}, new Object[]{"create", "$L1", "Error", "One of the arguments is 'null'. You need to assign a value to it.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P1"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'From' number parameter is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P2"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'To' number parameter is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P3"}, new Object[]{"if==than", "$L2", 0, 2}, new Object[]{"create", "$L1", "Error", "The message is empty.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P1"}, new Object[]{"if<than", "$L2", 21, 4}, new Object[]{"string.lastIndexOf", "$L0", "$P1", "+"}, new Object[]{"if!=than", "$L0", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'From' phone number or ID is wrong. It should be either a phone number in E.164 format (e.g. +16175551212) or a MessagingServiceSid (e.g. MGec9516eb5a051a6b2901748b925a5a43).", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"if>than", "$L2", 34, 2}, new Object[]{"create", "$L1", "Error", "The 'From' phone number or ID is wrong. It should be either a phone number in E.164 format (e.g. +16175551212) or a MessagingServiceSid (e.g. MGec9516eb5a051a6b2901748b925a5a43).", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"string.lastIndexOf", "$L0", "$P2", "+"}, new Object[]{"if!=than", "$L0", 0, 2}, new Object[]{"create", "$L1", "Error", "The 'To' phone number isn't in E.164 format. Example: +16175551212", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P2"}, new Object[]{"if>than", "$L2", 16, 2}, new Object[]{"create", "$L1", "Error", "The 'To' phone number is too big, it should have maximum 15 digits. Example: +16175551212", "IllegalArgument"}, new Object[]{"throwError", "$L1"}, new Object[]{"size", "$L2", "$P3"}, new Object[]{"if>than", "$L2", 1600, 2}, new Object[]{"create", "$L1", "Error", "The length of the message exceeds the 1600 allowed characters.", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 10}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$L0.message"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Twilio(RedirectReceiver redirectReceiver, String accountSid, String authToken) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Twilio").start();
        this.interpreterStorage.put("accountSid", accountSid);
        this.interpreterStorage.put("authToken", authToken);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    public void sendSMS(String fromName, String toNumber, String content) {
        CloudRail.validateKey();
        new ReportCallTask("Twilio", "sendSMS").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("sendSMSTW", this.interpreterStorage, fromName, toNumber, content);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Twilio", "sendSMS").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

