/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.Profile;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.DateOfBirth;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Yahoo
implements Profile {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("getYUIdentifier", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"string.concat", "$P1", "yahoo-", "$P0.userID"}});
            this.put("getYUFullName", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"if==than", "$P0.cachedObject.profile.givenName", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"jumpRel", 2}, new Object[]{"string.concat", "$L0", "$P0.cachedObject.profile.givenName", " ", "$P0.cachedObject.profile.familyName"}, new Object[]{"set", "$P1", "$L0"}});
            this.put("getYUEmail", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"if==than", "$P0.cachedObject.profile.emails.0.handle", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P1", "$P0.cachedObject.profile.emails.0.handle"}});
            this.put("getYUGender", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"if==than", "$P0.cachedObject.profile.gender", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"jumpRel", 8}, new Object[]{"if==than", "$P0.cachedObject.profile.gender", "M", 2}, new Object[]{"set", "$P1", "male"}, new Object[]{"jumpRel", 5}, new Object[]{"if==than", "$P0.cachedObject.profile.gender", "F", 2}, new Object[]{"set", "$P1", "female"}, new Object[]{"jumpRel", 2}, new Object[]{"if==than", "$P0.cachedObject.profile.gender", "Unspecified", 1}, new Object[]{"set", "$P1", "other"}});
            this.put("getYUDescription", new Object[]{new Object[]{"set", "$P1", null}});
            this.put("getYUDateOfBirth", new Object[]{new Object[]{"create", "$P1", "DateOfBirth"}});
            this.put("getYULocale", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"if==than", "$P0.cachedObject.profile.lang", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"jumpRel", 1}, new Object[]{"string.substring", "$P1", "$P0.cachedObject.profile.lang", 0, 2}});
            this.put("getYUPictureURL", new Object[]{new Object[]{"callFunc", "checkAuthentication", "$P0"}, new Object[]{"if==than", "$P0.cachedObject", null, 2}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}, new Object[]{"jumpRel", 1}, new Object[]{"callFunc", "checkExpirationTime", "$P0"}, new Object[]{"if==than", "$P0.cachedObject.profile.image.imageUrl", null, 2}, new Object[]{"set", "$P1", null}, new Object[]{"jumpRel", 1}, new Object[]{"set", "$P1", "$P0.cachedObject.profile.image.imageUrl"}});
            this.put("loginYU", new Object[]{new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}});
            this.put("logoutYU", new Object[]{new Object[]{"set", "$S0.accessToken", null}, new Object[]{"set", "$P0.userID", null}, new Object[]{"set", "$P0.cachedObject", null}});
            this.put("getUserID", new Object[]{new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://social.yahooapis.com/v1/me/guid"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"create", "$L2", "Object"}, new Object[]{"json.parse", "$L2", "$L1.responseBody"}, new Object[]{"set", "$P0.userID", "$L2.guid.value"}});
            this.put("makeHTTPRequest", new Object[]{new Object[]{"callFunc", "getUserID", "$P0"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"string.concat", "$L0.url", "https://social.yahooapis.com/v1/user/", "$P0.userID", "/profile"}, new Object[]{"create", "$L0.requestHeaders", "Object"}, new Object[]{"string.concat", "$L0.requestHeaders.Authorization", "Bearer ", "$S0.accessToken"}, new Object[]{"set", "$L0.requestHeaders.Accept", "application/json"}, new Object[]{"create", "$L1", "Object"}, new Object[]{"http.requestCall", "$L1", "$L0"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L1"}, new Object[]{"json.parse", "$P0.cachedObject", "$L1.responseBody"}, new Object[]{"create", "$L2", "Date"}, new Object[]{"set", "$P0.readTime", "$L2.time"}});
            this.put("checkExpirationTime", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"math.multiply", "$L1", "$P0.readTime", -1}, new Object[]{"math.add", "$L2", "$L0.time", "$L1"}, new Object[]{"if>than", "$L2", 60000, 1}, new Object[]{"callFunc", "makeHTTPRequest", "$P0"}});
            this.put("checkAuthentication", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"if==than", "$S0.accessToken", null, 2}, new Object[]{"callFunc", "authenticate", "$P0", "accessToken"}, new Object[]{"return"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"set", "$L1.time", "$S0.expireIn"}, new Object[]{"if<than", "$L1", "$L0", 1}, new Object[]{"callFunc", "authenticate", "$P0", "refreshToken"}});
            this.put("authenticate", new Object[]{new Object[]{"if==than", "$P1", "accessToken", 4}, new Object[]{"string.concat", "$L0", "https://api.login.yahoo.com/oauth2/request_auth?client_id=", "$P0.clientId", "&redirect_uri=", "$P0.redirectUri", "&response_type=code&language=en-us"}, new Object[]{"awaitCodeRedirect", "$L1", "$L0"}, new Object[]{"string.concat", "$L2", "redirect_uri=", "$P0.redirectUri", "&code=", "$L1", "&grant_type=authorization_code"}, new Object[]{"jumpRel", 1}, new Object[]{"string.concat", "$L2", "redirect_uri=", "$P0.redirectUri", "&refresh_token=", "$S0.refreshToken", "&grant_type=refresh_token"}, new Object[]{"stream.stringToStream", "$L3", "$L2"}, new Object[]{"create", "$L4", "Object"}, new Object[]{"set", "$L4", "application/x-www-form-urlencoded", "Content-Type"}, new Object[]{"string.concat", "$L15", "$P0.clientId", ":", "$P0.clientSecret"}, new Object[]{"string.base64encode", "$L15", "$L15"}, new Object[]{"string.concat", "$L4.Authorization", "Basic ", "$L15"}, new Object[]{"create", "$L5", "Object"}, new Object[]{"set", "$L5.url", "https://api.login.yahoo.com/oauth2/get_token"}, new Object[]{"set", "$L5.method", "POST"}, new Object[]{"set", "$L5.requestBody", "$L3"}, new Object[]{"set", "$L5.requestHeaders", "$L4"}, new Object[]{"http.requestCall", "$L6", "$L5"}, new Object[]{"callFunc", "validateResponse", "$P0", "$L6"}, new Object[]{"create", "$L7", "String"}, new Object[]{"stream.streamToString", "$L7", "$L6.responseBody"}, new Object[]{"json.parse", "$L8", "$L7"}, new Object[]{"set", "$S0.accessToken", "$L8.access_token"}, new Object[]{"set", "$S0.refreshToken", "$L8.refresh_token"}, new Object[]{"create", "$L10", "Date"}, new Object[]{"math.multiply", "$L9", "$L8.expires_in", 1000}, new Object[]{"math.add", "$L9", "$L9", "$L10.time", -60000}, new Object[]{"set", "$S0.expireIn", "$L9"}});
            this.put("validateResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 10}, new Object[]{"if==than", "$P1.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P1.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"stream.streamToString", "$L0", "$P1.responseBody"}, new Object[]{"string.concat", "$L2", "$P1.code", " - ", "$L0"}, new Object[]{"create", "$L3", "Error", "$L2", "Http"}, new Object[]{"throwError", "$L3"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Yahoo(RedirectReceiver redirectReceiver, String clientId, String clientSecret, String redirectUri, String state) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Yahoo").start();
        this.interpreterStorage.put("clientId", clientId);
        this.interpreterStorage.put("clientSecret", clientSecret);
        this.interpreterStorage.put("redirectUri", redirectUri);
        this.interpreterStorage.put("state", state);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    public String getIdentifier() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getIdentifier").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUIdentifier", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getIdentifier").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getFullName() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getFullName").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUFullName", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getFullName").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getEmail() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getEmail").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUEmail", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getEmail").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getGender() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getGender").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUGender", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getGender").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getDescription() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getDescription").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUDescription", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getDescription").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public DateOfBirth getDateOfBirth() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getDateOfBirth").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUDateOfBirth", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getDateOfBirth").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (DateOfBirth)ip.getParameter(1);
    }

    public String getLocale() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getLocale").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYULocale", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getLocale").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public String getPictureURL() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "getPictureURL").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getYUPictureURL", this.interpreterStorage, null);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "getPictureURL").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (String)ip.getParameter(1);
    }

    public void login() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "login").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("loginYU", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "login").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public void logout() {
        CloudRail.validateKey();
        new ReportCallTask("Yahoo", "logout").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("logoutYU", this.interpreterStorage);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yahoo", "logout").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

